/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.application;

import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.request.ApplicationReceivePipeline;
import io.ktor.server.response.ApplicationSendPipeline;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.util.pipeline.PipelinePhase;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public class ApplicationCallPipeline
extends Pipeline<Unit, PipelineCall> {
    @NotNull
    public static final ApplicationPhase ApplicationPhase = new ApplicationPhase(null);
    private final boolean developmentMode;
    @NotNull
    private final ApplicationEnvironment environment;
    @NotNull
    private final ApplicationReceivePipeline receivePipeline;
    @NotNull
    private final ApplicationSendPipeline sendPipeline;
    @NotNull
    private static final PipelinePhase Setup = new PipelinePhase("Setup");
    @NotNull
    private static final PipelinePhase Monitoring = new PipelinePhase("Monitoring");
    @NotNull
    private static final PipelinePhase Plugins = new PipelinePhase("Plugins");
    @NotNull
    private static final PipelinePhase Call = new PipelinePhase("Call");
    @NotNull
    private static final PipelinePhase Fallback = new PipelinePhase("Fallback");
    @NotNull
    private static final PipelinePhase Features = Plugins;

    public ApplicationCallPipeline(boolean developmentMode, @NotNull ApplicationEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        PipelinePhase[] pipelinePhaseArray = new PipelinePhase[]{Setup, Monitoring, Plugins, Call, Fallback};
        super(pipelinePhaseArray);
        this.developmentMode = developmentMode;
        this.environment = environment;
        this.receivePipeline = new ApplicationReceivePipeline(this.developmentMode);
        this.sendPipeline = new ApplicationSendPipeline(this.developmentMode);
    }

    public final boolean getDevelopmentMode() {
        return this.developmentMode;
    }

    @NotNull
    public final ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final ApplicationReceivePipeline getReceivePipeline() {
        return this.receivePipeline;
    }

    @NotNull
    public final ApplicationSendPipeline getSendPipeline() {
        return this.sendPipeline;
    }

    public static final class ApplicationPhase {
        private ApplicationPhase() {
        }

        @NotNull
        public final PipelinePhase getPlugins() {
            return Plugins;
        }

        @NotNull
        public final PipelinePhase getCall() {
            return Call;
        }

        @NotNull
        public final PipelinePhase getFallback() {
            return Fallback;
        }

        public /* synthetic */ ApplicationPhase(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

