/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PriorityQueue<T>
implements Collection<T>,
KMutableCollection {
    @NotNull
    private final Comparator<T> comparator;
    @NotNull
    private final ArrayList<T> heap;

    public PriorityQueue(@NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.comparator = comparator;
        this.heap = new ArrayList();
    }

    @Override
    public boolean contains(Object element) {
        return this.heap.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.heap.containsAll(elements);
    }

    public int getSize() {
        return this.heap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.heap.isEmpty();
    }

    @Override
    public boolean add(T element) {
        this.heap.add(element);
        this.siftUp(this.size() - 1, element);
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        for (T element : elements) {
            this.add(element);
        }
        return true;
    }

    public final int indexOf(T elem) {
        return this.heap.indexOf(elem);
    }

    @Override
    public boolean remove(Object element) {
        int index = this.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    private final void removeAt(int index) {
        if (!(0 <= index ? index < ((Collection)this).size() : false)) {
            throw new IndexOutOfBoundsException();
        }
        int s = this.size() - 1;
        if (s == index) {
            this.heap.removeLast();
            return;
        }
        T moved = this.heap.get(s);
        this.heap.removeLast();
        this.siftDown(index, moved);
        if (Intrinsics.areEqual(this.heap.get(index), moved)) {
            this.siftUp(index, moved);
            if (!Intrinsics.areEqual(this.heap.get(index), moved)) {
                return;
            }
        }
    }

    @Override
    public void clear() {
        this.heap.clear();
    }

    private final void siftUp(int index, T elem) {
        int parent;
        T parentElem;
        int i2 = index;
        while (i2 > 0 && this.comparator.compare(elem, parentElem = this.heap.get(parent = (i2 - 1) / 2)) < 0) {
            this.heap.set(i2, parentElem);
            i2 = parent;
        }
        this.heap.set(i2, elem);
    }

    private final void siftDown(int index, T elem) {
        int k = index;
        int half = this.size() / 2;
        while (k < half) {
            int left = 2 * k + 1;
            T oldElem = this.heap.get(left);
            int right = left + 1;
            if (right < this.size() && this.comparator.compare(oldElem, this.heap.get(right)) > 0) {
                oldElem = this.heap.get(right);
                left = right;
            }
            if (this.comparator.compare(elem, oldElem) <= 0) break;
            this.heap.set(k, oldElem);
            k = left;
        }
        this.heap.set(k, elem);
    }

    @Nullable
    public final T poll() {
        if (this.isEmpty()) {
            return null;
        }
        T res2 = this.peek();
        this.removeAt(0);
        return res2;
    }

    @Nullable
    public final T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.heap.get(0);
    }

    public final boolean removeIf(@NotNull Function1<? super T, Boolean> pred) {
        Object elem;
        Intrinsics.checkNotNullParameter(pred, (String)"pred");
        boolean removedElement = false;
        ArrayList<T> toBeRemoved = new ArrayList<T>();
        Iterator<T> iterator2 = this.heap.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            elem = iterator3.next();
            if (!((Boolean)pred.invoke(elem)).booleanValue()) continue;
            removedElement = true;
            toBeRemoved.add(elem);
        }
        Iterator iterator4 = toBeRemoved.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator3 = iterator4;
        while (iterator3.hasNext()) {
            elem = iterator3.next();
            this.remove(elem);
        }
        return removedElement;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator<T> iterator2 = this.heap.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        return iterator2;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.removeIf((Function1)new Function1<T, Boolean>(elements){
            final /* synthetic */ Collection<T> $elements;
            {
                this.$elements = $elements;
                super(1);
            }

            public final Boolean invoke(T elem) {
                return !this.$elements.contains(elem);
            }
        });
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.removeIf((Function1)new Function1<T, Boolean>(elements){
            final /* synthetic */ Collection<T> $elements;
            {
                this.$elements = $elements;
                super(1);
            }

            public final Boolean invoke(T elem) {
                return this.$elements.contains(elem);
            }
        });
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

