/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel;

import com.jetbrains.rhizomedb.DB;
import fleet.kernel.DbSource;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

public final class FlowDbSource
implements DbSource {
    @NotNull
    private final StateFlow<DB> stateFlow;
    @NotNull
    private final String debugName;

    public FlowDbSource(@NotNull StateFlow<DB> stateFlow, @NotNull String debugName) {
        Intrinsics.checkNotNullParameter(stateFlow, (String)"stateFlow");
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        this.stateFlow = stateFlow;
        this.debugName = debugName;
    }

    @Override
    @NotNull
    public String getDebugName() {
        return this.debugName;
    }

    @Override
    @NotNull
    public Flow<DB> getFlow() {
        return (Flow)this.stateFlow;
    }

    @Override
    @NotNull
    public DB getLatest() {
        return (DB)this.stateFlow.getValue();
    }

    @NotNull
    public String toString() {
        return "FlowDbSource(" + this.getDebugName() + ")";
    }
}

