/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.ints;

import fleet.fastutil.ints.IntArrays;
import fleet.fastutil.ints.IntList;
import fleet.fastutil.ints.IntListExtensionsKt;
import fleet.fastutil.ints.MutableIntList;
import java.util.Arrays;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntArrayList
implements MutableIntList,
Comparable<IntList> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int[] a;
    private int size;

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    private IntArrayList(int[] a, boolean wrapped) {
        this.a = a;
    }

    public IntArrayList() {
        this.a = IntArrays.INSTANCE.getDEFAULT_EMPTY_ARRAY();
    }

    public IntArrayList(@NotNull IntList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        this();
        IntRange intRange = IntListExtensionsKt.getIndices(list2);
        int i2 = intRange.getFirst();
        int n = intRange.getLast();
        if (i2 <= n) {
            while (true) {
                this.add(list2.get(i2));
                if (i2 == n) break;
                ++i2;
            }
        }
    }

    private final void grow(int capacity) {
        int[] nArray;
        int capacity2 = capacity;
        int[] nArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray2 = null;
        }
        if (capacity2 <= nArray2.length) {
            return;
        }
        int[] nArray3 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray3 = null;
        }
        if (!Arrays.equals(nArray = nArray3, IntArrays.INSTANCE.getDEFAULT_EMPTY_ARRAY())) {
            int[] nArray4 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                nArray4 = null;
            }
            int n = nArray4.length;
            int[] nArray5 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                nArray5 = null;
            }
            int n2 = n + (nArray5.length >> 1);
            int n3 = 0x7FFFFFF7;
            capacity2 = Math.max(Math.min(n2, n3), capacity2);
        } else if (capacity2 < 10) {
            capacity2 = 10;
        }
        int[] nArray6 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray6 = null;
        }
        this.a = IntArrays.INSTANCE.forceCapacity(nArray6, capacity2, this.getSize());
        int n = this.getSize();
        int[] nArray7 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray7 = null;
        }
        if (!(n <= nArray7.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public void add(int element) {
        this.grow(this.getSize() + 1);
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        int n = this.getSize();
        this.setSize(n + 1);
        nArray[n] = element;
        int n2 = this.getSize();
        int[] nArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray2 = null;
        }
        if (!(n2 <= nArray2.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Override
    public int get(int index) {
        if (index >= this.getSize() || index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + this.getSize());
        }
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        return nArray[index];
    }

    @Override
    public int removeAt(int index) {
        if (index >= this.getSize() || index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") out of bounds for length (" + this.getSize() + ")");
        }
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        int[] a = nArray;
        int old2 = a[index];
        this.setSize(this.getSize() - 1);
        if (index != this.getSize()) {
            ArraysKt.copyInto((int[])a, (int[])a, (int)index, (int)(index + 1), (int)(this.getSize() + 1));
        }
        if (!(this.getSize() <= a.length)) {
            throw new IllegalStateException("Check failed.");
        }
        return old2;
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof IntList && this.compareTo((IntList)o) == 0;
    }

    @Override
    public int compareTo(@NotNull IntList l) {
        int i2;
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        int s1 = IntListExtensionsKt.length(this);
        int s2 = IntListExtensionsKt.length(l);
        int e1 = 0;
        int e2 = 0;
        int r = 0;
        for (i2 = 0; i2 < s1 && i2 < s2; ++i2) {
            e1 = this.get(i2);
            e2 = l.get(i2);
            int n = e1 > e2 ? 1 : (r = e1 < e2 ? -1 : 0);
            if (r == 0) continue;
            return r;
        }
        return i2 < s2 ? -1 : (i2 < s1 ? 1 : 0);
    }

    public int hashCode() {
        int i2 = IntListExtensionsKt.getIndices(this).getFirst();
        int h = 1;
        int s = this.getSize();
        while (s-- != 0) {
            int k = this.get(i2++);
            h = 31 * h + k;
        }
        return h;
    }

    @NotNull
    public String toString() {
        StringBuilder s = new StringBuilder();
        int i2 = IntListExtensionsKt.getIndices(this).getFirst();
        int n = this.getSize();
        int k = 0;
        boolean first = true;
        s.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            k = this.get(i2);
            ++i2;
            s.append(String.valueOf(k));
        }
        s.append("]");
        String string = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public /* synthetic */ IntArrayList(int[] a, boolean wrapped, DefaultConstructorMarker $constructor_marker) {
        this(a, wrapped);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntArrayList wrap(@NotNull int[] a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return this.wrap(a, a.length);
        }

        @NotNull
        public final IntArrayList wrap(@NotNull int[] a, int length) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            if (length > a.length) {
                throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
            }
            IntArrayList l = new IntArrayList(a, true, null);
            l.setSize(length);
            return l;
        }

        @NotNull
        public final IntArrayList of() {
            return new IntArrayList();
        }

        @NotNull
        public final IntArrayList of(int ... init) {
            Intrinsics.checkNotNullParameter((Object)init, (String)"init");
            return this.wrap(init);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

