/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil;

import org.jetbrains.annotations.NotNull;

public final class HashCommon {
    @NotNull
    public static final HashCommon INSTANCE = new HashCommon();

    private HashCommon() {
    }

    public final int mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }

    public final long mix(long x) {
        long h = x * -7046029254386353131L;
        h ^= h >>> 32;
        return h ^ h >>> 16;
    }

    public final int nextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public final long nextPowerOfTwo(long x) {
        return 1L << 64 - Long.numberOfLeadingZeros(x - 1L);
    }

    public final int maxFill(int n, float f) {
        return (int)Math.min((double)((int)Math.ceil((float)n * f)), (double)(n - 1));
    }

    public final int arraySize(int expected, float f) {
        long s = (long)Math.max(2.0, (double)this.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }
}

