/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.window;

import com.jetbrains.fus.reporting.schema.EventId;
import com.jetbrains.toolbox.JetBrainsAnalytics;
import com.jetbrains.toolbox.MutableWindowManager;
import com.jetbrains.toolbox.UIEvent;
import com.jetbrains.toolbox.UIGlobalStateManager;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.window.WindowState;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WindowManagerImpl
implements MutableWindowManager {
    @NotNull
    private final JetBrainsAnalytics fus;
    @NotNull
    private final UIGlobalStateManager state;
    @NotNull
    private final MutableStateFlow<WindowState> _windowState;
    @NotNull
    private final StateFlow<WindowState> windowState;
    @NotNull
    private final MutableStateFlow<Boolean> _isWindowFocused;
    @NotNull
    private final StateFlow<Boolean> isWindowFocused;

    public WindowManagerImpl(@NotNull JetBrainsAnalytics fus, @NotNull UIGlobalStateManager state2) {
        Intrinsics.checkNotNullParameter((Object)fus, (String)"fus");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.fus = fus;
        this.state = state2;
        this._windowState = StateFlowKt.MutableStateFlow((Object)((Object)WindowState.Closed));
        this.windowState = FlowKt.asStateFlow(this._windowState);
        this._isWindowFocused = StateFlowKt.MutableStateFlow((Object)false);
        this.isWindowFocused = FlowKt.asStateFlow(this._isWindowFocused);
    }

    @Override
    @NotNull
    public StateFlow<WindowState> getWindowState() {
        return this.windowState;
    }

    @Override
    @NotNull
    public StateFlow<Boolean> isWindowFocused() {
        return this.isWindowFocused;
    }

    @Override
    public void updateWindowState(@NotNull WindowState state2) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        EventId event = switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
            case 1 -> Fus.Counters.Performance.INSTANCE.getWindowActivated();
            case 2 -> Fus.Counters.Performance.INSTANCE.getWindowDeactivated();
            case 3 -> Fus.Counters.Performance.INSTANCE.getWindowDisposed();
            default -> throw new NoWhenBranchMatchedException();
        };
        this.fus.getLogger().log(event);
        this._windowState.setValue((Object)state2);
    }

    @Override
    public void updateWindowFocusedStatus(boolean isFocused) {
        this._isWindowFocused.setValue((Object)isFocused);
    }

    @Override
    @Nullable
    public Object showWindow(@NotNull Continuation<? super Unit> $completion) {
        if (this.getWindowState().getValue() != WindowState.Shown) {
            Object object = this.state.processEvent(UIEvent.ShowWindow.INSTANCE, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object hideWindow(@NotNull Continuation<? super Unit> $completion) {
        if (this.getWindowState().getValue() == WindowState.Shown) {
            Object object = this.state.processEvent(UIEvent.HideWindow.INSTANCE, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object closeWindow(@NotNull Continuation<? super Unit> $completion) {
        if (this.getWindowState().getValue() != WindowState.Closed) {
            Object object = this.state.processEvent(UIEvent.CloseWindow.INSTANCE, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WindowState.values().length];
            try {
                nArray[WindowState.Shown.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowState.Hidden.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowState.Closed.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

