/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.tools;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.ExtensionsKt;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.RevisionInfo;
import com.jetbrains.toolbox.feed.WhatsNew;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.interop.RunAsMode;
import com.jetbrains.toolbox.platform.image.internal.Image;
import com.jetbrains.toolbox.tools.ToolStatus;
import com.jetbrains.toolbox.tools.model.AvailableToolBuild;
import com.jetbrains.toolbox.tools.model.ChangeOptions;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.FailedUpdate;
import com.jetbrains.toolbox.tools.model.ToolDescription;
import com.jetbrains.toolbox.tools.model.licensing.LicenseInfo;
import com.jetbrains.toolbox.viewmodel.DistributionId;
import com.jetbrains.toolbox.viewmodel.progress.ActionProgressViewModel;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class InstalledToolViewState {
    @NotNull
    private final String toolId;
    @NotNull
    private final String channelId;
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    @NotNull
    private final String build;
    @Nullable
    private final String vendor;
    @Nullable
    private final Image icon;
    private final boolean canBeUpdated;
    private final boolean canUpdateBeSkipped;
    @Nullable
    private final UpdateItem updateItem;
    @Nullable
    private final UpdateItem skippedUpdateItem;
    @Nullable
    private final UpdateItem downgradeItem;
    @NotNull
    private final ToolDescriptionViewState description;
    private final boolean isIdle;
    private final boolean isInstalled;
    private final boolean isEnabled;
    private final boolean hasWhatsNew;
    private final boolean hasSetupWizard;
    @NotNull
    private final ToolStatus toolStatus;
    private final boolean isRunning;
    private final boolean isUnmanaged;
    @NotNull
    private final RunAsModes runAsModes;
    @Nullable
    private final Boolean runInSplitMode;
    @NotNull
    private final List<ChildTool> childTools;
    private final boolean otherVersionsAreAvailable;
    private final boolean isUninstallationAllowed;
    private final boolean settingsAvailable;
    private final boolean canRun;
    @Nullable
    private final LicenseInfo licenseInfo;
    private final boolean supportsUpdates;
    @Nullable
    private final ReasonForRestart reasonForRestart;
    private final boolean needsEnterpriseConfiguration;
    private final boolean isBeingConfiguredByEnterprise;

    private InstalledToolViewState(String toolId, String channelId, String name2, String version, String build2, String vendor, Image icon2, boolean canBeUpdated, boolean canUpdateBeSkipped, UpdateItem updateItem, UpdateItem skippedUpdateItem, UpdateItem downgradeItem, ToolDescriptionViewState description2, boolean isIdle, boolean isInstalled2, boolean isEnabled, boolean hasWhatsNew, boolean hasSetupWizard, ToolStatus toolStatus, boolean isRunning, boolean isUnmanaged, RunAsModes runAsModes, Boolean runInSplitMode, List<ChildTool> childTools, boolean otherVersionsAreAvailable, boolean isUninstallationAllowed, boolean settingsAvailable, boolean canRun, LicenseInfo licenseInfo, boolean supportsUpdates, ReasonForRestart reasonForRestart, boolean needsEnterpriseConfiguration, boolean isBeingConfiguredByEnterprise) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter((Object)((Object)toolStatus), (String)"toolStatus");
        Intrinsics.checkNotNullParameter((Object)((Object)runAsModes), (String)"runAsModes");
        Intrinsics.checkNotNullParameter(childTools, (String)"childTools");
        this.toolId = toolId;
        this.channelId = channelId;
        this.name = name2;
        this.version = version;
        this.build = build2;
        this.vendor = vendor;
        this.icon = icon2;
        this.canBeUpdated = canBeUpdated;
        this.canUpdateBeSkipped = canUpdateBeSkipped;
        this.updateItem = updateItem;
        this.skippedUpdateItem = skippedUpdateItem;
        this.downgradeItem = downgradeItem;
        this.description = description2;
        this.isIdle = isIdle;
        this.isInstalled = isInstalled2;
        this.isEnabled = isEnabled;
        this.hasWhatsNew = hasWhatsNew;
        this.hasSetupWizard = hasSetupWizard;
        this.toolStatus = toolStatus;
        this.isRunning = isRunning;
        this.isUnmanaged = isUnmanaged;
        this.runAsModes = runAsModes;
        this.runInSplitMode = runInSplitMode;
        this.childTools = childTools;
        this.otherVersionsAreAvailable = otherVersionsAreAvailable;
        this.isUninstallationAllowed = isUninstallationAllowed;
        this.settingsAvailable = settingsAvailable;
        this.canRun = canRun;
        this.licenseInfo = licenseInfo;
        this.supportsUpdates = supportsUpdates;
        this.reasonForRestart = reasonForRestart;
        this.needsEnterpriseConfiguration = needsEnterpriseConfiguration;
        this.isBeingConfiguredByEnterprise = isBeingConfiguredByEnterprise;
    }

    @NotNull
    public final String getToolId-UtVBrGo() {
        return this.toolId;
    }

    @NotNull
    public final String getChannelId-5CZByfs() {
        return this.channelId;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getBuild-Y_E1uuk() {
        return this.build;
    }

    @Nullable
    public final String getVendor() {
        return this.vendor;
    }

    @Nullable
    public final Image getIcon() {
        return this.icon;
    }

    public final boolean getCanBeUpdated() {
        return this.canBeUpdated;
    }

    public final boolean getCanUpdateBeSkipped() {
        return this.canUpdateBeSkipped;
    }

    @Nullable
    public final UpdateItem getUpdateItem() {
        return this.updateItem;
    }

    @Nullable
    public final UpdateItem getSkippedUpdateItem() {
        return this.skippedUpdateItem;
    }

    @Nullable
    public final UpdateItem getDowngradeItem() {
        return this.downgradeItem;
    }

    @NotNull
    public final ToolDescriptionViewState getDescription() {
        return this.description;
    }

    public final boolean isIdle() {
        return this.isIdle;
    }

    public final boolean isInstalled() {
        return this.isInstalled;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final boolean getHasWhatsNew() {
        return this.hasWhatsNew;
    }

    public final boolean getHasSetupWizard() {
        return this.hasSetupWizard;
    }

    @NotNull
    public final ToolStatus getToolStatus() {
        return this.toolStatus;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final boolean isUnmanaged() {
        return this.isUnmanaged;
    }

    @NotNull
    public final RunAsModes getRunAsModes() {
        return this.runAsModes;
    }

    @Nullable
    public final Boolean getRunInSplitMode() {
        return this.runInSplitMode;
    }

    @NotNull
    public final List<ChildTool> getChildTools() {
        return this.childTools;
    }

    public final boolean getOtherVersionsAreAvailable() {
        return this.otherVersionsAreAvailable;
    }

    public final boolean isUninstallationAllowed() {
        return this.isUninstallationAllowed;
    }

    public final boolean getSettingsAvailable() {
        return this.settingsAvailable;
    }

    public final boolean getCanRun() {
        return this.canRun;
    }

    @Nullable
    public final LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    @Nullable
    public final ReasonForRestart getReasonForRestart() {
        return this.reasonForRestart;
    }

    public final boolean getNeedsEnterpriseConfiguration() {
        return this.needsEnterpriseConfiguration;
    }

    public final boolean isBeingConfiguredByEnterprise() {
        return this.isBeingConfiguredByEnterprise;
    }

    @NotNull
    public final LocalizableString getAccessibleContent() {
        LocalizableString localizableString;
        if (this.updateItem != null && this.vendor != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)this.name), TuplesKt.to((Object)"vendorName", (Object)this.vendor), TuplesKt.to((Object)"version", (Object)ExtensionsKt.accessibleVersion(this.version))};
            localizableString = LocalizableStringExKt.trl("{{toolName}} {{version}} by {{vendorName}}: update is available", pairArray);
        } else if (this.updateItem != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)this.name), TuplesKt.to((Object)"version", (Object)ExtensionsKt.accessibleVersion(this.version))};
            localizableString = LocalizableStringExKt.trl("{{toolName}} {{version}}: update is available", pairArray);
        } else if (this.vendor != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)this.name), TuplesKt.to((Object)"vendorName", (Object)this.vendor), TuplesKt.to((Object)"version", (Object)ExtensionsKt.accessibleVersion(this.version))};
            localizableString = LocalizableStringExKt.trl("{{toolName}} {{version}} by {{vendorName}}", pairArray);
        } else {
            localizableString = LocalizableStringExKt.notr(this.name + " " + ExtensionsKt.accessibleVersion(this.version));
        }
        return localizableString;
    }

    @NotNull
    public String toString() {
        return "InstalledToolViewState(toolId=" + ApplicationType.toString-impl(this.toolId) + ", channelId=" + ChannelId.toString-impl(this.channelId) + ", name=" + this.name + ", version=" + this.version + ", build=" + BuildNumber.toString-impl(this.build) + ", vendor=" + this.vendor + ", icon=" + this.icon + ", canBeUpdated=" + this.canBeUpdated + ", canUpdateBeSkipped=" + this.canUpdateBeSkipped + ", updateItem=" + this.updateItem + ", skippedUpdateItem=" + this.skippedUpdateItem + ", downgradeItem=" + this.downgradeItem + ", description=" + this.description + ", isIdle=" + this.isIdle + ", isInstalled=" + this.isInstalled + ", isEnabled=" + this.isEnabled + ", hasWhatsNew=" + this.hasWhatsNew + ", hasSetupWizard=" + this.hasSetupWizard + ", toolStatus=" + this.toolStatus + ", isRunning=" + this.isRunning + ", isUnmanaged=" + this.isUnmanaged + ", runAsModes=" + this.runAsModes + ", runInSplitMode=" + this.runInSplitMode + ", childTools=" + this.childTools + ", otherVersionsAreAvailable=" + this.otherVersionsAreAvailable + ", isUninstallationAllowed=" + this.isUninstallationAllowed + ", settingsAvailable=" + this.settingsAvailable + ", canRun=" + this.canRun + ", licenseInfo=" + this.licenseInfo + ", supportsUpdates=" + this.supportsUpdates + ", reasonForRestart=" + this.reasonForRestart + ", needsEnterpriseConfiguration=" + this.needsEnterpriseConfiguration + ", isBeingConfiguredByEnterprise=" + this.isBeingConfiguredByEnterprise + ")";
    }

    public int hashCode() {
        int result2 = ApplicationType.hashCode-impl(this.toolId);
        result2 = result2 * 31 + ChannelId.hashCode-impl(this.channelId);
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.version.hashCode();
        result2 = result2 * 31 + BuildNumber.hashCode-impl(this.build);
        result2 = result2 * 31 + (this.vendor == null ? 0 : this.vendor.hashCode());
        result2 = result2 * 31 + (this.icon == null ? 0 : this.icon.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.canBeUpdated);
        result2 = result2 * 31 + Boolean.hashCode(this.canUpdateBeSkipped);
        result2 = result2 * 31 + (this.updateItem == null ? 0 : this.updateItem.hashCode());
        result2 = result2 * 31 + (this.skippedUpdateItem == null ? 0 : this.skippedUpdateItem.hashCode());
        result2 = result2 * 31 + (this.downgradeItem == null ? 0 : this.downgradeItem.hashCode());
        result2 = result2 * 31 + this.description.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isIdle);
        result2 = result2 * 31 + Boolean.hashCode(this.isInstalled);
        result2 = result2 * 31 + Boolean.hashCode(this.isEnabled);
        result2 = result2 * 31 + Boolean.hashCode(this.hasWhatsNew);
        result2 = result2 * 31 + Boolean.hashCode(this.hasSetupWizard);
        result2 = result2 * 31 + this.toolStatus.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isRunning);
        result2 = result2 * 31 + Boolean.hashCode(this.isUnmanaged);
        result2 = result2 * 31 + this.runAsModes.hashCode();
        result2 = result2 * 31 + (this.runInSplitMode == null ? 0 : ((Object)this.runInSplitMode).hashCode());
        result2 = result2 * 31 + ((Object)this.childTools).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.otherVersionsAreAvailable);
        result2 = result2 * 31 + Boolean.hashCode(this.isUninstallationAllowed);
        result2 = result2 * 31 + Boolean.hashCode(this.settingsAvailable);
        result2 = result2 * 31 + Boolean.hashCode(this.canRun);
        result2 = result2 * 31 + (this.licenseInfo == null ? 0 : this.licenseInfo.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.supportsUpdates);
        result2 = result2 * 31 + (this.reasonForRestart == null ? 0 : this.reasonForRestart.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.needsEnterpriseConfiguration);
        result2 = result2 * 31 + Boolean.hashCode(this.isBeingConfiguredByEnterprise);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InstalledToolViewState)) {
            return false;
        }
        InstalledToolViewState installedToolViewState = (InstalledToolViewState)other;
        if (!ApplicationType.equals-impl0(this.toolId, installedToolViewState.toolId)) {
            return false;
        }
        if (!ChannelId.equals-impl0(this.channelId, installedToolViewState.channelId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)installedToolViewState.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)installedToolViewState.version)) {
            return false;
        }
        if (!BuildNumber.equals-impl0(this.build, installedToolViewState.build)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.vendor, (Object)installedToolViewState.vendor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.icon, (Object)installedToolViewState.icon)) {
            return false;
        }
        if (this.canBeUpdated != installedToolViewState.canBeUpdated) {
            return false;
        }
        if (this.canUpdateBeSkipped != installedToolViewState.canUpdateBeSkipped) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.updateItem, (Object)installedToolViewState.updateItem)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.skippedUpdateItem, (Object)installedToolViewState.skippedUpdateItem)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.downgradeItem, (Object)installedToolViewState.downgradeItem)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)installedToolViewState.description)) {
            return false;
        }
        if (this.isIdle != installedToolViewState.isIdle) {
            return false;
        }
        if (this.isInstalled != installedToolViewState.isInstalled) {
            return false;
        }
        if (this.isEnabled != installedToolViewState.isEnabled) {
            return false;
        }
        if (this.hasWhatsNew != installedToolViewState.hasWhatsNew) {
            return false;
        }
        if (this.hasSetupWizard != installedToolViewState.hasSetupWizard) {
            return false;
        }
        if (this.toolStatus != installedToolViewState.toolStatus) {
            return false;
        }
        if (this.isRunning != installedToolViewState.isRunning) {
            return false;
        }
        if (this.isUnmanaged != installedToolViewState.isUnmanaged) {
            return false;
        }
        if (this.runAsModes != installedToolViewState.runAsModes) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.runInSplitMode, (Object)installedToolViewState.runInSplitMode)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.childTools, installedToolViewState.childTools)) {
            return false;
        }
        if (this.otherVersionsAreAvailable != installedToolViewState.otherVersionsAreAvailable) {
            return false;
        }
        if (this.isUninstallationAllowed != installedToolViewState.isUninstallationAllowed) {
            return false;
        }
        if (this.settingsAvailable != installedToolViewState.settingsAvailable) {
            return false;
        }
        if (this.canRun != installedToolViewState.canRun) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.licenseInfo, (Object)installedToolViewState.licenseInfo)) {
            return false;
        }
        if (this.supportsUpdates != installedToolViewState.supportsUpdates) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.reasonForRestart, (Object)installedToolViewState.reasonForRestart)) {
            return false;
        }
        if (this.needsEnterpriseConfiguration != installedToolViewState.needsEnterpriseConfiguration) {
            return false;
        }
        return this.isBeingConfiguredByEnterprise == installedToolViewState.isBeingConfiguredByEnterprise;
    }

    public /* synthetic */ InstalledToolViewState(String toolId, String channelId, String name2, String version, String build2, String vendor, Image icon2, boolean canBeUpdated, boolean canUpdateBeSkipped, UpdateItem updateItem, UpdateItem skippedUpdateItem, UpdateItem downgradeItem, ToolDescriptionViewState description2, boolean isIdle, boolean isInstalled2, boolean isEnabled, boolean hasWhatsNew, boolean hasSetupWizard, ToolStatus toolStatus, boolean isRunning, boolean isUnmanaged, RunAsModes runAsModes, Boolean runInSplitMode, List childTools, boolean otherVersionsAreAvailable, boolean isUninstallationAllowed, boolean settingsAvailable, boolean canRun, LicenseInfo licenseInfo, boolean supportsUpdates, ReasonForRestart reasonForRestart, boolean needsEnterpriseConfiguration, boolean isBeingConfiguredByEnterprise, DefaultConstructorMarker $constructor_marker) {
        this(toolId, channelId, name2, version, build2, vendor, icon2, canBeUpdated, canUpdateBeSkipped, updateItem, skippedUpdateItem, downgradeItem, description2, isIdle, isInstalled2, isEnabled, hasWhatsNew, hasSetupWizard, toolStatus, isRunning, isUnmanaged, runAsModes, runInSplitMode, childTools, otherVersionsAreAvailable, isUninstallationAllowed, settingsAvailable, canRun, licenseInfo, supportsUpdates, reasonForRestart, needsEnterpriseConfiguration, isBeingConfiguredByEnterprise);
    }

    public static final class ChildTool {
        @NotNull
        private final Object childToolId;
        @NotNull
        private final String title;
        @Nullable
        private final Image icon;
        private final boolean isEnabled;
        @NotNull
        private final Path executable;
        @NotNull
        private final List<String> arguments;
        @NotNull
        private final RunAsMode runAsMode;

        public ChildTool(@NotNull Object childToolId, @NotNull String title2, @Nullable Image icon2, boolean isEnabled, @NotNull Path executable, @NotNull List<String> arguments2, @NotNull RunAsMode runAsMode) {
            Intrinsics.checkNotNullParameter((Object)childToolId, (String)"childToolId");
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
            Intrinsics.checkNotNullParameter((Object)((Object)runAsMode), (String)"runAsMode");
            this.childToolId = childToolId;
            this.title = title2;
            this.icon = icon2;
            this.isEnabled = isEnabled;
            this.executable = executable;
            this.arguments = arguments2;
            this.runAsMode = runAsMode;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @Nullable
        public final Image getIcon() {
            return this.icon;
        }

        public final boolean isEnabled() {
            return this.isEnabled;
        }

        @NotNull
        public final Path getExecutable() {
            return this.executable;
        }

        @NotNull
        public final List<String> getArguments() {
            return this.arguments;
        }

        @NotNull
        public final RunAsMode getRunAsMode() {
            return this.runAsMode;
        }

        @NotNull
        public String toString() {
            return "ChildTool(childToolId=" + this.childToolId + ", title=" + this.title + ", icon=" + this.icon + ", isEnabled=" + this.isEnabled + ", executable=" + this.executable + ", arguments=" + this.arguments + ", runAsMode=" + this.runAsMode + ")";
        }

        public int hashCode() {
            int result2 = this.childToolId.hashCode();
            result2 = result2 * 31 + this.title.hashCode();
            result2 = result2 * 31 + (this.icon == null ? 0 : this.icon.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isEnabled);
            result2 = result2 * 31 + this.executable.hashCode();
            result2 = result2 * 31 + ((Object)this.arguments).hashCode();
            result2 = result2 * 31 + this.runAsMode.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChildTool)) {
                return false;
            }
            ChildTool childTool = (ChildTool)other;
            if (!Intrinsics.areEqual((Object)this.childToolId, (Object)childTool.childToolId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)childTool.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.icon, (Object)childTool.icon)) {
                return false;
            }
            if (this.isEnabled != childTool.isEnabled) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.executable, (Object)childTool.executable)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.arguments, childTool.arguments)) {
                return false;
            }
            return this.runAsMode == childTool.runAsMode;
        }
    }

    public static final class LocalCounterpartStatus
    extends Enum<LocalCounterpartStatus> {
        private final boolean isMissing;
        public static final /* enum */ LocalCounterpartStatus NotNeeded = new LocalCounterpartStatus(false);
        public static final /* enum */ LocalCounterpartStatus Missing = new LocalCounterpartStatus(true);
        public static final /* enum */ LocalCounterpartStatus Installed = new LocalCounterpartStatus(false);
        private static final /* synthetic */ LocalCounterpartStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private LocalCounterpartStatus(boolean isMissing) {
            this.isMissing = isMissing;
        }

        public final boolean isMissing() {
            return this.isMissing;
        }

        static {
            $VALUES = localCounterpartStatusArray = new LocalCounterpartStatus[]{LocalCounterpartStatus.NotNeeded, LocalCounterpartStatus.Missing, LocalCounterpartStatus.Installed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public static final class Notice {
        @NotNull
        private final Level level;
        @NotNull
        private final String message;
        @NotNull
        private final String tooltip;

        public Notice(@NotNull Level level, @NotNull String message2, @NotNull String tooltip2) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)tooltip2, (String)"tooltip");
            this.level = level;
            this.message = message2;
            this.tooltip = tooltip2;
        }

        @NotNull
        public final Level getLevel() {
            return this.level;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String getTooltip() {
            return this.tooltip;
        }

        @NotNull
        public String toString() {
            return "Notice(level=" + this.level + ", message=" + this.message + ", tooltip=" + this.tooltip + ")";
        }

        public int hashCode() {
            int result2 = this.level.hashCode();
            result2 = result2 * 31 + this.message.hashCode();
            result2 = result2 * 31 + this.tooltip.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Notice)) {
                return false;
            }
            Notice notice = (Notice)other;
            if (this.level != notice.level) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)notice.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tooltip, (Object)notice.tooltip);
        }

        public static final class Level
        extends Enum<Level> {
            public static final /* enum */ Level Warning = new Level();
            public static final /* enum */ Level Error = new Level();
            private static final /* synthetic */ Level[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Level[] values() {
                return (Level[])$VALUES.clone();
            }

            static {
                $VALUES = levelArray = new Level[]{Level.Warning, Level.Error};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    public static sealed interface ReasonForRestart {
        @NotNull
        public LocalizableString getMessage();

        public static final class ConfigurationUpdated
        implements ReasonForRestart {
            @NotNull
            public static final ConfigurationUpdated INSTANCE = new ConfigurationUpdated();
            @NotNull
            private static final LocalizableStringEx message = LocalizableStringExKt.trl("Restart to apply new settings");

            private ConfigurationUpdated() {
            }

            @Override
            @NotNull
            public LocalizableStringEx getMessage() {
                return message;
            }

            @NotNull
            public String toString() {
                return "ConfigurationUpdated";
            }

            public int hashCode() {
                return 184484210;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConfigurationUpdated)) {
                    return false;
                }
                ConfigurationUpdated cfr_ignored_0 = (ConfigurationUpdated)other;
                return true;
            }
        }

        public static final class UpdateReady
        implements ReasonForRestart {
            @NotNull
            private final String version;
            @NotNull
            private final LocalizableStringEx message;

            public UpdateReady(@NotNull String version) {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                this.version = version;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"version", (Object)this.version)};
                this.message = LocalizableStringExKt.trl("Update is ready. Restart to switch to new version {{version}}", pairArray);
            }

            @Override
            @NotNull
            public LocalizableStringEx getMessage() {
                return this.message;
            }

            @NotNull
            public String toString() {
                return "UpdateReady(version=" + this.version + ")";
            }

            public int hashCode() {
                return this.version.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UpdateReady)) {
                    return false;
                }
                UpdateReady updateReady = (UpdateReady)other;
                return Intrinsics.areEqual((Object)this.version, (Object)updateReady.version);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class RunAsModes
    extends Enum<RunAsModes> {
        @NotNull
        private final RunAsMode default;
        @Nullable
        private final RunAsMode fromMenu;
        public static final /* enum */ RunAsModes UserOnly = new RunAsModes(RunAsMode.RunAsUser, null);
        public static final /* enum */ RunAsModes UserByDefault = new RunAsModes(RunAsMode.RunAsUser, RunAsMode.RunAsAdministrator);
        public static final /* enum */ RunAsModes AdminByDefault = new RunAsModes(RunAsMode.RunAsAdministrator, RunAsMode.RunAsUser);
        private static final /* synthetic */ RunAsModes[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private RunAsModes(RunAsMode runAsMode, RunAsMode fromMenu) {
            this.default = runAsMode;
            this.fromMenu = fromMenu;
        }

        @NotNull
        public final RunAsMode getDefault() {
            return this.default;
        }

        @Nullable
        public final RunAsMode getFromMenu() {
            return this.fromMenu;
        }

        static {
            $VALUES = runAsModesArray = new RunAsModes[]{RunAsModes.UserOnly, RunAsModes.UserByDefault, RunAsModes.AdminByDefault};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public static final class ToolActiveStatusRowViewState {
        @NotNull
        private final StateFlow<String> title;
        private final boolean isCancellable;
        @Nullable
        private final ActionProgressViewModel progress;

        public ToolActiveStatusRowViewState(@NotNull StateFlow<String> title2, boolean isCancellable, @Nullable ActionProgressViewModel progress2) {
            Intrinsics.checkNotNullParameter(title2, (String)"title");
            this.title = title2;
            this.isCancellable = isCancellable;
            this.progress = progress2;
        }

        @NotNull
        public final StateFlow<String> getTitle() {
            return this.title;
        }

        public final boolean isCancellable() {
            return this.isCancellable;
        }

        @Nullable
        public final ActionProgressViewModel getProgress() {
            return this.progress;
        }

        @NotNull
        public String toString() {
            return "ToolActiveStatusRowViewState(title=" + this.title + ", isCancellable=" + this.isCancellable + ", progress=" + this.progress + ")";
        }

        public int hashCode() {
            int result2 = this.title.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isCancellable);
            result2 = result2 * 31 + (this.progress == null ? 0 : this.progress.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToolActiveStatusRowViewState)) {
                return false;
            }
            ToolActiveStatusRowViewState toolActiveStatusRowViewState = (ToolActiveStatusRowViewState)other;
            if (!Intrinsics.areEqual(this.title, toolActiveStatusRowViewState.title)) {
                return false;
            }
            if (this.isCancellable != toolActiveStatusRowViewState.isCancellable) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.progress, (Object)toolActiveStatusRowViewState.progress);
        }
    }

    public static final class ToolDescriptionViewState {
        @NotNull
        private final ContentMode mode;
        @NotNull
        private final String tooltipText;
        @NotNull
        private final String version;
        @Nullable
        private final Notice notice;
        @Nullable
        private final WhatsNewInToolViewState whatsNew;
        @NotNull
        private final LocalCounterpartStatus localCounterpartStatus;
        @Nullable
        private final RevisionInfo revisionInfo;

        public ToolDescriptionViewState(@NotNull ContentMode mode, @NotNull String tooltipText2, @NotNull String version, @Nullable Notice notice, @Nullable WhatsNewInToolViewState whatsNew2, @NotNull LocalCounterpartStatus localCounterpartStatus, @Nullable RevisionInfo revisionInfo) {
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            Intrinsics.checkNotNullParameter((Object)tooltipText2, (String)"tooltipText");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)((Object)localCounterpartStatus), (String)"localCounterpartStatus");
            this.mode = mode;
            this.tooltipText = tooltipText2;
            this.version = version;
            this.notice = notice;
            this.whatsNew = whatsNew2;
            this.localCounterpartStatus = localCounterpartStatus;
            this.revisionInfo = revisionInfo;
        }

        @NotNull
        public final ContentMode getMode() {
            return this.mode;
        }

        @NotNull
        public final String getTooltipText() {
            return this.tooltipText;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @Nullable
        public final Notice getNotice() {
            return this.notice;
        }

        @Nullable
        public final WhatsNewInToolViewState getWhatsNew() {
            return this.whatsNew;
        }

        @NotNull
        public final LocalCounterpartStatus getLocalCounterpartStatus() {
            return this.localCounterpartStatus;
        }

        @Nullable
        public final RevisionInfo getRevisionInfo() {
            return this.revisionInfo;
        }

        @NotNull
        public String toString() {
            return "ToolDescriptionViewState(mode=" + this.mode + ", tooltipText=" + this.tooltipText + ", version=" + this.version + ", notice=" + this.notice + ", whatsNew=" + this.whatsNew + ", localCounterpartStatus=" + this.localCounterpartStatus + ", revisionInfo=" + this.revisionInfo + ")";
        }

        public int hashCode() {
            int result2 = this.mode.hashCode();
            result2 = result2 * 31 + this.tooltipText.hashCode();
            result2 = result2 * 31 + this.version.hashCode();
            result2 = result2 * 31 + (this.notice == null ? 0 : this.notice.hashCode());
            result2 = result2 * 31 + (this.whatsNew == null ? 0 : this.whatsNew.hashCode());
            result2 = result2 * 31 + this.localCounterpartStatus.hashCode();
            result2 = result2 * 31 + (this.revisionInfo == null ? 0 : this.revisionInfo.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToolDescriptionViewState)) {
                return false;
            }
            ToolDescriptionViewState toolDescriptionViewState = (ToolDescriptionViewState)other;
            if (!Intrinsics.areEqual((Object)this.mode, (Object)toolDescriptionViewState.mode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tooltipText, (Object)toolDescriptionViewState.tooltipText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)toolDescriptionViewState.version)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.notice, (Object)toolDescriptionViewState.notice)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.whatsNew, (Object)toolDescriptionViewState.whatsNew)) {
                return false;
            }
            if (this.localCounterpartStatus != toolDescriptionViewState.localCounterpartStatus) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.revisionInfo, (Object)toolDescriptionViewState.revisionInfo);
        }

        public static abstract sealed class ContentMode {
            private ContentMode() {
            }

            public /* synthetic */ ContentMode(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            public static final class ActiveStatus
            extends ContentMode {
                @NotNull
                private final ToolActiveStatusRowViewState state;

                public ActiveStatus(@NotNull ToolActiveStatusRowViewState state2) {
                    Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
                    super(null);
                    this.state = state2;
                }

                @NotNull
                public final ToolActiveStatusRowViewState getState() {
                    return this.state;
                }

                @NotNull
                public String toString() {
                    return "ActiveStatus(state=" + this.state + ")";
                }

                public int hashCode() {
                    return this.state.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof ActiveStatus)) {
                        return false;
                    }
                    ActiveStatus activeStatus = (ActiveStatus)other;
                    return Intrinsics.areEqual((Object)this.state, (Object)activeStatus.state);
                }
            }

            public static final class DelayedActiveStatus
            extends ContentMode {
                @NotNull
                private final ToolActiveStatusRowViewState state;

                public DelayedActiveStatus(@NotNull ToolActiveStatusRowViewState state2) {
                    Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
                    super(null);
                    this.state = state2;
                }

                @NotNull
                public final ToolActiveStatusRowViewState getState() {
                    return this.state;
                }

                @NotNull
                public String toString() {
                    return "DelayedActiveStatus(state=" + this.state + ")";
                }

                public int hashCode() {
                    return this.state.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof DelayedActiveStatus)) {
                        return false;
                    }
                    DelayedActiveStatus delayedActiveStatus = (DelayedActiveStatus)other;
                    return Intrinsics.areEqual((Object)this.state, (Object)delayedActiveStatus.state);
                }
            }

            public static final class NoContent
            extends ContentMode {
                @NotNull
                public static final NoContent INSTANCE = new NoContent();

                private NoContent() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "NoContent";
                }

                public int hashCode() {
                    return -317296937;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof NoContent)) {
                        return false;
                    }
                    NoContent cfr_ignored_0 = (NoContent)other;
                    return true;
                }
            }

            public static final class PendingStatus
            extends ContentMode {
                @NotNull
                private final String status;
                private final boolean isCancellable;

                public PendingStatus(@NotNull String status2, boolean isCancellable) {
                    Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
                    super(null);
                    this.status = status2;
                    this.isCancellable = isCancellable;
                }

                @NotNull
                public final String getStatus() {
                    return this.status;
                }

                public final boolean isCancellable() {
                    return this.isCancellable;
                }

                @NotNull
                public String toString() {
                    return "PendingStatus(status=" + this.status + ", isCancellable=" + this.isCancellable + ")";
                }

                public int hashCode() {
                    int result2 = this.status.hashCode();
                    result2 = result2 * 31 + Boolean.hashCode(this.isCancellable);
                    return result2;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof PendingStatus)) {
                        return false;
                    }
                    PendingStatus pendingStatus = (PendingStatus)other;
                    if (!Intrinsics.areEqual((Object)this.status, (Object)pendingStatus.status)) {
                        return false;
                    }
                    return this.isCancellable == pendingStatus.isCancellable;
                }
            }

            public static final class PendingUpdateTooltip
            extends ContentMode {
                @NotNull
                private final String text;
                @NotNull
                private final String accessibilityText;

                public PendingUpdateTooltip(@NotNull String text2, @NotNull String accessibilityText) {
                    Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                    Intrinsics.checkNotNullParameter((Object)accessibilityText, (String)"accessibilityText");
                    super(null);
                    this.text = text2;
                    this.accessibilityText = accessibilityText;
                }

                @NotNull
                public final String getText() {
                    return this.text;
                }

                @NotNull
                public final String getAccessibilityText() {
                    return this.accessibilityText;
                }

                @NotNull
                public String toString() {
                    return "PendingUpdateTooltip(text=" + this.text + ", accessibilityText=" + this.accessibilityText + ")";
                }

                public int hashCode() {
                    int result2 = this.text.hashCode();
                    result2 = result2 * 31 + this.accessibilityText.hashCode();
                    return result2;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof PendingUpdateTooltip)) {
                        return false;
                    }
                    PendingUpdateTooltip pendingUpdateTooltip = (PendingUpdateTooltip)other;
                    if (!Intrinsics.areEqual((Object)this.text, (Object)pendingUpdateTooltip.text)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.accessibilityText, (Object)pendingUpdateTooltip.accessibilityText);
                }
            }
        }
    }

    public static final class UpdateItem {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String displayName;
        @Nullable
        private final LocalDateTime releaseDate;
        @Nullable
        private final WhatsNew whatsNew;
        @NotNull
        private final DistributionId distributionId;
        @NotNull
        private final ChangeOptions.Status status;
        @Nullable
        private final FailureReasonTooltip failureReasonTooltip;
        private final boolean isReadyToApply;

        public UpdateItem(@NotNull String displayName, @Nullable LocalDateTime releaseDate, @Nullable WhatsNew whatsNew2, @NotNull DistributionId distributionId, @NotNull ChangeOptions.Status status2, @Nullable FailureReasonTooltip failureReasonTooltip) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
            Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
            this.displayName = displayName;
            this.releaseDate = releaseDate;
            this.whatsNew = whatsNew2;
            this.distributionId = distributionId;
            this.status = status2;
            this.failureReasonTooltip = failureReasonTooltip;
            this.isReadyToApply = this.status == ChangeOptions.Status.Ok || this.status == ChangeOptions.Status.Postponed;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @Nullable
        public final LocalDateTime getReleaseDate() {
            return this.releaseDate;
        }

        @Nullable
        public final WhatsNew getWhatsNew() {
            return this.whatsNew;
        }

        @NotNull
        public final DistributionId getDistributionId() {
            return this.distributionId;
        }

        @NotNull
        public final ChangeOptions.Status getStatus() {
            return this.status;
        }

        @Nullable
        public final FailureReasonTooltip getFailureReasonTooltip() {
            return this.failureReasonTooltip;
        }

        public final boolean isReadyToApply() {
            return this.isReadyToApply;
        }

        @NotNull
        public final LocalizableString getButtonTooltip() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.status.ordinal()]) {
                case 1, 2 -> LocalizableStringExKt.notr(this.displayName);
                case 3 -> LocalizableStringExKt.trl("The installation path is not writable. Check the tool settings for details.");
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public String toString() {
            return "UpdateItem(displayName=" + this.displayName + ", releaseDate=" + this.releaseDate + ", whatsNew=" + this.whatsNew + ", distributionId=" + this.distributionId + ", status=" + this.status + ", failureReasonTooltip=" + this.failureReasonTooltip + ")";
        }

        public int hashCode() {
            int result2 = this.displayName.hashCode();
            result2 = result2 * 31 + (this.releaseDate == null ? 0 : this.releaseDate.hashCode());
            result2 = result2 * 31 + (this.whatsNew == null ? 0 : this.whatsNew.hashCode());
            result2 = result2 * 31 + this.distributionId.hashCode();
            result2 = result2 * 31 + this.status.hashCode();
            result2 = result2 * 31 + (this.failureReasonTooltip == null ? 0 : this.failureReasonTooltip.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UpdateItem)) {
                return false;
            }
            UpdateItem updateItem = (UpdateItem)other;
            if (!Intrinsics.areEqual((Object)this.displayName, (Object)updateItem.displayName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.releaseDate, (Object)updateItem.releaseDate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.whatsNew, (Object)updateItem.whatsNew)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.distributionId, (Object)updateItem.distributionId)) {
                return false;
            }
            if (this.status != updateItem.status) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.failureReasonTooltip, (Object)updateItem.failureReasonTooltip);
        }

        @SourceDebugExtension(value={"SMAP\nInstalledToolViewState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstalledToolViewState.kt\ncom/jetbrains/toolbox/viewmodel/tools/InstalledToolViewState$UpdateItem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1#2:308\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final FailureReasonTooltip failureReasonTooltip(FailedUpdate failedUpdate) {
                FailureReasonTooltip failureReasonTooltip;
                Instant shouldPostponeUntil = failedUpdate.component2();
                FailedUpdate.Reason reason = failedUpdate.component3();
                FailedUpdate.Reason reason2 = reason;
                if (reason2 instanceof FailedUpdate.Reason.Cancelled) {
                    failureReasonTooltip = new FailureReasonTooltip.Static(LocalizableStringExKt.trl("The autoupdate has been canceled."));
                } else if (reason2 instanceof FailedUpdate.Reason.Failed) {
                    if (shouldPostponeUntil == null) {
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"A short sentence explaining the reason", (Object)reason.getExplanation())};
                        failureReasonTooltip = new FailureReasonTooltip.Static(LocalizableStringExKt.trll("Autoupdate failed. {{A short sentence explaining the reason}}.", pairArray));
                    } else {
                        failureReasonTooltip = new FailureReasonTooltip.Dynamic((Function1<? super Instant, ? extends LocalizableString>)((Function1)arg_0 -> Companion.failureReasonTooltip$lambda$0(shouldPostponeUntil, reason, arg_0)));
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return failureReasonTooltip;
            }

            private final long minutesRemaining(Instant shouldPostponeUntil, Instant now2) {
                return Duration.getInWholeMinutes-impl((long)((Duration)ComparisonsKt.maxOf((Comparable)Duration.box-impl((long)shouldPostponeUntil.minus-5sfh64U(now2)), (Comparable)Duration.box-impl((long)Duration.Companion.getZERO-UwyO8pc()))).unbox-impl());
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final UpdateItem from(@NotNull AvailableToolBuild toolBuild2, @NotNull ChangeOptions.Status status2, @Nullable FailedUpdate failedUpdate) {
                FailureReasonTooltip failureReasonTooltip;
                Intrinsics.checkNotNullParameter((Object)toolBuild2, (String)"toolBuild");
                Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
                String string = toolBuild2.getDisplayName();
                LocalDateTime localDateTime = toolBuild2.getReleased();
                WhatsNew whatsNew2 = toolBuild2.getWhatsNew();
                DistributionId distributionId = new DistributionId(toolBuild2.getToolId-UtVBrGo(), toolBuild2.getVersionName(), toolBuild2.getBuildNumber-Y_E1uuk(), null);
                ChangeOptions.Status status3 = status2;
                FailedUpdate failedUpdate2 = failedUpdate;
                if (failedUpdate2 != null) {
                    void p0;
                    FailedUpdate failedUpdate3 = failedUpdate2;
                    ChangeOptions.Status status4 = status3;
                    DistributionId distributionId2 = distributionId;
                    WhatsNew whatsNew3 = whatsNew2;
                    LocalDateTime localDateTime2 = localDateTime;
                    String string2 = string;
                    boolean bl = false;
                    FailureReasonTooltip failureReasonTooltip2 = this.failureReasonTooltip((FailedUpdate)p0);
                    string = string2;
                    localDateTime = localDateTime2;
                    whatsNew2 = whatsNew3;
                    distributionId = distributionId2;
                    status3 = status4;
                    failureReasonTooltip = failureReasonTooltip2;
                } else {
                    failureReasonTooltip = null;
                }
                FailureReasonTooltip failureReasonTooltip3 = failureReasonTooltip;
                ChangeOptions.Status status5 = status3;
                DistributionId distributionId3 = distributionId;
                WhatsNew whatsNew4 = whatsNew2;
                LocalDateTime localDateTime3 = localDateTime;
                String string3 = string;
                return new UpdateItem(string3, localDateTime3, whatsNew4, distributionId3, status5, failureReasonTooltip3);
            }

            @Nullable
            public final UpdateItem from(@NotNull ToolDescription toolDescription) {
                UpdateItem updateItem;
                Intrinsics.checkNotNullParameter((Object)toolDescription, (String)"toolDescription");
                AvailableToolBuild availableToolBuild = toolDescription.getChangeOptions().getUpdate();
                if (availableToolBuild != null) {
                    AvailableToolBuild toolUpdateMethod = availableToolBuild;
                    boolean bl = false;
                    updateItem = Companion.from(toolUpdateMethod, toolDescription.getChangeOptions().getStatus(), null);
                } else {
                    updateItem = null;
                }
                return updateItem;
            }

            private static final LocalizableString failureReasonTooltip$lambda$0(Instant $shouldPostponeUntil, FailedUpdate.Reason $reason, Instant now2) {
                Intrinsics.checkNotNullParameter((Object)now2, (String)"now");
                long count = Companion.minutesRemaining($shouldPostponeUntil, now2);
                Pair[] pairArray = new Pair[2];
                pairArray[0] = TuplesKt.to((Object)"shortReasonText", (Object)$reason.getExplanation());
                Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"count", (Object)String.valueOf(count))};
                pairArray[1] = TuplesKt.to((Object)"countDownText", (Object)LocalizableStringExKt.trn("Retrying in {{count}} minute", "Retrying in {{count}} minutes", (int)count, pairArray2));
                return LocalizableStringExKt.trll("Autoupdate failed. {{shortReasonText}}. {{countDownText}}\u2026", pairArray);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        public static sealed interface FailureReasonTooltip {

            public static final class Dynamic
            implements FailureReasonTooltip {
                @NotNull
                private final Function1<Instant, LocalizableString> getMessage;

                public Dynamic(@NotNull Function1<? super Instant, ? extends LocalizableString> getMessage) {
                    Intrinsics.checkNotNullParameter(getMessage, (String)"getMessage");
                    this.getMessage = getMessage;
                }

                @NotNull
                public final Function1<Instant, LocalizableString> getGetMessage() {
                    return this.getMessage;
                }

                @NotNull
                public String toString() {
                    return "Dynamic(getMessage=" + this.getMessage + ")";
                }

                public int hashCode() {
                    return this.getMessage.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Dynamic)) {
                        return false;
                    }
                    Dynamic dynamic = (Dynamic)other;
                    return Intrinsics.areEqual(this.getMessage, dynamic.getMessage);
                }
            }

            public static final class Static
            implements FailureReasonTooltip {
                @NotNull
                private final LocalizableString message;

                public Static(@NotNull LocalizableString message2) {
                    Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                    this.message = message2;
                }

                @NotNull
                public final LocalizableString getMessage() {
                    return this.message;
                }

                @NotNull
                public String toString() {
                    return "Static(message=" + this.message + ")";
                }

                public int hashCode() {
                    return this.message.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Static)) {
                        return false;
                    }
                    Static static_ = (Static)other;
                    return Intrinsics.areEqual((Object)this.message, (Object)static_.message);
                }
            }
        }

        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ChangeOptions.Status.values().length];
                try {
                    nArray[ChangeOptions.Status.Ok.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChangeOptions.Status.Postponed.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChangeOptions.Status.DirectoryIsNotWritable.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class WhatsNewInToolViewState {
        @NotNull
        private final String toolId;
        @NotNull
        private final String toolName;
        @NotNull
        private final String channelId;
        @NotNull
        private final String version;
        @NotNull
        private final String build;
        @Nullable
        private final UpdateItem update;

        private WhatsNewInToolViewState(String toolId, String toolName, String channelId, String version, String build2, UpdateItem update2) {
            Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
            Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
            this.toolId = toolId;
            this.toolName = toolName;
            this.channelId = channelId;
            this.version = version;
            this.build = build2;
            this.update = update2;
        }

        @NotNull
        public final String getToolId-UtVBrGo() {
            return this.toolId;
        }

        @NotNull
        public final String getToolName() {
            return this.toolName;
        }

        @NotNull
        public final String getChannelId-5CZByfs() {
            return this.channelId;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final String getBuild-Y_E1uuk() {
            return this.build;
        }

        @Nullable
        public final UpdateItem getUpdate() {
            return this.update;
        }

        @NotNull
        public String toString() {
            return "WhatsNewInToolViewState(toolId=" + ApplicationType.toString-impl(this.toolId) + ", toolName=" + this.toolName + ", channelId=" + ChannelId.toString-impl(this.channelId) + ", version=" + this.version + ", build=" + BuildNumber.toString-impl(this.build) + ", update=" + this.update + ")";
        }

        public int hashCode() {
            int result2 = ApplicationType.hashCode-impl(this.toolId);
            result2 = result2 * 31 + this.toolName.hashCode();
            result2 = result2 * 31 + ChannelId.hashCode-impl(this.channelId);
            result2 = result2 * 31 + this.version.hashCode();
            result2 = result2 * 31 + BuildNumber.hashCode-impl(this.build);
            result2 = result2 * 31 + (this.update == null ? 0 : this.update.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WhatsNewInToolViewState)) {
                return false;
            }
            WhatsNewInToolViewState whatsNewInToolViewState = (WhatsNewInToolViewState)other;
            if (!ApplicationType.equals-impl0(this.toolId, whatsNewInToolViewState.toolId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.toolName, (Object)whatsNewInToolViewState.toolName)) {
                return false;
            }
            if (!ChannelId.equals-impl0(this.channelId, whatsNewInToolViewState.channelId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)whatsNewInToolViewState.version)) {
                return false;
            }
            if (!BuildNumber.equals-impl0(this.build, whatsNewInToolViewState.build)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.update, (Object)whatsNewInToolViewState.update);
        }

        public /* synthetic */ WhatsNewInToolViewState(String toolId, String toolName, String channelId, String version, String build2, UpdateItem update2, DefaultConstructorMarker $constructor_marker) {
            this(toolId, toolName, channelId, version, build2, update2);
        }
    }
}

