/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.tools;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.common.io.FileSize;
import com.jetbrains.toolbox.tools.model.ChannelId;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrontendToolCleanupViewState {
    @NotNull
    private final List<FrontendTool> tools;

    public FrontendToolCleanupViewState(@NotNull List<FrontendTool> tools2) {
        Intrinsics.checkNotNullParameter(tools2, (String)"tools");
        this.tools = tools2;
    }

    @NotNull
    public final List<FrontendTool> getTools() {
        return this.tools;
    }

    @NotNull
    public String toString() {
        return "FrontendToolCleanupViewState(tools=" + this.tools + ")";
    }

    public int hashCode() {
        return ((Object)this.tools).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FrontendToolCleanupViewState)) {
            return false;
        }
        FrontendToolCleanupViewState frontendToolCleanupViewState = (FrontendToolCleanupViewState)other;
        return Intrinsics.areEqual(this.tools, frontendToolCleanupViewState.tools);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class FrontendTool {
        @NotNull
        private final String channelId;
        @NotNull
        private final String version;
        @NotNull
        private final String nameWithVersion;
        private final long totalSize;
        @Nullable
        private final Instant lastUsedAt;

        private FrontendTool(String channelId, String version, String nameWithVersion, long totalSize, Instant lastUsedAt) {
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)nameWithVersion, (String)"nameWithVersion");
            this.channelId = channelId;
            this.version = version;
            this.nameWithVersion = nameWithVersion;
            this.totalSize = totalSize;
            this.lastUsedAt = lastUsedAt;
        }

        @NotNull
        public final String getChannelId-5CZByfs() {
            return this.channelId;
        }

        @NotNull
        public final String getVersion-Y_E1uuk() {
            return this.version;
        }

        @NotNull
        public final String getNameWithVersion() {
            return this.nameWithVersion;
        }

        public final long getTotalSize-WN0b6rc() {
            return this.totalSize;
        }

        @Nullable
        public final Instant getLastUsedAt() {
            return this.lastUsedAt;
        }

        @NotNull
        public String toString() {
            return "FrontendTool(channelId=" + ChannelId.toString-impl(this.channelId) + ", version=" + BuildNumber.toString-impl(this.version) + ", nameWithVersion=" + this.nameWithVersion + ", totalSize=" + FileSize.toString-impl(this.totalSize) + ", lastUsedAt=" + this.lastUsedAt + ")";
        }

        public int hashCode() {
            int result2 = ChannelId.hashCode-impl(this.channelId);
            result2 = result2 * 31 + BuildNumber.hashCode-impl(this.version);
            result2 = result2 * 31 + this.nameWithVersion.hashCode();
            result2 = result2 * 31 + FileSize.hashCode-impl(this.totalSize);
            result2 = result2 * 31 + (this.lastUsedAt == null ? 0 : this.lastUsedAt.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FrontendTool)) {
                return false;
            }
            FrontendTool frontendTool = (FrontendTool)other;
            if (!ChannelId.equals-impl0(this.channelId, frontendTool.channelId)) {
                return false;
            }
            if (!BuildNumber.equals-impl0(this.version, frontendTool.version)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nameWithVersion, (Object)frontendTool.nameWithVersion)) {
                return false;
            }
            if (!FileSize.equals-impl0(this.totalSize, frontendTool.totalSize)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lastUsedAt, (Object)frontendTool.lastUsedAt);
        }

        public /* synthetic */ FrontendTool(String channelId, String version, String nameWithVersion, long totalSize, Instant lastUsedAt, DefaultConstructorMarker $constructor_marker) {
            this(channelId, version, nameWithVersion, totalSize, lastUsedAt);
        }
    }
}

