/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.gateway;

import com.jetbrains.toolbox.platform.image.internal.Image;
import com.jetbrains.toolbox.viewmodel.projects.ProjectIconData;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnvironmentHintViewState {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @Nullable
    private final Image icon;
    @NotNull
    private final List<ProjectStubViewState> projectStubs;
    @NotNull
    private final Function0<Unit> onAccept;
    @NotNull
    private final Function0<Unit> onReject;

    public EnvironmentHintViewState(@NotNull String id, @NotNull String name2, @NotNull String description2, @Nullable Image icon2, @NotNull List<ProjectStubViewState> projectStubs, @NotNull Function0<Unit> onAccept, @NotNull Function0<Unit> onReject) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter(projectStubs, (String)"projectStubs");
        Intrinsics.checkNotNullParameter(onAccept, (String)"onAccept");
        Intrinsics.checkNotNullParameter(onReject, (String)"onReject");
        this.id = id;
        this.name = name2;
        this.description = description2;
        this.icon = icon2;
        this.projectStubs = projectStubs;
        this.onAccept = onAccept;
        this.onReject = onReject;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @Nullable
    public final Image getIcon() {
        return this.icon;
    }

    @NotNull
    public final List<ProjectStubViewState> getProjectStubs() {
        return this.projectStubs;
    }

    @NotNull
    public final Function0<Unit> getOnAccept() {
        return this.onAccept;
    }

    @NotNull
    public final Function0<Unit> getOnReject() {
        return this.onReject;
    }

    @NotNull
    public String toString() {
        return "EnvironmentHintViewState(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", icon=" + this.icon + ", projectStubs=" + this.projectStubs + ", onAccept=" + this.onAccept + ", onReject=" + this.onReject + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.description.hashCode();
        result2 = result2 * 31 + (this.icon == null ? 0 : this.icon.hashCode());
        result2 = result2 * 31 + ((Object)this.projectStubs).hashCode();
        result2 = result2 * 31 + this.onAccept.hashCode();
        result2 = result2 * 31 + this.onReject.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EnvironmentHintViewState)) {
            return false;
        }
        EnvironmentHintViewState environmentHintViewState = (EnvironmentHintViewState)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)environmentHintViewState.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)environmentHintViewState.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)environmentHintViewState.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.icon, (Object)environmentHintViewState.icon)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.projectStubs, environmentHintViewState.projectStubs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.onAccept, environmentHintViewState.onAccept)) {
            return false;
        }
        return Intrinsics.areEqual(this.onReject, environmentHintViewState.onReject);
    }

    public static final class ProjectStubViewState {
        @NotNull
        private final String name;
        @NotNull
        private final String description;
        @NotNull
        private final ProjectIconData iconData;
        @Nullable
        private final String appName;
        @Nullable
        private final Image appIcon;

        public ProjectStubViewState(@NotNull String name2, @NotNull String description2, @NotNull ProjectIconData iconData, @Nullable String appName, @Nullable Image appIcon) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
            Intrinsics.checkNotNullParameter((Object)iconData, (String)"iconData");
            this.name = name2;
            this.description = description2;
            this.iconData = iconData;
            this.appName = appName;
            this.appIcon = appIcon;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final ProjectIconData getIconData() {
            return this.iconData;
        }

        @Nullable
        public final String getAppName() {
            return this.appName;
        }

        @Nullable
        public final Image getAppIcon() {
            return this.appIcon;
        }

        @NotNull
        public String toString() {
            return "ProjectStubViewState(name=" + this.name + ", description=" + this.description + ", iconData=" + this.iconData + ", appName=" + this.appName + ", appIcon=" + this.appIcon + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.description.hashCode();
            result2 = result2 * 31 + this.iconData.hashCode();
            result2 = result2 * 31 + (this.appName == null ? 0 : this.appName.hashCode());
            result2 = result2 * 31 + (this.appIcon == null ? 0 : this.appIcon.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectStubViewState)) {
                return false;
            }
            ProjectStubViewState projectStubViewState = (ProjectStubViewState)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)projectStubViewState.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)projectStubViewState.description)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.iconData, (Object)projectStubViewState.iconData)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.appName, (Object)projectStubViewState.appName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.appIcon, (Object)projectStubViewState.appIcon);
        }
    }
}

