/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.dialogs;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.ui.DescriptionTree;
import com.jetbrains.toolbox.manager.InputType;
import com.jetbrains.toolbox.viewmodel.dialogs.DialogViewModel;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InputDialogViewModel
implements DialogViewModel {
    @Nullable
    private final String providerName;
    @NotNull
    private final LocalizableString title;
    @NotNull
    private final List<DescriptionTree> content;
    @NotNull
    private final InputType inputType;
    @Nullable
    private final String initialValue;
    @NotNull
    private final LocalizableString okButtonText;
    @NotNull
    private final LocalizableString cancelButtonText;
    @NotNull
    private final Function1<String, Unit> answer;

    public InputDialogViewModel(@Nullable String providerName, @NotNull LocalizableString title2, @NotNull List<? extends DescriptionTree> content2, @NotNull InputType inputType, @Nullable String initialValue, @NotNull LocalizableString okButtonText, @NotNull LocalizableString cancelButtonText, @NotNull Function1<? super String, Unit> answer) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)inputType), (String)"inputType");
        Intrinsics.checkNotNullParameter((Object)okButtonText, (String)"okButtonText");
        Intrinsics.checkNotNullParameter((Object)cancelButtonText, (String)"cancelButtonText");
        Intrinsics.checkNotNullParameter(answer, (String)"answer");
        this.providerName = providerName;
        this.title = title2;
        this.content = content2;
        this.inputType = inputType;
        this.initialValue = initialValue;
        this.okButtonText = okButtonText;
        this.cancelButtonText = cancelButtonText;
        this.answer = answer;
    }

    @Nullable
    public final String getProviderName() {
        return this.providerName;
    }

    @NotNull
    public final LocalizableString getTitle() {
        return this.title;
    }

    @NotNull
    public final List<DescriptionTree> getContent() {
        return this.content;
    }

    @NotNull
    public final InputType getInputType() {
        return this.inputType;
    }

    @Nullable
    public final String getInitialValue() {
        return this.initialValue;
    }

    @NotNull
    public final LocalizableString getOkButtonText() {
        return this.okButtonText;
    }

    @NotNull
    public final LocalizableString getCancelButtonText() {
        return this.cancelButtonText;
    }

    @NotNull
    public final Function1<String, Unit> getAnswer() {
        return this.answer;
    }

    @NotNull
    public String toString() {
        return "InputDialogViewModel(providerName=" + this.providerName + ", title=" + this.title + ", content=" + this.content + ", inputType=" + this.inputType + ", initialValue=" + this.initialValue + ", okButtonText=" + this.okButtonText + ", cancelButtonText=" + this.cancelButtonText + ", answer=" + this.answer + ")";
    }

    public int hashCode() {
        int result2 = this.providerName == null ? 0 : this.providerName.hashCode();
        result2 = result2 * 31 + this.title.hashCode();
        result2 = result2 * 31 + ((Object)this.content).hashCode();
        result2 = result2 * 31 + this.inputType.hashCode();
        result2 = result2 * 31 + (this.initialValue == null ? 0 : this.initialValue.hashCode());
        result2 = result2 * 31 + this.okButtonText.hashCode();
        result2 = result2 * 31 + this.cancelButtonText.hashCode();
        result2 = result2 * 31 + this.answer.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InputDialogViewModel)) {
            return false;
        }
        InputDialogViewModel inputDialogViewModel = (InputDialogViewModel)other;
        if (!Intrinsics.areEqual((Object)this.providerName, (Object)inputDialogViewModel.providerName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.title, (Object)inputDialogViewModel.title)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.content, inputDialogViewModel.content)) {
            return false;
        }
        if (this.inputType != inputDialogViewModel.inputType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.initialValue, (Object)inputDialogViewModel.initialValue)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.okButtonText, (Object)inputDialogViewModel.okButtonText)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cancelButtonText, (Object)inputDialogViewModel.cancelButtonText)) {
            return false;
        }
        return Intrinsics.areEqual(this.answer, inputDialogViewModel.answer);
    }
}

