/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.ui.components.UiField;
import com.jetbrains.toolbox.api.ui.components.UiPage;
import com.jetbrains.toolbox.viewmodel.ActionModel;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UiPageWrapper {
    @NotNull
    private final StateFlow<LocalizableString> title;
    @NotNull
    private final StateFlow<List<UiField>> fields;
    @NotNull
    private final StateFlow<List<ActionModel>> actions;
    @NotNull
    private final StateFlow<ActionModel> defaultAction;
    @NotNull
    private final UiPage form;

    public UiPageWrapper(@NotNull StateFlow<? extends LocalizableString> title2, @NotNull StateFlow<? extends List<? extends UiField>> fields2, @NotNull StateFlow<? extends List<ActionModel>> actions2, @NotNull StateFlow<ActionModel> defaultAction, @NotNull UiPage form) {
        Intrinsics.checkNotNullParameter(title2, (String)"title");
        Intrinsics.checkNotNullParameter(fields2, (String)"fields");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        this.title = title2;
        this.fields = fields2;
        this.actions = actions2;
        this.defaultAction = defaultAction;
        this.form = form;
    }

    @NotNull
    public final StateFlow<LocalizableString> getTitle() {
        return this.title;
    }

    @NotNull
    public final StateFlow<List<UiField>> getFields() {
        return this.fields;
    }

    @NotNull
    public final StateFlow<List<ActionModel>> getActions() {
        return this.actions;
    }

    @NotNull
    public final StateFlow<ActionModel> getDefaultAction() {
        return this.defaultAction;
    }

    @NotNull
    public final UiPage getForm() {
        return this.form;
    }

    @NotNull
    public String toString() {
        return "UiPageWrapper(title=" + this.title + ", fields=" + this.fields + ", actions=" + this.actions + ", defaultAction=" + this.defaultAction + ", form=" + this.form + ")";
    }

    public int hashCode() {
        int result2 = this.title.hashCode();
        result2 = result2 * 31 + this.fields.hashCode();
        result2 = result2 * 31 + this.actions.hashCode();
        result2 = result2 * 31 + this.defaultAction.hashCode();
        result2 = result2 * 31 + this.form.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UiPageWrapper)) {
            return false;
        }
        UiPageWrapper uiPageWrapper = (UiPageWrapper)other;
        if (!Intrinsics.areEqual(this.title, uiPageWrapper.title)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fields, uiPageWrapper.fields)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actions, uiPageWrapper.actions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.defaultAction, uiPageWrapper.defaultAction)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.form, (Object)uiPageWrapper.form);
    }
}

