/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel;

import com.jetbrains.toolbox.enterprise.EnterpriseConfig;
import com.jetbrains.toolbox.i18n.UILanguage;
import com.jetbrains.toolbox.i18n.UIRegion;
import com.jetbrains.toolbox.viewmodel.OnboardingViewScreenState;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OnboardingViewState {
    @NotNull
    private final OnboardingViewScreenState screen;
    @Nullable
    private final EnterpriseConfig enterpriseConfig;
    @Nullable
    private final Boolean blockTbaWhenReLoginRequired;
    @NotNull
    private final List<UILanguage> supportedLanguages;
    @NotNull
    private final UILanguage language;
    @NotNull
    private final UIRegion region;

    public OnboardingViewState(@NotNull OnboardingViewScreenState screen, @Nullable EnterpriseConfig enterpriseConfig, @Nullable Boolean blockTbaWhenReLoginRequired, @NotNull List<? extends UILanguage> supportedLanguages, @NotNull UILanguage language, @NotNull UIRegion region) {
        Intrinsics.checkNotNullParameter((Object)((Object)screen), (String)"screen");
        Intrinsics.checkNotNullParameter(supportedLanguages, (String)"supportedLanguages");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)((Object)region), (String)"region");
        this.screen = screen;
        this.enterpriseConfig = enterpriseConfig;
        this.blockTbaWhenReLoginRequired = blockTbaWhenReLoginRequired;
        this.supportedLanguages = supportedLanguages;
        this.language = language;
        this.region = region;
    }

    @NotNull
    public final OnboardingViewScreenState getScreen() {
        return this.screen;
    }

    @Nullable
    public final EnterpriseConfig getEnterpriseConfig() {
        return this.enterpriseConfig;
    }

    @Nullable
    public final Boolean getBlockTbaWhenReLoginRequired() {
        return this.blockTbaWhenReLoginRequired;
    }

    @NotNull
    public final List<UILanguage> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    @NotNull
    public final UILanguage getLanguage() {
        return this.language;
    }

    @NotNull
    public final UIRegion getRegion() {
        return this.region;
    }

    @NotNull
    public String toString() {
        return "OnboardingViewState(screen=" + this.screen + ", enterpriseConfig=" + this.enterpriseConfig + ", blockTbaWhenReLoginRequired=" + this.blockTbaWhenReLoginRequired + ", supportedLanguages=" + this.supportedLanguages + ", language=" + this.language + ", region=" + this.region + ")";
    }

    public int hashCode() {
        int result2 = this.screen.hashCode();
        result2 = result2 * 31 + (this.enterpriseConfig == null ? 0 : this.enterpriseConfig.hashCode());
        result2 = result2 * 31 + (this.blockTbaWhenReLoginRequired == null ? 0 : ((Object)this.blockTbaWhenReLoginRequired).hashCode());
        result2 = result2 * 31 + ((Object)this.supportedLanguages).hashCode();
        result2 = result2 * 31 + this.language.hashCode();
        result2 = result2 * 31 + this.region.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OnboardingViewState)) {
            return false;
        }
        OnboardingViewState onboardingViewState = (OnboardingViewState)other;
        if (this.screen != onboardingViewState.screen) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.enterpriseConfig, (Object)onboardingViewState.enterpriseConfig)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.blockTbaWhenReLoginRequired, (Object)onboardingViewState.blockTbaWhenReLoginRequired)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.supportedLanguages, onboardingViewState.supportedLanguages)) {
            return false;
        }
        if (this.language != onboardingViewState.language) {
            return false;
        }
        return this.region == onboardingViewState.region;
    }
}

