/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.window;

import com.jetbrains.toolbox.desktop.window.WindowId;
import com.jetbrains.toolbox.lifecycle.AppLifecycleTracker;
import com.jetbrains.toolbox.settings.ApplicationState;
import com.jetbrains.toolbox.settings.ApplicationStateManager;
import com.jetbrains.toolbox.ui.window.PersistableWindowProvider;
import com.jetbrains.toolbox.ui.window.TrayWidget;
import com.jetbrains.toolbox.ui.window.WindowStateManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.crystal.WindowDescriptor;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nWindowStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowStateManager.kt\ncom/jetbrains/toolbox/ui/window/WindowStateManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1208#2,2:115\n1236#2,4:117\n1869#2,2:121\n*S KotlinDebug\n*F\n+ 1 WindowStateManager.kt\ncom/jetbrains/toolbox/ui/window/WindowStateManager\n*L\n29#1:115,2\n29#1:117,4\n32#1:121,2\n*E\n"})
public final class WindowStateManager {
    @NotNull
    private final ApplicationStateManager applicationStateManager;
    @NotNull
    private final Clock clock;
    @NotNull
    private final AppLifecycleTracker lifecycleTracker;
    @NotNull
    private final CoroutineScope coroutinesScope;
    @NotNull
    private final Map<String, PersistableWindowProvider> providers;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public WindowStateManager(@NotNull ApplicationStateManager applicationStateManager, @NotNull List<? extends PersistableWindowProvider> providers, @NotNull Clock clock, @NotNull AppLifecycleTracker lifecycleTracker, @NotNull CoroutineScope coroutinesScope) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)applicationStateManager, (String)"applicationStateManager");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)lifecycleTracker, (String)"lifecycleTracker");
        Intrinsics.checkNotNullParameter((Object)coroutinesScope, (String)"coroutinesScope");
        this.applicationStateManager = applicationStateManager;
        this.clock = clock;
        this.lifecycleTracker = lifecycleTracker;
        this.coroutinesScope = coroutinesScope;
        Iterable iterable = providers;
        WindowStateManager windowStateManager = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var9_11 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PersistableWindowProvider persistableWindowProvider = (PersistableWindowProvider)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getWindowId().getName(), element$iv$iv);
        }
        windowStateManager.providers = destination$iv$iv;
        Iterable $this$forEach$iv = providers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PersistableWindowProvider it = (PersistableWindowProvider)element$iv;
            boolean bl = false;
            this.collect(it.getWindowId(), (Flow<? extends WindowDescriptor>)((Flow)it.getWindowDescriptorState()));
        }
    }

    @NotNull
    public final Map<String, PersistableWindowProvider> getProviders() {
        return this.providers;
    }

    private final void collect(WindowId id, Flow<? extends WindowDescriptor> descriptorFlow) {
        BuildersKt.launch$default((CoroutineScope)this.coroutinesScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(descriptorFlow, this, id, null){
            int label;
            final /* synthetic */ Flow<WindowDescriptor> $descriptorFlow;
            final /* synthetic */ WindowStateManager this$0;
            final /* synthetic */ WindowId $id;
            {
                this.$descriptorFlow = $descriptorFlow;
                this.this$0 = $receiver;
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.dropWhile(this.$descriptorFlow, (Function2)((Function2)new Function2<WindowDescriptor, Continuation<? super Boolean>, Object>(null){
                            int label;
                            /* synthetic */ Object L$0;

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                WindowDescriptor windowDescriptor = (WindowDescriptor)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        return Boxing.boxBoolean((it == null ? 1 : 0) != 0);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(WindowDescriptor p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        })), (Function2)((Function2)new Function2<WindowDescriptor, Continuation<? super Unit>, Object>(this.this$0, this.$id, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ WindowStateManager this$0;
                            final /* synthetic */ WindowId $id;
                            {
                                this.this$0 = $receiver;
                                this.$id = $id;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                WindowDescriptor windowDescriptor = (WindowDescriptor)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void descriptor;
                                        ResultKt.throwOnFailure((Object)$result);
                                        WindowStateManager.access$updateState(this.this$0, this.$id, arg_0 -> collect.2.invokeSuspend$lambda$0((WindowDescriptor)descriptor, this.this$0, arg_0));
                                        Window window = descriptor;
                                        if (window != null && (window = window.getWindow()) != null) {
                                            window.addWindowListener(new WindowAdapter(this.this$0, this.$id){
                                                final /* synthetic */ WindowStateManager this$0;
                                                final /* synthetic */ WindowId $id;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$id = $id;
                                                }

                                                public void windowIconified(WindowEvent e) {
                                                    WindowStateManager.access$updateState(this.this$0, this.$id, arg_0 -> collect.2.windowIconified$lambda$0(this.this$0, arg_0));
                                                }

                                                public void windowDeiconified(WindowEvent e) {
                                                    WindowStateManager.access$updateState(this.this$0, this.$id, collect.2::windowDeiconified$lambda$1);
                                                }

                                                public void windowDeactivated(WindowEvent e) {
                                                    WindowStateManager.access$updateState(this.this$0, this.$id, arg_0 -> collect.2.windowDeactivated$lambda$2(this.this$0, arg_0));
                                                }

                                                public void windowActivated(WindowEvent e) {
                                                    WindowStateManager.access$updateState(this.this$0, this.$id, collect.2::windowActivated$lambda$3);
                                                }

                                                private static final ApplicationState.WindowState windowIconified$lambda$0(WindowStateManager this$0, ApplicationState.WindowState it) {
                                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                    return ApplicationState.WindowState.copy$default(it, null, WindowStateManager.access$getClock$p(this$0).now(), null, 5, null);
                                                }

                                                private static final ApplicationState.WindowState windowDeiconified$lambda$1(ApplicationState.WindowState it) {
                                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                    return ApplicationState.WindowState.copy$default(it, null, null, null, 5, null);
                                                }

                                                private static final ApplicationState.WindowState windowDeactivated$lambda$2(WindowStateManager this$0, ApplicationState.WindowState it) {
                                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                    return ApplicationState.WindowState.copy$default(it, null, null, WindowStateManager.access$getClock$p(this$0).now(), 3, null);
                                                }

                                                private static final ApplicationState.WindowState windowActivated$lambda$3(ApplicationState.WindowState it) {
                                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                    return ApplicationState.WindowState.copy$default(it, null, null, null, 3, null);
                                                }
                                            });
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(WindowDescriptor p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final ApplicationState.WindowState invokeSuspend$lambda$0(WindowDescriptor $descriptor, WindowStateManager this$0, ApplicationState.WindowState it) {
                                return ApplicationState.WindowState.copy$default(it, $descriptor == null ? WindowStateManager.access$getClock$p(this$0).now() : null, null, null, 6, null);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void updateState(WindowId window, Function1<? super ApplicationState.WindowState, ApplicationState.WindowState> transform2) {
        this.applicationStateManager.updateState((Function1<? super ApplicationState, ApplicationState>)((Function1)arg_0 -> WindowStateManager.updateState$lambda$0(window, transform2, arg_0)));
    }

    @NotNull
    public final Job restoreWindows() {
        return BuildersKt.launch$default((CoroutineScope)this.coroutinesScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ WindowStateManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!((Boolean)WindowStateManager.access$getLifecycleTracker$p(this.this$0).getAllowGeneralUi().getValue()).booleanValue()) {
                            Logger.INSTANCE.warn("Showing UI is not allowed. No windows will be restored.");
                            return Unit.INSTANCE;
                        }
                        $this$filterValues$iv = windows = ((ApplicationState)WindowStateManager.access$getApplicationStateManager$p(this.this$0).getState().getValue()).getWindows();
                        $i$f$filterValues = false;
                        result$iv = new LinkedHashMap<String, ApplicationState.WindowState>();
                        for (Map.Entry<String, ApplicationState.WindowState> entry$iv : $this$filterValues$iv.entrySet()) {
                            it /* !! */  = entry$iv.getValue();
                            $i$a$-filterValues-WindowStateManager$restoreWindows$1$openWindows$1 = false;
                            if (!(it /* !! */ .isClosed() == false)) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        openWindows = MapsKt.toMutableMap((Map)result$iv);
                        if (!(openWindows.isEmpty() == false)) ** GOTO lbl86
                        Logger.INSTANCE.debug(openWindows.size() + " open window(s) found.");
                        $this$all$iv = openWindows.values();
                        $i$f$all = false;
                        if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) ** GOTO lbl27
                        v0 = true;
                        ** GOTO lbl34
lbl27:
                        // 2 sources

                        for (Object element$iv : $this$all$iv) {
                            it /* !! */  = (ApplicationState.WindowState)element$iv;
                            $i$a$-all-WindowStateManager$restoreWindows$1$allMinimized$1 = false;
                            if (it /* !! */ .isMinimized()) continue;
                            v0 = false;
                            ** GOTO lbl34
                        }
                        v0 = allMinimized = true;
lbl34:
                        // 3 sources

                        if (allMinimized) {
                            Logger.INSTANCE.debug("All open window(s) are minimized. Restoring the most recently minimized.");
                            var7_12 = openWindows.entrySet();
                            element$iv = var7_12.iterator();
                            if (!element$iv.hasNext()) {
                                v1 /* !! */  = null;
                            } else {
                                it /* !! */  = element$iv.next();
                                if (!element$iv.hasNext()) {
                                    v1 /* !! */  = it /* !! */ ;
                                } else {
                                    $i$a$-all-WindowStateManager$restoreWindows$1$allMinimized$1 = (Map.Entry)it /* !! */ ;
                                    $i$a$-maxByOrNull-WindowStateManager$restoreWindows$1$recentlyMinimizedWindow$1 = false;
                                    state = (ApplicationState.WindowState)$i$a$-all-WindowStateManager$restoreWindows$1$allMinimized$1.getValue();
                                    v2 = state.getMinimizedAt();
                                    if (v2 == null) {
                                        v2 = Instant.Companion.getDISTANT_PAST();
                                    }
                                    $i$a$-all-WindowStateManager$restoreWindows$1$allMinimized$1 = (Comparable)v2;
                                    do {
                                        $i$a$-maxByOrNull-WindowStateManager$restoreWindows$1$recentlyMinimizedWindow$1 = element$iv.next();
                                        state = (Map.Entry)$i$a$-maxByOrNull-WindowStateManager$restoreWindows$1$recentlyMinimizedWindow$1;
                                        $i$a$-maxByOrNull-WindowStateManager$restoreWindows$1$recentlyMinimizedWindow$1 = false;
                                        state = (ApplicationState.WindowState)state.getValue();
                                        v3 = state.getMinimizedAt();
                                        if (v3 == null) {
                                            v3 = Instant.Companion.getDISTANT_PAST();
                                        }
                                        if ($i$a$-all-WindowStateManager$restoreWindows$1$allMinimized$1.compareTo(state = (Comparable)v3) >= 0) continue;
                                        it /* !! */  = $i$a$-maxByOrNull-WindowStateManager$restoreWindows$1$recentlyMinimizedWindow$1;
                                        $i$a$-all-WindowStateManager$restoreWindows$1$allMinimized$1 = state;
                                    } while (element$iv.hasNext());
                                    v1 /* !! */  = it /* !! */ ;
                                }
                            }
                            v4 = recentlyMinimizedWindow = (Map.Entry)v1 /* !! */ ;
                            if (v4 != null) {
                                var7_12 = v4;
                                $i$a$-let-WindowStateManager$restoreWindows$1$1 = false;
                                id = (String)var7_12.getKey();
                                state = (ApplicationState.WindowState)var7_12.getValue();
                                openWindows.put(id, ApplicationState.WindowState.copy$default(state, null, null, null, 5, null));
                            }
                        }
                        recentlyMinimizedWindow = openWindows;
                        $i$f$all = this.this$0;
                        $i$f$forEach = false;
                        $i$a$-let-WindowStateManager$restoreWindows$1$1 = $this$forEach$iv.entrySet().iterator();
                        while ($i$a$-let-WindowStateManager$restoreWindows$1$1.hasNext()) {
                            state = element$iv = $i$a$-let-WindowStateManager$restoreWindows$1$1.next();
                            $i$a$-forEach-WindowStateManager$restoreWindows$1$2 = false;
                            id = (String)state.getKey();
                            state = (ApplicationState.WindowState)state.getValue();
                            WindowStateManager.access$showWindow($i$f$all, id, state);
                        }
                        return Unit.INSTANCE;
lbl86:
                        // 1 sources

                        Logger.INSTANCE.debug("No open windows found. Selecting the most recently closed.");
                        $this$maxByOrNull$iv = windows.entrySet();
                        $i$f$maxByOrNull = false;
                        iterator$iv = $this$maxByOrNull$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            v5 = null;
                        } else {
                            maxElem$iv = iterator$iv.next();
                            if (!iterator$iv.hasNext()) {
                                v5 = maxElem$iv;
                            } else {
                                element$iv = (Map.Entry<K, V>)maxElem$iv;
                                $i$a$-maxByOrNull-WindowStateManager$restoreWindows$1$mostRecentWindow$1 = false;
                                state = (ApplicationState.WindowState)element$iv.getValue();
                                v6 = state.getClosedAt();
                                if (v6 == null) {
                                    v6 = Instant.Companion.getDISTANT_PAST();
                                }
                                maxValue$iv = (Comparable)v6;
                                do {
                                    e$iv = iterator$iv.next();
                                    state = (Map.Entry)e$iv;
                                    $i$a$-maxByOrNull-WindowStateManager$restoreWindows$1$mostRecentWindow$1 = false;
                                    state = (ApplicationState.WindowState)state.getValue();
                                    v7 = state.getClosedAt();
                                    if (v7 == null) {
                                        v7 = Instant.Companion.getDISTANT_PAST();
                                    }
                                    if (maxValue$iv.compareTo(v$iv = (Comparable)v7) >= 0) continue;
                                    maxElem$iv = e$iv;
                                    maxValue$iv = v$iv;
                                } while (iterator$iv.hasNext());
                                v5 = maxElem$iv;
                            }
                        }
                        mostRecentWindow = v5;
                        if (mostRecentWindow != null) {
                            WindowStateManager.access$showWindow(this.this$0, (String)mostRecentWindow.getKey(), ApplicationState.WindowState.copy$default((ApplicationState.WindowState)mostRecentWindow.getValue(), null, null, null, 5, null));
                            return Unit.INSTANCE;
                        }
                        Logger.INSTANCE.debug("No recently closed windows found. Showing the tray widget.");
                        WindowStateManager.access$showWindow(this.this$0, TrayWidget.Companion.getTrayWidgetId().getName(), new ApplicationState.WindowState(null, null, null, 7, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void showWindow(String id, ApplicationState.WindowState state2) {
        Logger.INSTANCE.debug("Showing '" + id + "' in " + state2);
        BuildersKt.launch$default((CoroutineScope)this.coroutinesScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, id, state2, null){
            int label;
            final /* synthetic */ WindowStateManager this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ ApplicationState.WindowState $state;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                this.$state = $state;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        PersistableWindowProvider persistableWindowProvider = this.this$0.getProviders().get(this.$id);
                        if (persistableWindowProvider == null) break;
                        this.label = 1;
                        Object object2 = persistableWindowProvider.showWindow(this.$state.isMinimized(), (Continuation<? super Unit>)((Continuation)this));
                        if (object2 == object) {
                            return object;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final ApplicationState updateState$lambda$0(WindowId $window, Function1 $transform, ApplicationState it) {
        ApplicationState.WindowState newState;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ApplicationState.WindowState oldState = it.getWindows().get($window.getName());
        ApplicationState.WindowState windowState = oldState;
        if (windowState == null) {
            windowState = new ApplicationState.WindowState(null, null, null, 7, null);
        }
        return Intrinsics.areEqual((Object)oldState, (Object)(newState = (ApplicationState.WindowState)$transform.invoke((Object)windowState))) ? it : ApplicationState.copy$default(it, null, MapsKt.plus(it.getWindows(), (Pair)TuplesKt.to((Object)$window.getName(), (Object)newState)), 1, null);
    }

    public static final /* synthetic */ void access$updateState(WindowStateManager $this, WindowId window, Function1 transform2) {
        $this.updateState(window, (Function1<? super ApplicationState.WindowState, ApplicationState.WindowState>)transform2);
    }

    public static final /* synthetic */ Clock access$getClock$p(WindowStateManager $this) {
        return $this.clock;
    }

    public static final /* synthetic */ AppLifecycleTracker access$getLifecycleTracker$p(WindowStateManager $this) {
        return $this.lifecycleTracker;
    }

    public static final /* synthetic */ ApplicationStateManager access$getApplicationStateManager$p(WindowStateManager $this) {
        return $this.applicationStateManager;
    }

    public static final /* synthetic */ void access$showWindow(WindowStateManager $this, String id, ApplicationState.WindowState state2) {
        $this.showWindow(id, state2);
    }
}

