/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.window;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.ui.window.DialogState;
import androidx.compose.ui.window.DialogWindowScope;
import androidx.compose.ui.window.FrameWindowScope;
import androidx.compose.ui.window.WindowState;
import com.jetbrains.toolbox.ui.window.DialogDescriptorImpl;
import com.jetbrains.toolbox.ui.window.WindowDescriptorImpl;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.crystal.WindowDescriptor;
import org.tinylog.kotlin.Logger;

public final class DescriptorsKt {
    @NotNull
    public static final WindowDescriptor createWindowDescriptor(@NotNull WindowState state2, @NotNull FrameWindowScope scope2, @NotNull MutableState<Boolean> visibilityState, @NotNull Function0<Unit> closeCallback) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(visibilityState, (String)"visibilityState");
        Intrinsics.checkNotNullParameter(closeCallback, (String)"closeCallback");
        return new WindowDescriptorImpl(state2, scope2, visibilityState, closeCallback);
    }

    @NotNull
    public static final WindowDescriptor createDialogDescriptor(@NotNull DialogState state2, @NotNull DialogWindowScope scope2, @NotNull MutableState<Boolean> visibilityState, @NotNull Function0<Unit> closeCallback) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(visibilityState, (String)"visibilityState");
        Intrinsics.checkNotNullParameter(closeCallback, (String)"closeCallback");
        return new DialogDescriptorImpl(state2, scope2, visibilityState, closeCallback);
    }

    private static final MutableState<Boolean> createFocusedState(Window window, Function0<String> winTitleSupplier) {
        MutableState state2 = SnapshotStateKt.mutableStateOf$default(true, null, 2, null);
        window.addWindowFocusListener(new WindowFocusListener(state2, winTitleSupplier){
            final /* synthetic */ MutableState<Boolean> $state;
            final /* synthetic */ Function0<String> $winTitleSupplier;
            {
                this.$state = $state;
                this.$winTitleSupplier = $winTitleSupplier;
            }

            public void windowGainedFocus(WindowEvent e) {
                this.$state.setValue(true);
                Logger.INSTANCE.trace("Window " + this.$winTitleSupplier.invoke() + " gained focus");
            }

            public void windowLostFocus(WindowEvent e) {
                this.$state.setValue(false);
                Logger.INSTANCE.trace("Window " + this.$winTitleSupplier.invoke() + " lost focus");
            }
        });
        return state2;
    }

    public static final /* synthetic */ MutableState access$createFocusedState(Window window, Function0 winTitleSupplier) {
        return DescriptorsKt.createFocusedState(window, (Function0<String>)winTitleSupplier);
    }
}

