/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.window;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.snapshots.SnapshotStateList;
import androidx.compose.ui.unit.DpSize;
import androidx.compose.ui.window.WindowExceptionHandler;
import androidx.compose.ui.window.WindowPlacement;
import androidx.compose.ui.window.WindowPosition;
import com.jetbrains.JBR;
import com.jetbrains.WindowDecorations;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.desktop.window.DecorationsKt;
import com.jetbrains.toolbox.macos.DockKt;
import com.jetbrains.toolbox.ui.window.DimensionsKt;
import com.jetbrains.toolbox.ui.window.WindowGrowPolicy;
import com.jetbrains.toolbox.ui.window.WindowInfo;
import com.jetbrains.toolbox.ui.window.WindowType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.crystal.WindowDescriptor;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nComposeWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeWindowManager.kt\ncom/jetbrains/toolbox/ui/window/ComposeWindowManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,163:1\n1#2:164\n1761#3,3:165\n2746#3,3:173\n2746#3,3:176\n230#4,5:168\n230#4,5:179\n230#4,5:184\n*S KotlinDebug\n*F\n+ 1 ComposeWindowManager.kt\ncom/jetbrains/toolbox/ui/window/ComposeWindowManager\n*L\n106#1:165,3\n114#1:173,3\n120#1:176,3\n113#1:168,5\n124#1:179,5\n134#1:184,5\n*E\n"})
public final class ComposeWindowManager {
    @NotNull
    private final SnapshotStateList<WindowInfo> _windows = SnapshotStateKt.mutableStateListOf();
    @NotNull
    private final Set<WindowInfo> minimizedWindows = new LinkedHashSet();
    @NotNull
    private final MutableStateFlow<Boolean> anyWindowShownStateFlow = StateFlowKt.MutableStateFlow((Object)false);
    @Nullable
    private final WindowDecorations winDecorations = DecorationsKt.isCustomDecorationsSupported() ? JBR.getWindowDecorations() : null;
    public static final int $stable = 8;

    @NotNull
    public final List<WindowInfo> getWindows$ui_common() {
        return this._windows;
    }

    public final void showWindow-x-zjywE(long l, @Nullable WindowGrowPolicy growPolicy, long l2, @NotNull WindowPosition position, @NotNull WindowPlacement placement, @NotNull WindowType type2, boolean visible, boolean minimized, @NotNull String title2, boolean undecorated, boolean resizable, boolean alwaysOnTop, boolean closeOnFocusLost, float f, @Nullable WindowExceptionHandler exceptionHandler2, @NotNull Function3<? super WindowDescriptor, ? super Composer, ? super Integer, Unit> content2) {
        WindowDecorations windowDecorations;
        WindowDecorations windowDecorations2;
        WindowDecorations windowDecorations3;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)((Object)placement), (String)"placement");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(content2, (String)"content");
        Logger.INSTANCE.info("Show window request. Window: " + title2 + ", type: " + type2);
        WindowDecorations it = windowDecorations3 = this.winDecorations;
        boolean bl = false;
        Object object = windowDecorations2 = !undecorated ? windowDecorations3 : null;
        if (windowDecorations2 != null && (windowDecorations3 = windowDecorations2.createCustomTitleBar()) != null) {
            WindowDecorations windowDecorations4;
            WindowDecorations $this$showWindow_x_zjywE_u24lambda_u241 = windowDecorations4 = windowDecorations3;
            boolean bl2 = false;
            $this$showWindow_x_zjywE_u24lambda_u241.setHeight(f);
            windowDecorations = windowDecorations4;
        } else {
            windowDecorations = null;
        }
        WindowDecorations customTitleBar = windowDecorations;
        WindowInfo info = new WindowInfo(type2, l, growPolicy, l2, position, placement, visible, minimized, title2, undecorated, resizable, alwaysOnTop, closeOnFocusLost, (WindowDecorations.CustomTitleBar)customTitleBar, exceptionHandler2, content2, null);
        this.addWindow$ui_common(info);
    }

    public static /* synthetic */ void showWindow-x-zjywE$default(ComposeWindowManager composeWindowManager, long l, WindowGrowPolicy windowGrowPolicy, long l2, WindowPosition windowPosition, WindowPlacement windowPlacement, WindowType windowType, boolean bl, boolean bl2, String string, boolean bl3, boolean bl4, boolean bl5, boolean bl6, float f, WindowExceptionHandler windowExceptionHandler, Function3 function3, int n, Object object) {
        if ((n & 2) != 0) {
            windowGrowPolicy = null;
        }
        if ((n & 4) != 0) {
            l2 = DpSize.Companion.getUnspecified-MYxV2XQ();
        }
        if ((n & 8) != 0) {
            windowPosition = WindowPosition.PlatformDefault.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            windowPlacement = WindowPlacement.Floating;
        }
        if ((n & 0x20) != 0) {
            windowType = WindowType.WINDOW;
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        if ((n & 0x100) != 0) {
            string = "";
        }
        if ((n & 0x200) != 0) {
            bl3 = false;
        }
        if ((n & 0x400) != 0) {
            bl4 = true;
        }
        if ((n & 0x800) != 0) {
            bl5 = false;
        }
        if ((n & 0x1000) != 0) {
            bl6 = false;
        }
        if ((n & 0x2000) != 0) {
            f = DimensionsKt.getAPP_FULL_WIDE_WINDOW_HEADER_DEFAULT_HEIGHT();
        }
        if ((n & 0x4000) != 0) {
            windowExceptionHandler = null;
        }
        composeWindowManager.showWindow-x-zjywE(l, windowGrowPolicy, l2, windowPosition, windowPlacement, windowType, bl, bl2, string, bl3, bl4, bl5, bl6, f, windowExceptionHandler, (Function3<? super WindowDescriptor, ? super Composer, ? super Integer, Unit>)function3);
    }

    public final void showDialog-3hFPL-0(long l, @Nullable WindowGrowPolicy growPolicy, long l2, @NotNull WindowPosition position, boolean visible, @NotNull String title2, boolean undecorated, boolean resizable, boolean alwaysOnTop, boolean closeOnFocusLost, @Nullable WindowExceptionHandler exceptionHandler2, @NotNull Function3<? super WindowDescriptor, ? super Composer, ? super Integer, Unit> content2) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(content2, (String)"content");
        WindowType windowType = WindowType.DIALOG;
        ComposeWindowManager.showWindow-x-zjywE$default(this, l, growPolicy, l2, position, null, windowType, visible, false, title2, undecorated, resizable, alwaysOnTop, closeOnFocusLost, 0.0f, exceptionHandler2, content2, 8336, null);
    }

    public static /* synthetic */ void showDialog-3hFPL-0$default(ComposeWindowManager composeWindowManager, long l, WindowGrowPolicy windowGrowPolicy, long l2, WindowPosition windowPosition, boolean bl, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, WindowExceptionHandler windowExceptionHandler, Function3 function3, int n, Object object) {
        if ((n & 2) != 0) {
            windowGrowPolicy = null;
        }
        if ((n & 4) != 0) {
            l2 = DpSize.Companion.getUnspecified-MYxV2XQ();
        }
        if ((n & 8) != 0) {
            windowPosition = WindowPosition.PlatformDefault.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            string = "";
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        if ((n & 0x80) != 0) {
            bl3 = true;
        }
        if ((n & 0x100) != 0) {
            bl4 = false;
        }
        if ((n & 0x200) != 0) {
            bl5 = false;
        }
        if ((n & 0x400) != 0) {
            windowExceptionHandler = null;
        }
        composeWindowManager.showDialog-3hFPL-0(l, windowGrowPolicy, l2, windowPosition, bl, string, bl2, bl3, bl4, bl5, windowExceptionHandler, (Function3<? super WindowDescriptor, ? super Composer, ? super Integer, Unit>)function3);
    }

    public final boolean isAnyWindowShown() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this._windows;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WindowInfo it = (WindowInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it.getVisible() && !this.minimizedWindows.contains(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final StateFlow<Boolean> isAnyWindowShownFlow() {
        return (StateFlow)this.anyWindowShownStateFlow;
    }

    public final void removeWindow$ui_common(@NotNull WindowInfo info) {
        boolean bl;
        block5: {
            Boolean nextValue$iv;
            Object prevValue$iv;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this._windows.remove(info);
            this.minimizedWindows.remove(info);
            MutableStateFlow<Boolean> $this$update$iv = this.anyWindowShownStateFlow;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                boolean it = (Boolean)prevValue$iv;
                boolean bl2 = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Boolean.valueOf(this.isAnyWindowShown()))));
            Iterable $this$none$iv = this._windows;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    WindowInfo it = (WindowInfo)element$iv;
                    boolean bl3 = false;
                    if (!it.getShowDockIcon()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl && info.getShowDockIcon() && OS.INSTANCE.isMac()) {
            DockKt.macosDockIconVisible(false);
        }
    }

    public final void addWindow$ui_common(@NotNull WindowInfo info) {
        Boolean nextValue$iv;
        Object prevValue$iv;
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Iterable $this$none$iv = this._windows;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    WindowInfo it = (WindowInfo)element$iv;
                    boolean bl2 = false;
                    if (!it.getShowDockIcon()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl && info.getShowDockIcon() && OS.INSTANCE.isMac()) {
            DockKt.macosDockIconVisible(true);
        }
        this._windows.add(info);
        MutableStateFlow<Boolean> $this$update$iv = this.anyWindowShownStateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            boolean it = (Boolean)prevValue$iv;
            boolean bl3 = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Boolean.valueOf(this.isAnyWindowShown()))));
    }

    public final void onWindowStateChange$ui_common(@NotNull WindowInfo info, boolean minimized) {
        Boolean nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Logger.INSTANCE.debug("Window " + info.getTitle() + " " + (minimized ? "minimized" : "restored"));
        boolean bl = minimized ? this.minimizedWindows.add(info) : this.minimizedWindows.remove(info);
        MutableStateFlow<Boolean> $this$update$iv = this.anyWindowShownStateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            boolean it = (Boolean)prevValue$iv;
            boolean bl2 = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Boolean.valueOf(this.isAnyWindowShown()))));
    }
}

