/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.navigation;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.desktop.window.WindowId;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.settings.Tab;
import com.jetbrains.toolbox.ui.navigation.NavigationContext;
import com.jetbrains.toolbox.ui.navigation.Navigator;
import com.jetbrains.toolbox.ui.navigation.Screen;
import com.jetbrains.toolbox.ui.navigation.ScreenWithTitle;
import com.jetbrains.toolbox.ui.navigation.route.NavigationStackStorage;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nNavigatorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigatorImpl.kt\ncom/jetbrains/toolbox/ui/navigation/NavigatorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1#2:214\n*E\n"})
public final class NavigatorImpl
implements Navigator {
    @NotNull
    private final Function0<Unit> onBeforeNavigate;
    @NotNull
    private final Function1<NavigationContext, Unit> onAfterNavigate;
    @Nullable
    private final WindowId windowId;
    @NotNull
    private final NavigationStackStorage navigationStackStorage;
    @NotNull
    private final ArrayDeque<ScreenWithTitle> navigationStack;
    @NotNull
    private final ArrayDeque<ScreenWithTitle> frontNavigationStack;
    @NotNull
    private final MutableStateFlow<Screen> _current;
    @NotNull
    private final MutableStateFlow<LocalizableString> currentScreenTitleState;
    @NotNull
    private final StateFlow<Screen> current;
    @NotNull
    private final MutableStateFlow<ScreenWithTitle> _previousScreenState;
    @NotNull
    private final StateFlow<ScreenWithTitle> previousScreenState;
    @NotNull
    private final MutableStateFlow<ScreenWithTitle> _nextScreenState;
    @NotNull
    private final StateFlow<ScreenWithTitle> nextScreenState;
    @NotNull
    private Tab mainPageTab;
    public static final int $stable = 8;

    public NavigatorImpl(@NotNull Screen initialScreen, @NotNull Tab selectedMainPageTab, @NotNull Function0<Unit> onBeforeNavigate, @NotNull Function1<? super NavigationContext, Unit> onAfterNavigate, @Nullable WindowId windowId, @NotNull NavigationStackStorage navigationStackStorage, boolean restoreStackIfAvailable) {
        List<ScreenWithTitle> stack;
        Intrinsics.checkNotNullParameter((Object)initialScreen, (String)"initialScreen");
        Intrinsics.checkNotNullParameter((Object)((Object)selectedMainPageTab), (String)"selectedMainPageTab");
        Intrinsics.checkNotNullParameter(onBeforeNavigate, (String)"onBeforeNavigate");
        Intrinsics.checkNotNullParameter(onAfterNavigate, (String)"onAfterNavigate");
        Intrinsics.checkNotNullParameter((Object)navigationStackStorage, (String)"navigationStackStorage");
        this.onBeforeNavigate = onBeforeNavigate;
        this.onAfterNavigate = onAfterNavigate;
        this.windowId = windowId;
        this.navigationStackStorage = navigationStackStorage;
        this.frontNavigationStack = new ArrayDeque();
        this.currentScreenTitleState = StateFlowKt.MutableStateFlow((Object)LocalizableStringExKt.notr(""));
        WindowId windowId2 = this.getWindowId();
        if (windowId2 != null) {
            WindowId windowId3 = windowId2;
            NavigationStackStorage navigationStackStorage2 = this.navigationStackStorage;
            WindowId p0 = windowId3;
            boolean bl = false;
            v1 = navigationStackStorage2.restore(p0);
        } else {
            v1 = stack = null;
        }
        if (restoreStackIfAvailable && stack != null) {
            ScreenWithTitle current = (ScreenWithTitle)CollectionsKt.lastOrNull(stack);
            Object object = current;
            if (object == null || (object = ((ScreenWithTitle)object).getScreen()) == null) {
                object = initialScreen;
            }
            this._current = StateFlowKt.MutableStateFlow((Object)object);
            this.navigationStack = new ArrayDeque((Collection)CollectionsKt.dropLast(stack, (int)1));
            ScreenWithTitle screenWithTitle = current;
            if (screenWithTitle == null || (screenWithTitle = screenWithTitle.getTitle()) == null) {
                screenWithTitle = LocalizableStringExKt.notr("");
            }
            this.setCurrentScreenTitle((LocalizableString)screenWithTitle);
        } else {
            this._current = StateFlowKt.MutableStateFlow((Object)initialScreen);
            this.navigationStack = new ArrayDeque();
            this.setCurrentScreenTitle(LocalizableStringExKt.notr(""));
        }
        this.current = FlowKt.asStateFlow(this._current);
        this._previousScreenState = StateFlowKt.MutableStateFlow(null);
        this.previousScreenState = FlowKt.asStateFlow(this._previousScreenState);
        this._nextScreenState = StateFlowKt.MutableStateFlow(null);
        this.nextScreenState = FlowKt.asStateFlow(this._nextScreenState);
        this.mainPageTab = selectedMainPageTab;
        this.storeStack();
        this.updateStacks();
    }

    @Nullable
    public WindowId getWindowId() {
        return this.windowId;
    }

    @Override
    @NotNull
    public MutableStateFlow<LocalizableString> getCurrentScreenTitleState() {
        return this.currentScreenTitleState;
    }

    @NotNull
    public LocalizableString getCurrentScreenTitle() {
        return (LocalizableString)this.getCurrentScreenTitleState().getValue();
    }

    @Override
    public void setCurrentScreenTitle(@NotNull LocalizableString value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.getCurrentScreenTitleState().setValue((Object)value2);
    }

    @Override
    @NotNull
    public StateFlow<Screen> getCurrent() {
        return this.current;
    }

    @Override
    @NotNull
    public StateFlow<ScreenWithTitle> getPreviousScreenState() {
        return this.previousScreenState;
    }

    @Override
    @Nullable
    public ScreenWithTitle getPreviousScreen() {
        return (ScreenWithTitle)this._previousScreenState.getValue();
    }

    @Override
    @NotNull
    public StateFlow<ScreenWithTitle> getNextScreenState() {
        return this.nextScreenState;
    }

    @Nullable
    public ScreenWithTitle getNextScreen() {
        return (ScreenWithTitle)this.getNextScreenState().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void navigate(@NotNull Screen screen, boolean force, @NotNull FusEnums.UIGenerator generator) {
        Screen screen2;
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Intrinsics.checkNotNullParameter((Object)((Object)generator), (String)"generator");
        this.onBeforeNavigate.invoke();
        if (Intrinsics.areEqual((Object)((Screen)this._current.getValue()).getId(), (Object)screen.getId())) {
            return;
        }
        if (!((Screen)this._current.getValue()).getAllowNavigation() && !force) {
            Logger.INSTANCE.debug("Trying to navigate away from a blocking screen " + ((Screen)this._current.getValue()).getId());
            return;
        }
        boolean enteringTopLevelScreen = screen instanceof Screen.TopLevelScreen;
        NavigatorImpl navigatorImpl = this;
        synchronized (navigatorImpl) {
            boolean bl = false;
            Screen previousScreen = (Screen)this._current.getValue();
            this.navigationStack.addLast((Object)new ScreenWithTitle((Screen)this._current.getValue(), this.getCurrentScreenTitle()));
            Logger.INSTANCE.info("NAVIGATION: " + Reflection.getOrCreateKotlinClass(previousScreen.getClass()).getSimpleName() + " ==> " + screen);
            this._current.setValue((Object)screen);
            this.setCurrentScreenTitle(LocalizableStringExKt.notr(""));
            this.frontNavigationStack.clear();
            screen2 = previousScreen;
        }
        Screen previousScreen = screen2;
        this.updateStacks();
        this.storeStack();
        this.onAfterNavigate.invoke((Object)new NavigationContext(previousScreen, screen, generator));
    }

    @Override
    @NotNull
    public LocalizableString getBackLabel() {
        ScreenWithTitle screenWithTitle = this.getPreviousScreen();
        if (Intrinsics.areEqual((Object)(screenWithTitle != null ? screenWithTitle.getScreen() : null), (Object)Screen.Main.INSTANCE)) {
            return LocalizableStringExKt.trl(this.mainPageTab.name());
        }
        ScreenWithTitle screenWithTitle2 = this.getPreviousScreen();
        if (screenWithTitle2 == null || (screenWithTitle2 = screenWithTitle2.getTitle()) == null) {
            screenWithTitle2 = LocalizableStringExKt.trl("Back");
        }
        return screenWithTitle2;
    }

    @Override
    @NotNull
    public LocalizableString getForwardLabel() {
        ScreenWithTitle screenWithTitle = this.getNextScreen();
        if (Intrinsics.areEqual((Object)(screenWithTitle != null ? screenWithTitle.getScreen() : null), (Object)Screen.Main.INSTANCE)) {
            return LocalizableStringExKt.trl(this.mainPageTab.name());
        }
        ScreenWithTitle screenWithTitle2 = this.getNextScreen();
        if (screenWithTitle2 == null || (screenWithTitle2 = screenWithTitle2.getTitle()) == null) {
            screenWithTitle2 = LocalizableStringExKt.trl("Forward");
        }
        return screenWithTitle2;
    }

    @Override
    public void changeTab(@NotNull Tab tab) {
        Intrinsics.checkNotNullParameter((Object)((Object)tab), (String)"tab");
        if (Intrinsics.areEqual((Object)this.getCurrent().getValue(), (Object)Screen.Main.INSTANCE)) {
            this.onBeforeNavigate.invoke();
            this.mainPageTab = tab;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void back(boolean force, @NotNull FusEnums.UIGenerator generator) {
        NavigationContext navigationContext;
        Intrinsics.checkNotNullParameter((Object)((Object)generator), (String)"generator");
        NavigatorImpl navigatorImpl = this;
        synchronized (navigatorImpl) {
            boolean bl = false;
            Screen currentScreen = (Screen)this._current.getValue();
            if (!currentScreen.getAllowNavigation() && !force) {
                Logger.INSTANCE.debug("Trying to navigate away from a blocking screen " + currentScreen.getId());
                return;
            }
            ScreenWithTitle screenWithTitle = (ScreenWithTitle)this.navigationStack.removeLastOrNull();
            if (screenWithTitle == null) {
                screenWithTitle = new ScreenWithTitle(Screen.Main.INSTANCE, LocalizableStringExKt.trl(""));
            }
            ScreenWithTitle backScreen = screenWithTitle;
            this.frontNavigationStack.addLast((Object)new ScreenWithTitle(currentScreen, this.getCurrentScreenTitle()));
            Logger.INSTANCE.info("NAVIGATION: " + backScreen.getScreen() + " <== " + Reflection.getOrCreateKotlinClass(currentScreen.getClass()).getSimpleName());
            this._current.setValue((Object)backScreen.getScreen());
            this.setCurrentScreenTitle(backScreen.getTitle());
            navigationContext = new NavigationContext(currentScreen, backScreen.getScreen(), generator);
        }
        NavigationContext context2 = navigationContext;
        this.storeStack();
        this.updateStacks();
        this.onAfterNavigate.invoke((Object)context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forward(@NotNull FusEnums.UIGenerator generator) {
        NavigationContext navigationContext;
        Intrinsics.checkNotNullParameter((Object)((Object)generator), (String)"generator");
        NavigatorImpl navigatorImpl = this;
        synchronized (navigatorImpl) {
            boolean bl = false;
            Screen currentScreen = (Screen)this._current.getValue();
            if (!currentScreen.getAllowNavigation()) {
                Logger.INSTANCE.debug("Trying to forward from a blocking screen " + currentScreen.getId());
                return;
            }
            ScreenWithTitle screenWithTitle = (ScreenWithTitle)this.frontNavigationStack.removeLastOrNull();
            if (screenWithTitle == null) {
                return;
            }
            ScreenWithTitle nextScreen = screenWithTitle;
            Logger.INSTANCE.info("FORWARD: " + Reflection.getOrCreateKotlinClass(currentScreen.getClass()).getSimpleName() + " ==> " + nextScreen.getScreen());
            this.navigationStack.addLast((Object)new ScreenWithTitle(currentScreen, this.getCurrentScreenTitle()));
            this._current.setValue((Object)nextScreen.getScreen());
            this.setCurrentScreenTitle(nextScreen.getTitle());
            navigationContext = new NavigationContext(currentScreen, nextScreen.getScreen(), generator);
        }
        NavigationContext context2 = navigationContext;
        this.storeStack();
        this.updateStacks();
        this.onAfterNavigate.invoke((Object)context2);
    }

    private final void updateStacks() {
        this._previousScreenState.setValue(this.navigationStack.lastOrNull());
        this._nextScreenState.setValue(this.frontNavigationStack.lastOrNull());
    }

    private final void storeStack() {
        if (this.getWindowId() != null) {
            List stack = CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)((Iterable)this.navigationStack)), (Object)new ScreenWithTitle((Screen)this.getCurrent().getValue(), this.getCurrentScreenTitle()));
            this.navigationStackStorage.store(this.getWindowId(), stack);
        }
    }
}

