/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.navigation;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.desktop.window.WindowId;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.fus.FusFieldDescriptions;
import com.jetbrains.toolbox.manager.StatisticsManager;
import com.jetbrains.toolbox.settings.Storage;
import com.jetbrains.toolbox.settings.StorageManager;
import com.jetbrains.toolbox.settings.Tab;
import com.jetbrains.toolbox.ui.ScreenManager;
import com.jetbrains.toolbox.ui.navigation.NavigationContext;
import com.jetbrains.toolbox.ui.navigation.Navigator;
import com.jetbrains.toolbox.ui.navigation.NavigatorImpl;
import com.jetbrains.toolbox.ui.navigation.Screen;
import com.jetbrains.toolbox.ui.navigation.route.NavigationStackStorage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nNavigatorFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigatorFactory.kt\ncom/jetbrains/toolbox/ui/navigation/NavigatorFactory\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n72#2,2:92\n1#3:94\n1#3:95\n*S KotlinDebug\n*F\n+ 1 NavigatorFactory.kt\ncom/jetbrains/toolbox/ui/navigation/NavigatorFactory\n*L\n22#1:92,2\n22#1:94\n*E\n"})
public final class NavigatorFactory {
    @NotNull
    private final ScreenManager screenManager;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final NavigationStackStorage navigationStackStorage;
    @NotNull
    private final StatisticsManager statisticsManager;
    @NotNull
    private final ConcurrentHashMap<WindowId, Navigator> navigators;
    public static final int $stable = 8;

    public NavigatorFactory(@NotNull ScreenManager screenManager, @NotNull StorageManager storageManager, @NotNull NavigationStackStorage navigationStackStorage, @NotNull StatisticsManager statisticsManager) {
        Intrinsics.checkNotNullParameter((Object)screenManager, (String)"screenManager");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)navigationStackStorage, (String)"navigationStackStorage");
        Intrinsics.checkNotNullParameter((Object)statisticsManager, (String)"statisticsManager");
        this.screenManager = screenManager;
        this.storageManager = storageManager;
        this.navigationStackStorage = navigationStackStorage;
        this.statisticsManager = statisticsManager;
        this.navigators = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Navigator createNavigator(@NotNull WindowId windowId, @Nullable Screen initialScreen, @NotNull Function0<Unit> registrySaver) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        Intrinsics.checkNotNullParameter(registrySaver, (String)"registrySaver");
        ConcurrentMap concurrentMap = this.navigators;
        WindowId key$iv = windowId;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Screen startScreen = this.screenManager.initialScreen(initialScreen);
            boolean restoreStack = initialScreen == null && this.screenManager.initialScreenOrNull(null) == null;
            Tab tab = ((Storage)this.storageManager.getStorage().getValue()).getSelectedMainPageTab();
            NavigationStackStorage navigationStackStorage = this.navigationStackStorage;
            Navigator default$iv = new NavigatorImpl(startScreen, tab, registrySaver, (Function1<? super NavigationContext, Unit>)((Function1)arg_0 -> NavigatorFactory.createNavigator$lambda$0$0(this, arg_0)), windowId, navigationStackStorage, restoreStack);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        concurrentMap = object;
        Navigator it = (Navigator)((Object)concurrentMap);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        this.screenManager.resetBlockingScreen(it);
        ConcurrentMap concurrentMap2 = concurrentMap;
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"also(...)");
        return (Navigator)((Object)concurrentMap2);
    }

    private static final Unit createNavigator$lambda$0$0(NavigatorFactory this$0, NavigationContext $this$NavigatorImpl) {
        Intrinsics.checkNotNullParameter((Object)$this$NavigatorImpl, (String)"$this$NavigatorImpl");
        Screen screen = $this$NavigatorImpl.getFrom();
        if (screen instanceof Screen.Settings) {
            this$0.statisticsManager.getLogger().logVararg(Fus.Counters.UI.INSTANCE.getSelfSettings(), arg_0 -> NavigatorFactory.createNavigator$lambda$0$0$0($this$NavigatorImpl, arg_0));
        } else if (screen instanceof Screen.WhatsNewInAvailableTool) {
            this$0.statisticsManager.getLogger().logVararg(Fus.Counters.UI.INSTANCE.getWhatsNew(), arg_0 -> NavigatorFactory.createNavigator$lambda$0$0$1($this$NavigatorImpl, arg_0));
        } else if (screen instanceof Screen.WhatsNewInApp) {
            this$0.statisticsManager.getLogger().logVararg(Fus.Counters.UI.INSTANCE.getWhatsNew(), arg_0 -> NavigatorFactory.createNavigator$lambda$0$0$2($this$NavigatorImpl, arg_0));
        } else if (screen instanceof Screen.WhatsNewInCurrentApp) {
            this$0.statisticsManager.getLogger().logVararg(Fus.Counters.UI.INSTANCE.getWhatsNew(), arg_0 -> NavigatorFactory.createNavigator$lambda$0$0$3($this$NavigatorImpl, arg_0));
        } else if (screen instanceof Screen.ThirdParty) {
            this$0.statisticsManager.getLogger().log(Fus.Counters.UI.INSTANCE.getThirdPartySoftware(), FusEnums.UIAction.CLOSE, $this$NavigatorImpl.getGenerator());
        } else if (screen instanceof Screen.LeftoverIDEDirectories) {
            this$0.statisticsManager.getLogger().logVararg(Fus.Counters.UI.INSTANCE.getLeftoverIDEDirectories(), arg_0 -> NavigatorFactory.createNavigator$lambda$0$0$4($this$NavigatorImpl, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createNavigator$lambda$0$0$0(NavigationContext $this_NavigatorImpl, FusFieldDescriptions.UISettings $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction(FusEnums.UIAction.CLOSE);
        $this$logVararg.setGenerator($this_NavigatorImpl.getGenerator());
        return Unit.INSTANCE;
    }

    private static final Unit createNavigator$lambda$0$0$1(NavigationContext $this_NavigatorImpl, FusFieldDescriptions.UIToolAction $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction(FusEnums.UIAction.CLOSE);
        $this$logVararg.setGenerator($this_NavigatorImpl.getGenerator());
        $this$logVararg.withTool-dgXOpgo(((Screen.WhatsNewInAvailableTool)$this_NavigatorImpl.getFrom()).getDistributionId().getToolId-UtVBrGo(), ((Screen.WhatsNewInAvailableTool)$this_NavigatorImpl.getFrom()).getDistributionId().getBuildNumber-Y_E1uuk());
        return Unit.INSTANCE;
    }

    private static final Unit createNavigator$lambda$0$0$2(NavigationContext $this_NavigatorImpl, FusFieldDescriptions.UIToolAction $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction(FusEnums.UIAction.CLOSE);
        $this$logVararg.setGenerator($this_NavigatorImpl.getGenerator());
        return Unit.INSTANCE;
    }

    private static final Unit createNavigator$lambda$0$0$3(NavigationContext $this_NavigatorImpl, FusFieldDescriptions.UIToolAction $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction(FusEnums.UIAction.CLOSE);
        $this$logVararg.setGenerator($this_NavigatorImpl.getGenerator());
        $this$logVararg.withSelf(Build.INSTANCE.getBuildNumber-Y_E1uuk());
        return Unit.INSTANCE;
    }

    private static final Unit createNavigator$lambda$0$0$4(NavigationContext $this_NavigatorImpl, FusFieldDescriptions.UILeftoverDirectories $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction(FusEnums.UIAction.CLOSE);
        $this$logVararg.setGenerator($this_NavigatorImpl.getGenerator());
        return Unit.INSTANCE;
    }
}

