/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.uninstaller;

import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.common.io.PathExtensionsKt;
import com.jetbrains.toolbox.interop.Pid;
import com.jetbrains.toolbox.tools.ToolUninstaller;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.model.InstallSource;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.runningStatusChecker.MacOsToolRunningStatusChecker;
import com.jetbrains.toolbox.tools.uninstaller.MacOsToolUninstaller;
import com.jetbrains.toolbox.tools.uninstaller.RemoveInstallDirKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class MacOsToolUninstaller
implements ToolUninstaller {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path internalToolsDirectory;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final MacOsToolRunningStatusChecker toolRunningStatusChecker;

    public MacOsToolUninstaller(@NotNull FileSystem fileSystem, @NotNull Path internalToolsDirectory, @NotNull FileUtils fileUtils, @NotNull MacOsToolRunningStatusChecker toolRunningStatusChecker) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)internalToolsDirectory, (String)"internalToolsDirectory");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        Intrinsics.checkNotNullParameter((Object)toolRunningStatusChecker, (String)"toolRunningStatusChecker");
        this.fileSystem = fileSystem;
        this.internalToolsDirectory = internalToolsDirectory;
        this.fileUtils = fileUtils;
        this.toolRunningStatusChecker = toolRunningStatusChecker;
    }

    @Override
    @Nullable
    public Object canUninstall(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super UninstallResult> $completion) {
        MacOsToolRunningStatusChecker.RunningProcess runningProcess = this.toolRunningStatusChecker.getRunningProcess(toolInstance);
        if (runningProcess == null) {
            return UninstallResult.Success.INSTANCE;
        }
        MacOsToolRunningStatusChecker.RunningProcess runningProcess2 = runningProcess;
        return runningProcess2.isMainExecutable() ? (UninstallResult)new UninstallResult.Running(Pid.constructor-impl(runningProcess2.getPid()), null) : (UninstallResult)new UninstallResult.Blocked(runningProcess2.getName());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object uninstall(@NotNull ToolInstance toolInstance, @Nullable Path backupTo, @NotNull Continuation<? super UninstallResult> $completion) {
        if (!($completion instanceof uninstall.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ MacOsToolUninstaller this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.uninstall(null, null, (Continuation<? super UninstallResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.fileSystem.exists(toolInstance.getChannel().getInstallationDirectory())) {
                    return UninstallResult.Success.INSTANCE;
                }
                $continuation.L$0 = toolInstance;
                $continuation.L$1 = backupTo;
                $continuation.label = 1;
                v0 = this.canUninstall(toolInstance, (Continuation<? super UninstallResult>)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                backupTo = (Path)$continuation.L$1;
                toolInstance = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if (!Intrinsics.areEqual((Object)(canUninstall = (UninstallResult)v0), (Object)UninstallResult.Success.INSTANCE)) break;
                if (!FileSystemExtKt.isWritable(this.fileSystem, toolInstance.getChannel().getInstallationDirectory())) {
                    return UninstallResult.DirectoryIsNotWritable.INSTANCE;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)backupTo);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)canUninstall);
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super UninstallResult>, Object>(toolInstance, this, backupTo, null){
                    int label;
                    final /* synthetic */ ToolInstance $toolInstance;
                    final /* synthetic */ MacOsToolUninstaller this$0;
                    final /* synthetic */ Path $backupTo;
                    {
                        this.$toolInstance = $toolInstance;
                        this.this$0 = $receiver;
                        this.$backupTo = $backupTo;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Path parent;
                                ResultKt.throwOnFailure((Object)$result);
                                if (this.$toolInstance.getChannel().getHistory().getSource() == InstallSource.InstalledAutomatically && PathExtensionsKt.contains(MacOsToolUninstaller.access$getInternalToolsDirectory$p(this.this$0), this.$toolInstance.getChannel().getInstallationDirectory()) && (parent = this.$toolInstance.getChannel().getInstallationDirectory().parent()) != null && PathExtensionsKt.contains(MacOsToolUninstaller.access$getInternalToolsDirectory$p(this.this$0), parent)) {
                                    return RemoveInstallDirKt.removeInstallDir$default(MacOsToolUninstaller.access$getFileSystem$p(this.this$0), parent, null, MacOsToolUninstaller.access$getFileUtils$p(this.this$0), 2, null);
                                }
                                return RemoveInstallDirKt.removeInstallDir(MacOsToolUninstaller.access$getFileSystem$p(this.this$0), this.$toolInstance.getChannel().getInstallationDirectory(), this.$backupTo, MacOsToolUninstaller.access$getFileUtils$p(this.this$0));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super UninstallResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl43
            }
            case 2: {
                canUninstall = (UninstallResult)$continuation.L$2;
                backupTo = (Path)$continuation.L$1;
                toolInstance = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                return v1;
            }
        }
        return canUninstall;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Path access$getInternalToolsDirectory$p(MacOsToolUninstaller $this) {
        return $this.internalToolsDirectory;
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(MacOsToolUninstaller $this) {
        return $this.fileSystem;
    }

    public static final /* synthetic */ FileUtils access$getFileUtils$p(MacOsToolUninstaller $this) {
        return $this.fileUtils;
    }
}

