/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.troubleshooting;

import com.jetbrains.toolbox.integration.UrlHandler;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nYoutrackReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YoutrackReportService.kt\ncom/jetbrains/toolbox/tools/troubleshooting/YoutrackReportService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class YoutrackReportService {
    @NotNull
    private final UrlHandler urlHandler;
    @NotNull
    private final String newIssueURL;
    @NotNull
    private final Map<String, String> product2projectMapping;

    public YoutrackReportService(@NotNull UrlHandler urlHandler) {
        Intrinsics.checkNotNullParameter((Object)urlHandler, (String)"urlHandler");
        this.urlHandler = urlHandler;
        this.newIssueURL = "https://youtrack.jetbrains.com/newissue";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"IC", (Object)"IDEA"), TuplesKt.to((Object)"IU", (Object)"IDEA"), TuplesKt.to((Object)"II", (Object)"IDEA"), TuplesKt.to((Object)"RM", (Object)"RUBY"), TuplesKt.to((Object)"PC", (Object)"PY"), TuplesKt.to((Object)"DS", (Object)"DS"), TuplesKt.to((Object)"WS", (Object)"WEB"), TuplesKt.to((Object)"PS", (Object)"WI"), TuplesKt.to((Object)"OC", (Object)"OC"), TuplesKt.to((Object)"QA", (Object)"AQUA"), TuplesKt.to((Object)"RR", (Object)"RUST"), TuplesKt.to((Object)"DB", (Object)"DBE"), TuplesKt.to((Object)"CL", (Object)"CPP"), TuplesKt.to((Object)"RD", (Object)"RIDER"), TuplesKt.to((Object)"GO", (Object)"GO"), TuplesKt.to((Object)"DL", (Object)"DL"), TuplesKt.to((Object)"WRS", (Object)"WRS")};
        this.product2projectMapping = MapsKt.mapOf((Pair[])pairArray);
    }

    public final void reportIssue(@Nullable String productCode, @Nullable String diagnosticsURL) {
        String url = this.generateReportURL(productCode, diagnosticsURL);
        this.urlHandler.openUrl(url);
    }

    private final String generateReportURL(String productCode, String diagnosticsURL) {
        String string;
        String it;
        Object object = CollectionsKt.createListBuilder();
        List $this$generateReportURL_u24lambda_u240 = object;
        boolean bl = false;
        if (productCode != null) {
            it = productCode;
            boolean bl2 = false;
            string = this.product2projectMapping.get(it);
            if (string != null) {
                it = string;
                boolean bl3 = false;
                $this$generateReportURL_u24lambda_u240.add("project=" + it);
            }
        }
        if (diagnosticsURL != null) {
            it = diagnosticsURL;
            boolean bl4 = false;
            string = URLEncoder.encode("Diagnostic data: <" + it + ">", "UTF-8");
            if (string != null) {
                it = string;
                boolean bl5 = false;
                $this$generateReportURL_u24lambda_u240.add("description=" + it);
            }
        }
        List paramsString = CollectionsKt.build((List)object);
        Object $this$generateReportURL_u24lambda_u241 = object = new StringBuilder();
        boolean bl6 = false;
        ((StringBuilder)$this$generateReportURL_u24lambda_u241).append(this.newIssueURL);
        if (!((Collection)paramsString).isEmpty()) {
            ((StringBuilder)$this$generateReportURL_u24lambda_u241).append("?");
            ((StringBuilder)$this$generateReportURL_u24lambda_u241).append(CollectionsKt.joinToString$default((Iterable)paramsString, (CharSequence)"&", null, null, (int)0, null, null, (int)62, null));
        }
        return ((StringBuilder)object).toString();
    }
}

