/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.runningStatusChecker;

import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.common.io.PathExtensionsKt;
import com.jetbrains.toolbox.interop.NativeInteropMacOs;
import com.jetbrains.toolbox.interop.PlistResolver;
import com.jetbrains.toolbox.tools.ToolRunningStatusChecker;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class MacOsToolRunningStatusChecker
implements ToolRunningStatusChecker {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final PlistResolver plistHelper;
    @NotNull
    private final NativeInteropMacOs nativeInterop;

    public MacOsToolRunningStatusChecker(@NotNull FileSystem fileSystem, @NotNull PlistResolver plistHelper, @NotNull NativeInteropMacOs nativeInterop) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)plistHelper, (String)"plistHelper");
        Intrinsics.checkNotNullParameter((Object)nativeInterop, (String)"nativeInterop");
        this.fileSystem = fileSystem;
        this.plistHelper = plistHelper;
        this.nativeInterop = nativeInterop;
    }

    public /* synthetic */ MacOsToolRunningStatusChecker(FileSystem fileSystem, PlistResolver plistResolver, NativeInteropMacOs nativeInteropMacOs, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            NativeInteropMacOs nativeInteropMacOs2 = NativeInteropMacOs.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)nativeInteropMacOs2, (String)"INSTANCE");
            nativeInteropMacOs = nativeInteropMacOs2;
        }
        this(fileSystem, plistResolver, nativeInteropMacOs);
    }

    @Override
    public boolean isRunning(@NotNull ToolInstance toolInstance) {
        Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
        return this.getRunningProcess(toolInstance) != null;
    }

    @Nullable
    public final RunningProcess getRunningProcess(@NotNull ToolInstance toolInstance) {
        Ref.ObjectRef result2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
            Path path2 = FileSystemExtKt.getMacAppUnderDirectory(this.fileSystem, toolInstance.getChannel().getInstallationDirectory());
            if (path2 == null) {
                return null;
            }
            Path applicationDir = path2;
            Path applicationPath = this.plistHelper.resolveExecutablePath(applicationDir);
            result2 = new Ref.ObjectRef();
            this.nativeInterop.listRunningApplications((arg_0, arg_1, arg_2) -> MacOsToolRunningStatusChecker.getRunningProcess$lambda$0(applicationPath, result2, applicationDir, arg_0, arg_1, arg_2));
            RunningProcess runningProcess = (RunningProcess)result2.element;
            if (runningProcess == null) break block1;
            RunningProcess processInfo = runningProcess;
            boolean bl = false;
            Logger.INSTANCE.debug("Detected running process " + processInfo.getPid() + " '" + processInfo.getName() + "' with directory '" + processInfo.getPath() + "'. Resolved application path is '" + applicationPath + "'");
        }
        return (RunningProcess)result2.element;
    }

    private static final boolean getRunningProcess$lambda$0(Path $applicationPath, Ref.ObjectRef $result, Path $applicationDir, String name2, String pathStr, int pid) {
        boolean bl;
        Intrinsics.checkNotNull((Object)pathStr);
        Path path2 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)pathStr, (boolean)false, (int)1, null);
        if (Intrinsics.areEqual((Object)path2, (Object)$applicationPath)) {
            Intrinsics.checkNotNull((Object)name2);
            $result.element = new RunningProcess(name2, pid, path2, true);
            bl = false;
        } else if (PathExtensionsKt.contains($applicationDir, path2)) {
            Intrinsics.checkNotNull((Object)name2);
            $result.element = new RunningProcess(name2, pid, path2, false);
            bl = $applicationPath != null;
        } else {
            bl = true;
        }
        return bl;
    }

    public static final class RunningProcess {
        @NotNull
        private final String name;
        private final int pid;
        @NotNull
        private final Path path;
        private final boolean isMainExecutable;

        public RunningProcess(@NotNull String name2, int pid, @NotNull Path path2, boolean isMainExecutable) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.name = name2;
            this.pid = pid;
            this.path = path2;
            this.isMainExecutable = isMainExecutable;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getPid() {
            return this.pid;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final boolean isMainExecutable() {
            return this.isMainExecutable;
        }

        @NotNull
        public String toString() {
            return "RunningProcess(name=" + this.name + ", pid=" + this.pid + ", path=" + this.path + ", isMainExecutable=" + this.isMainExecutable + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.pid);
            result2 = result2 * 31 + this.path.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isMainExecutable);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RunningProcess)) {
                return false;
            }
            RunningProcess runningProcess = (RunningProcess)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)runningProcess.name)) {
                return false;
            }
            if (this.pid != runningProcess.pid) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)runningProcess.path)) {
                return false;
            }
            return this.isMainExecutable == runningProcess.isMainExecutable;
        }
    }
}

