/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.recovery;

import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.recovery.InstallationProgressTracker;
import com.jetbrains.toolbox.tools.recovery.InstallationProgressTrackerImpl;
import com.jetbrains.toolbox.tools.recovery.RecoveryManager;
import com.jetbrains.toolbox.tools.recovery.State;
import com.jetbrains.toolbox.tools.recovery.StateFile;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.URandomKt;
import kotlin.text.UStringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;

public final class InstallationProgressTrackerFactory
implements InstallationProgressTracker.Factory {
    @NotNull
    private final Path directory;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final RecoveryManager recoveryManager;

    public InstallationProgressTrackerFactory(@NotNull Path directory, @NotNull FileSystem fileSystem, @NotNull RecoveryManager recoveryManager) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)recoveryManager, (String)"recoveryManager");
        this.directory = directory;
        this.fileSystem = fileSystem;
        this.recoveryManager = recoveryManager;
    }

    @Override
    @NotNull
    public InstallationProgressTracker installationStarted(@NotNull ToolBuild build2, @NotNull Path targetPath, @NotNull Path unpackedPath) {
        Object object;
        StateFile stateFilePath;
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Intrinsics.checkNotNullParameter((Object)unpackedPath, (String)"unpackedPath");
        StateFile existingFile = this.recoveryManager.getStateFile(targetPath);
        StateFile stateFile = existingFile;
        if (stateFile == null || (stateFile = stateFile.getPath()) == null) {
            stateFile = stateFilePath = this.findNewPath(targetPath.name());
        }
        if ((object = existingFile) == null || (object = ((StateFile)object).getState()) == null) {
            State.Phase phase = State.Phase.Init;
            object = new State(phase, targetPath, unpackedPath, null, build2);
        }
        Object state2 = object;
        return new InstallationProgressTrackerImpl(targetPath, (Path)stateFilePath, (State)state2, this.fileSystem);
    }

    private final Path findNewPath(String prefix) {
        String random;
        Path file;
        while (this.fileSystem.exists(file = this.directory.resolve(prefix + "-" + (random = UStringsKt.toString-JSWoG40((long)URandomKt.nextULong((Random)((Random)Random.Default)), (int)16)) + ".state.json"))) {
        }
        return file;
    }
}

