/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.provider;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.feed.IntelliJProductCode;
import com.jetbrains.toolbox.tools.image.ImageManager;
import com.jetbrains.toolbox.tools.model.IntelliJProductInfo;
import com.jetbrains.toolbox.tools.provider.DetectedProductInfoAndIcon;
import com.jetbrains.toolbox.tools.provider.DetectedToolInfoProvider;
import com.jetbrains.toolbox.tools.provider.HelpersKt;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntelliJDetectedToolInfoProvider
implements DetectedToolInfoProvider {
    @NotNull
    private final OS.Type os;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final ImageManager imageManager;

    public IntelliJDetectedToolInfoProvider(@NotNull OS.Type os, @NotNull FileSystem fileSystem, @NotNull ImageManager imageManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)imageManager, (String)"imageManager");
        this.os = os;
        this.fileSystem = fileSystem;
        this.imageManager = imageManager;
    }

    @Override
    @Nullable
    public Object provideFor(@NotNull Path pathToScan, @NotNull Continuation<? super DetectedProductInfoAndIcon> $completion) {
        IntelliJProductInfo intelliJProductInfo;
        Pair pair = WhenMappings.$EnumSwitchMapping$0[this.os.ordinal()] == 1 ? TuplesKt.to((Object)Path.Companion.get$default((Path.Companion)Path.Companion, (String)"Contents", (boolean)false, (int)1, null).resolve("Resources").resolve("product-info.json"), (Object)Path.Companion.get$default((Path.Companion)Path.Companion, (String)"Contents", (boolean)false, (int)1, null).resolve("Resources").resolve("build.txt")) : TuplesKt.to((Object)Path.Companion.get$default((Path.Companion)Path.Companion, (String)"product-info.json", (boolean)false, (int)1, null), (Object)Path.Companion.get$default((Path.Companion)Path.Companion, (String)"build.txt", (boolean)false, (int)1, null));
        Path productInfoPath = (Path)pair.component1();
        Path buildInfoPath = (Path)pair.component2();
        IntelliJProductInfo intelliJProductInfo2 = HelpersKt.readProductInfo(this.fileSystem, pathToScan.resolve(productInfoPath));
        if (intelliJProductInfo2 == null) {
            return null;
        }
        IntelliJProductInfo productInfo = intelliJProductInfo2;
        Pair<IntelliJProductCode, BuildNumber> buildTxtData = HelpersKt.readBuildTxt(this.fileSystem, pathToScan.resolve(buildInfoPath));
        if (buildTxtData != null) {
            String string = ((IntelliJProductCode)buildTxtData.getFirst()).unbox-impl();
            String string2 = ((BuildNumber)buildTxtData.getSecond()).unbox-impl();
            intelliJProductInfo = IntelliJProductInfo.copy-rcDmlbA$default(productInfo, null, null, string2, string, null, null, null, null, null, null, null, 2035, null);
        } else {
            intelliJProductInfo = productInfo;
        }
        IntelliJProductInfo productInfoUpdated = intelliJProductInfo;
        return new DetectedProductInfoAndIcon(productInfoUpdated, productInfoUpdated.getIcon-CQRfofY(), null);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Mac.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

