/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.provider;

import com.jetbrains.toolbox.common.FileExtension;
import com.jetbrains.toolbox.feed.AdditionalInstallAction;
import com.jetbrains.toolbox.feed.ApplicationMajorVersion;
import com.jetbrains.toolbox.feed.FileAssociationsSupport;
import com.jetbrains.toolbox.feed.RevisionInfo;
import com.jetbrains.toolbox.tools.WellKnownChannelId;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.ChannelBackupOptions;
import com.jetbrains.toolbox.tools.model.ChannelExtension;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ToolExtension;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.UnknownExtension;
import com.jetbrains.toolbox.tools.provider.ChannelFileHelper;
import com.jetbrains.toolbox.tools.provider.ChannelFileHelperImpl;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nChannelFileHelperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelFileHelperImpl.kt\ncom/jetbrains/toolbox/tools/provider/ChannelFileHelperImpl\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FileSystem.kt\nokio/FileSystem\n+ 5 Okio.kt\nokio/Okio__OkioKt\n+ 6 ChannelExtension.kt\ncom/jetbrains/toolbox/tools/model/ChannelExtensionKt\n+ 7 ToolExtension.kt\ncom/jetbrains/toolbox/tools/model/ToolExtensionKt\n*L\n1#1,127:1\n116#2,10:128\n116#2,10:141\n126#2:187\n116#2,10:188\n126#2:200\n116#2,11:201\n774#3:138\n865#3,2:139\n1869#3,2:198\n774#3:236\n865#3,2:237\n774#3:240\n865#3,2:241\n808#3,11:243\n1563#3:254\n1634#3,3:255\n808#3,11:258\n1563#3:269\n1634#3,3:270\n80#4:151\n165#4:152\n81#4:153\n82#4:158\n67#4:213\n68#4:218\n52#5,4:154\n60#5,10:159\n56#5,18:169\n66#5:212\n52#5,4:214\n60#5,10:219\n56#5,3:229\n71#5,3:232\n31#6:235\n40#7:239\n*S KotlinDebug\n*F\n+ 1 ChannelFileHelperImpl.kt\ncom/jetbrains/toolbox/tools/provider/ChannelFileHelperImpl\n*L\n59#1:128,10\n72#1:141,10\n72#1:187\n90#1:188,10\n90#1:200\n97#1:201,11\n70#1:138\n70#1:139,2\n94#1:198,2\n105#1:236\n105#1:237,2\n106#1:240\n106#1:241,2\n114#1:243,11\n116#1:254\n116#1:255,3\n118#1:258,11\n120#1:269\n120#1:270,3\n76#1:151\n76#1:152\n76#1:153\n76#1:158\n102#1:213\n102#1:218\n76#1:154,4\n76#1:159,10\n76#1:169,18\n102#1:212\n102#1:214,4\n102#1:219,10\n102#1:229,3\n102#1:232,3\n105#1:235\n106#1:239\n*E\n"})
public final class ChannelFileHelperImpl
implements ChannelFileHelper {
    @NotNull
    private final Path channelFileDirectory;
    @NotNull
    private final SerializersModule channelSerializersModule;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Mutex directoryLock;
    @NotNull
    private final Json parser;
    @NotNull
    private final String jsonExtension;

    public ChannelFileHelperImpl(@NotNull Path channelFileDirectory, @NotNull SerializersModule channelSerializersModule, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)channelFileDirectory, (String)"channelFileDirectory");
        Intrinsics.checkNotNullParameter((Object)channelSerializersModule, (String)"channelSerializersModule");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.channelFileDirectory = channelFileDirectory;
        this.channelSerializersModule = channelSerializersModule;
        this.fileSystem = fileSystem;
        this.directoryLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.parser = JsonKt.Json$default(null, arg_0 -> ChannelFileHelperImpl.parser$lambda$0(this, arg_0), (int)1, null);
        this.jsonExtension = FileExtension.constructor-impl("json");
    }

    private final boolean checkDirectory(Path path2) {
        if (!this.fileSystem.exists(path2)) {
            boolean bl;
            try {
                this.fileSystem.createDirectories(path2);
                bl = true;
            }
            catch (Exception e) {
                Logger.INSTANCE.error((Throwable)e, "Couldn't create directory " + path2);
                bl = false;
            }
            return bl;
        }
        if (!this.fileSystem.metadata(path2).isDirectory()) {
            Logger.INSTANCE.warn(path2 + " is not a directory");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object readAll(@NotNull Continuation<? super Map<ChannelId, ToolInstance>> $completion) {
        if (!($completion instanceof readAll.1)) ** GOTO lbl-1000
        var15_2 = $completion;
        if ((var15_2.label & -2147483648) != 0) {
            var15_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ChannelFileHelperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.readAll((Continuation<? super Map<ChannelId, ToolInstance>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.directoryLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var16_4) {
                    return var16_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-ChannelFileHelperImpl$readAll$2 = false;
                    if (!this.checkDirectory(this.channelFileDirectory)) {
                        var13_10 = MapsKt.emptyMap();
                        return var13_10;
                    }
                    channelFiles = this.listChannelFiles();
                    $this$readAll_u24lambda_u240_u240 = var7_12 = MapsKt.createMapBuilder();
                    $i$a$-buildMap-ChannelFileHelperImpl$readAll$2$1 = false;
                    for (Path channelFile : channelFiles) {
                        v1 = this.readFromFile(channelFile);
                        if (v1 == null) continue;
                        $this$readAll_u24lambda_u240_u240.put(ChannelId.box-impl(this.pathToChannelId-K2rgjsw(channelFile)), v1);
                    }
                    var12_17 = MapsKt.build((Map)var7_12);
                    return var12_17;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> listChannelFiles() {
        void $this$filterTo$iv$iv;
        List list2 = this.fileSystem.listOrNull(this.channelFileDirectory);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!FileExtension.matches-impl(this.jsonExtension, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object write-KCT93BI(@NotNull String $v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0, @NotNull ToolInstance toolInstance, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof write.1)) ** GOTO lbl-1000
        var29_4 = $completion;
        if ((var29_4.label & -2147483648) != 0) {
            var29_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ChannelFileHelperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.write-KCT93BI(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var30_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.directoryLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0;
                $continuation.L$1 = toolInstance;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var30_6) {
                    return var30_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                toolInstance = (ToolInstance)$continuation.L$1;
                $v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                try {
                    $i$a$-withLock$default-ChannelFileHelperImpl$write$2 = false;
                    if (ChannelId.equals-impl0($v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0, WellKnownChannelId.INSTANCE.getToolbox-5CZByfs())) {
                        var27_12 = Unit.INSTANCE;
                        return var27_12;
                    }
                    if (!this.checkDirectory(this.channelFileDirectory)) {
                        var26_13 = Unit.INSTANCE;
                        return var26_13;
                    }
                    path = this.channelIdToPath-CH08qv8($v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0);
                    var9_15 = this.fileSystem;
                    file$iv = path;
                    mustCreate$iv = false;
                    $i$f$-write = false;
                    $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, false));
                    $i$f$use = false;
                    thrown$iv$iv = null;
                    it$iv = (BufferedSink)$this$use$iv$iv;
                    $i$a$-use-FileSystem$write$1$iv = false;
                    $this$write_KCT93BI_u24lambda_u240_u240 = it$iv;
                    $i$a$--write$default-ChannelFileHelperImpl$write$2$1 = false;
                    try {
                        OkioStreamsKt.encodeToBufferedSink((Json)this.parser, (SerializationStrategy)((SerializationStrategy)ToolInstance.Companion.serializer()), (Object)toolInstance, (BufferedSink)$this$write_KCT93BI_u24lambda_u240_u240);
                    }
                    catch (Exception e) {
                        message = "Couldn't write to " + path;
                        if (e instanceof SerializationException) {
                            Logger.INSTANCE.warn((Throwable)e, message);
                        }
                        Logger.INSTANCE.error((Throwable)e, message);
                    }
                    var17_24 = Unit.INSTANCE;
                    try {
                        v1 = $this$use$iv$iv;
                        if (v1 != null) {
                            v1.close();
                        }
                        ** GOTO lbl96
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                    ** GOTO lbl96
                    catch (Throwable t$iv$iv) {
                        try {
                            thrown$iv$iv = t$iv$iv;
                            var17_24 = null;
                        }
                        catch (Throwable var22_32) {
                            throw var22_32;
                        }
                        finally {
                            try {
                                v2 = $this$use$iv$iv;
                                if (v2 != null) {
                                    v2.close();
                                }
                            }
                            catch (Throwable t$iv$iv) {
                                if (thrown$iv$iv != null) ** GOTO lbl94
                                thrown$iv$iv = t$iv$iv;
                                ** GOTO lbl95
lbl94:
                                // 1 sources

                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
                            }
lbl95:
                            // 3 sources

                        }
                    }
lbl96:
                    // 3 sources

                    result$iv$iv = var17_24;
                    v3 = thrown$iv$iv;
                    if (v3 != null) {
                        throw v3;
                    }
                    var24_34 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var24_34;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object retain(@NotNull Collection<ChannelId> channelIds, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof retain.1)) ** GOTO lbl-1000
        var19_3 = $completion;
        if ((var19_3.label & -2147483648) != 0) {
            var19_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ChannelFileHelperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retain(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.directoryLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = channelIds;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var20_5) {
                    return var20_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                channelIds = (Collection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                try {
                    $i$a$-withLock$default-ChannelFileHelperImpl$retain$2 = false;
                    if (!this.checkDirectory(this.channelFileDirectory)) {
                        var17_10 = Unit.INSTANCE;
                        return var17_10;
                    }
                    channelFiles = this.listChannelFiles();
                    idsToRetain = CollectionsKt.toSet((Iterable)channelIds);
                    $this$forEach$iv = channelFiles;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (Path)element$iv;
                        $i$a$-forEach-ChannelFileHelperImpl$retain$2$1 = false;
                        if (idsToRetain.contains(ChannelId.box-impl(this.pathToChannelId-K2rgjsw(it)))) continue;
                        this.fileSystem.delete(it);
                    }
                    var15_19 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var15_19;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object remove-R5oYZt4(@NotNull String $v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof remove.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ChannelFileHelperImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.remove-R5oYZt4(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.directoryLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                $v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                try {
                    $i$a$-withLock$default-ChannelFileHelperImpl$remove$2 = false;
                    this.fileSystem.delete(this.channelIdToPath-CH08qv8($v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0));
                    var7_11 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var7_11;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ToolInstance readFromFile(Path path2) {
        try {
            void $this$filterTo$iv$iv$iv;
            void $this$filterTo$iv$iv$iv2;
            Iterable $this$filter$iv$iv;
            InstalledTool $this$withoutExtension$iv;
            ToolInstance toolInstance2;
            Throwable thrown$iv$iv;
            Channel this_$iv;
            block20: {
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = path2;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$readFromFile_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    toolInstance2 = (ToolInstance)OkioStreamsKt.decodeFromBufferedSource((Json)this.parser, (DeserializationStrategy)((DeserializationStrategy)ToolInstance.Companion.serializer()), (BufferedSource)$this$readFromFile_u24lambda_u240);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        toolInstance2 = null;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block21: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block21;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            ToolInstance result$iv$iv = toolInstance2;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            ToolInstance toolInstance3 = result$iv$iv;
            this.reportUnknownExtensions(toolInstance3);
            this_$iv = toolInstance3.getChannel();
            ToolInstance toolInstance4 = toolInstance3;
            boolean $i$f$withoutExtension = false;
            Iterable bl = ((Channel)((Object)$this$withoutExtension$iv)).getExtensions();
            List list2 = null;
            boolean bl4 = false;
            AdditionalInstallAction additionalInstallAction = null;
            boolean bl5 = false;
            toolInstance2 = null;
            boolean bl6 = false;
            Boolean bl7 = null;
            Path path3 = null;
            List list3 = null;
            Path path4 = $this$withoutExtension$iv;
            boolean $i$f$filter = false;
            String string = $this$filter$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv2) {
                ChannelExtension it$iv = (ChannelExtension)element$iv$iv$iv;
                boolean bl8 = false;
                if (!(!(it$iv instanceof UnknownExtension))) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            List list4 = (List)destination$iv$iv$iv;
            $this$withoutExtension$iv = toolInstance3.getTool();
            Channel channel = Channel.copy$default((Channel)path4, list3, path3, bl7, bl6, (ChannelBackupOptions)((Object)toolInstance2), bl5, additionalInstallAction, bl4, list2, list4, null, false, 3583, null);
            $i$f$withoutExtension = false;
            $this$filter$iv$iv = $this$withoutExtension$iv.getExtensions();
            list2 = null;
            AdditionalInstallAction additionalInstallAction2 = null;
            additionalInstallAction = null;
            FileAssociationsSupport fileAssociationsSupport = null;
            boolean bl9 = false;
            Path path5 = null;
            bl7 = null;
            path3 = null;
            list3 = null;
            path4 = null;
            RevisionInfo revisionInfo = null;
            string = null;
            String string2 = null;
            String string3 = null;
            Iterator iterator2 = null;
            ApplicationMajorVersion applicationMajorVersion = null;
            String string4 = null;
            String string5 = null;
            list4 = null;
            String string6 = null;
            String string7 = null;
            InstalledTool installedTool2 = $this$withoutExtension$iv;
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv$iv;
            Collection destination$iv$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            Iterator iterator3 = $this$filterTo$iv$iv$iv.iterator();
            while (true) {
                if (!iterator3.hasNext()) {
                    List list5 = (List)destination$iv$iv$iv2;
                    InstalledTool installedTool3 = InstalledTool.copy-B5SJSoI$default(installedTool2, string7, string6, (String)((Object)list4), string5, string4, applicationMajorVersion, iterator2, string3, string2, string, revisionInfo, path4, list3, path3, bl7, path5, bl9, fileAssociationsSupport, additionalInstallAction, additionalInstallAction2, list2, list5, 0x1FFFFF, null);
                    return toolInstance4.copy(channel, installedTool3);
                }
                Object element$iv$iv$iv = iterator3.next();
                ToolExtension it$iv = (ToolExtension)element$iv$iv$iv;
                boolean bl10 = false;
                if (!(!(it$iv instanceof UnknownExtension))) continue;
                destination$iv$iv$iv2.add(element$iv$iv$iv);
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Couldn't parse " + path2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportUnknownExtensions(ToolInstance toolInstance) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable<void> iterable;
        Logger logger;
        int n;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv = toolInstance.getChannel().getExtensions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable2 = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof UnknownExtension)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unknownChannelExtensions = (List)destination$iv$iv;
        if (!((Collection)unknownChannelExtensions).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$filterIsInstance$iv = unknownChannelExtensions;
            n = unknownChannelExtensions.size();
            logger = Logger.INSTANCE;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonObject jsonObject = ((UnknownExtension)item$iv$iv).unbox-impl();
                iterable = destination$iv$iv;
                boolean bl = false;
                iterable.add(it);
            }
            iterable = (List)destination$iv$iv;
            logger.warn("Removed " + n + " unknown channel extension(s): " + (List)iterable);
        }
        Iterable $this$filterIsInstance$iv2 = toolInstance.getTool().getExtensions();
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UnknownExtension)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List unknownToolExtensions = (List)destination$iv$iv2;
        if (!((Collection)unknownToolExtensions).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$filterIsInstance$iv2 = unknownToolExtensions;
            n = unknownToolExtensions.size();
            logger = Logger.INSTANCE;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonObject bl = ((UnknownExtension)item$iv$iv).unbox-impl();
                iterable = destination$iv$iv2;
                boolean bl2 = false;
                iterable.add(it);
            }
            iterable = (List)destination$iv$iv2;
            logger.warn("Removed " + n + " unknown tool extension(s): " + iterable);
        }
    }

    private final Path channelIdToPath-CH08qv8(String string) {
        return this.channelFileDirectory.resolve(FileExtension.appendTo-impl(this.jsonExtension, string));
    }

    private final String pathToChannelId-K2rgjsw(Path path2) {
        return ChannelId.constructor-impl(FileExtension.removeFrom-impl(this.jsonExtension, path2.name()));
    }

    private static final Unit parser$lambda$0(ChannelFileHelperImpl this$0, JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(false);
        $this$Json.setCoerceInputValues(true);
        $this$Json.setExplicitNulls(false);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        $this$Json.setSerializersModule(this$0.channelSerializersModule);
        return Unit.INSTANCE;
    }
}

