/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.process.workers;

import com.jetbrains.toolbox.interop.Pid;
import com.jetbrains.toolbox.interop.RunAsMode;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.tools.ExtensionsKt;
import com.jetbrains.toolbox.tools.ToolProcessStateWorker;
import com.jetbrains.toolbox.tools.launcher.ProcessLauncher;
import com.jetbrains.toolbox.tools.launcher.ProcessParameters;
import com.jetbrains.toolbox.tools.launcher.ToolParameters;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ToolProcessEvent;
import com.jetbrains.toolbox.tools.model.ToolProcessState;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nLaunchingStateWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchingStateWorker.kt\ncom/jetbrains/toolbox/tools/process/workers/LaunchingStateWorker\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,58:1\n375#2:59\n*S KotlinDebug\n*F\n+ 1 LaunchingStateWorker.kt\ncom/jetbrains/toolbox/tools/process/workers/LaunchingStateWorker\n*L\n50#1:59\n*E\n"})
public final class LaunchingStateWorker
implements ToolProcessStateWorker<ToolProcessState.Launching> {
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final ProcessLauncher processLauncher;

    public LaunchingStateWorker(@NotNull ToolManager toolManager, @NotNull ProcessLauncher processLauncher) {
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter((Object)processLauncher, (String)"processLauncher");
        this.toolManager = toolManager;
        this.processLauncher = processLauncher;
    }

    @Override
    @NotNull
    public KClass<ToolProcessState.Launching> getState() {
        return Reflection.getOrCreateKotlinClass(ToolProcessState.Launching.class);
    }

    @Override
    @Nullable
    public Object handle(@NotNull ToolProcessState.Launching state2, @NotNull Continuation<? super ToolProcessEvent> $completion) {
        List<String> list2;
        RunAsMode asAdmin;
        String channelId = state2.getChannelId-5CZByfs();
        Logger.INSTANCE.debug("Firing a process for " + ChannelId.toString-impl(channelId));
        Object v = ((Map)this.toolManager.getModel().getValue()).get(ChannelId.box-impl(channelId));
        ChannelState.HoldsInstalledTool holdsInstalledTool = v instanceof ChannelState.HoldsInstalledTool ? (ChannelState.HoldsInstalledTool)v : null;
        if (holdsInstalledTool == null) {
            LaunchingStateWorker $this$handle_u24lambda_u240 = this;
            boolean bl = false;
            Logger.INSTANCE.warn("Channel " + ChannelId.toString-impl(channelId) + " not found");
            return new ToolProcessEvent.Failure(new IllegalStateException("Channel " + ChannelId.toString-impl(channelId) + " not found"));
        }
        ChannelState.HoldsInstalledTool channelState2 = holdsInstalledTool;
        InstalledTool $this$handle_u24lambda_u240 = channelState2.getTool();
        InstalledTool installedTool2 = $this$handle_u24lambda_u240 instanceof InstalledTool ? $this$handle_u24lambda_u240 : null;
        if (installedTool2 == null) {
            LaunchingStateWorker $this$handle_u24lambda_u241 = this;
            boolean bl = false;
            Logger.INSTANCE.warn("Channel " + ChannelId.toString-impl(channelId) + " is in invalid state");
            return new ToolProcessEvent.Failure(new IllegalStateException("Channel " + ChannelId.toString-impl(channelId) + " is in invalid state"));
        }
        InstalledTool tool = installedTool2;
        RunAsMode runAsMode = state2.getRunAs();
        if (runAsMode == null) {
            runAsMode = asAdmin = channelState2.getChannel().getRunAsAdministrator() ? RunAsMode.RunAsAdministrator : RunAsMode.RunAsUser;
        }
        if ((list2 = state2.getLaunchArguments()) == null) {
            list2 = ExtensionsKt.getLaunchArguments(channelState2);
        }
        List arguments2 = CollectionsKt.plus((Collection)list2, (Iterable)CollectionsKt.listOfNotNull((Object)state2.getProjectPath()));
        ToolParameters toolParameters = state2.getToolParametersOverride();
        if (toolParameters == null) {
            toolParameters = ToolParameters.Companion.of(tool, channelState2.getChannel());
        }
        ToolParameters toolParameters2 = toolParameters;
        ProcessParameters processParameters = new ProcessParameters(arguments2, false, false, null, asAdmin, null, null, 110, null);
        try {
            ProcessHandle processHandle = this.processLauncher.launch(toolParameters2, processParameters);
            if (processHandle == null) {
                String string = "no process was fired";
                throw new IllegalStateException(string.toString());
            }
            ProcessHandle handle2 = processHandle;
            long pid = Pid.constructor-impl(handle2.pid());
            return new ToolProcessEvent.Attach(handle2, pid, channelId, null);
        }
        catch (Exception e) {
            boolean $i$f$currentCoroutineContext = false;
            JobKt.ensureActive((CoroutineContext)$completion.getContext());
            Logger.INSTANCE.warn((Throwable)e, "Failed to launch process for " + ChannelId.toString-impl(channelId));
            return new ToolProcessEvent.Failure(e);
        }
    }
}

