/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.model.licensing;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.feed.RemoteFeedItemLicensing;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.licensing.JBAFallbackLicenseInfo$;
import com.jetbrains.toolbox.tools.model.licensing.LicenseInfo;
import com.jetbrains.toolbox.tools.model.licensing.LicenseType;
import com.jetbrains.toolbox.tools.model.licensing.ProductId;
import com.jetbrains.toolbox.tools.model.licensing.SalesCode;
import com.jetbrains.toolbox.tools.model.licensing.SalesCode$;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.serializers.LocalDateIso8601Serializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Serializable
@SourceDebugExtension(value={"SMAP\nLicenseInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseInfo.kt\ncom/jetbrains/toolbox/tools/model/licensing/JBAFallbackLicenseInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public final class JBAFallbackLicenseInfo
implements LicenseInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final boolean active;
    @NotNull
    private final String licenseId;
    @NotNull
    private final String salesCode;
    @NotNull
    private final Map<SalesCode, LocalDate> fallbackDates;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    private JBAFallbackLicenseInfo(String name2, boolean active2, String licenseId, String salesCode, Map<SalesCode, LocalDate> fallbackDates) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)licenseId, (String)"licenseId");
        Intrinsics.checkNotNullParameter((Object)salesCode, (String)"salesCode");
        Intrinsics.checkNotNullParameter(fallbackDates, (String)"fallbackDates");
        this.name = name2;
        this.active = active2;
        this.licenseId = licenseId;
        this.salesCode = salesCode;
        this.fallbackDates = fallbackDates;
    }

    public /* synthetic */ JBAFallbackLicenseInfo(String string, boolean bl, String string2, String string3, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(string, bl, string2, string3, map2, null);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    @NotNull
    public String getLicenseId() {
        return this.licenseId;
    }

    @NotNull
    public String getSalesCode-Ixla6tU() {
        return this.salesCode;
    }

    @NotNull
    public final Map<SalesCode, LocalDate> getFallbackDates() {
        return this.fallbackDates;
    }

    @Override
    @NotNull
    public LocalizableString getDisplayName() {
        return LocalizableStringExKt.notr(this.name);
    }

    @Override
    @NotNull
    public List<ProductId> getProducts() {
        return CollectionsKt.toList((Iterable)this.fallbackDates.keySet());
    }

    @Override
    @NotNull
    public Instant getValidUntil() {
        return Instant.Companion.getDISTANT_FUTURE();
    }

    @Override
    @NotNull
    public LicenseType getType() {
        return LicenseType.FALLBACK;
    }

    private final boolean validFor-WiCNwPc(String string, LocalDate majorReleaseDate) {
        LocalDate localDate = this.fallbackDates.get(SalesCode.box-impl(string));
        if (localDate == null) {
            return false;
        }
        LocalDate fallbackDate = localDate;
        return majorReleaseDate.compareTo(fallbackDate) <= 0;
    }

    @Override
    public boolean validFor(@NotNull InstalledTool tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        String string = tool.getSalesCode();
        if (string == null) {
            return false;
        }
        String it = string;
        boolean bl = false;
        String salesCode = SalesCode.constructor-impl(it);
        LocalDate localDate = tool.getMajorVersionReleaseDate();
        if (localDate == null) {
            return false;
        }
        LocalDate majorReleaseDate = localDate;
        return this.validFor-WiCNwPc(salesCode, majorReleaseDate);
    }

    @Override
    public boolean validFor(@NotNull ToolBuild toolBuild2) {
        Intrinsics.checkNotNullParameter((Object)toolBuild2, (String)"toolBuild");
        RemoteFeedItemLicensing remoteFeedItemLicensing = toolBuild2.getVersion().getLicensing();
        if (remoteFeedItemLicensing == null) {
            return false;
        }
        RemoteFeedItemLicensing licensing = remoteFeedItemLicensing;
        String salesCode = SalesCode.constructor-impl(licensing.getSalesCode());
        LocalDate localDate = licensing.getReleaseDate();
        if (localDate == null) {
            return false;
        }
        LocalDate majorReleaseDate = localDate;
        return this.validFor-WiCNwPc(salesCode, majorReleaseDate);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final boolean component2() {
        return this.active;
    }

    @NotNull
    public final String component3() {
        return this.licenseId;
    }

    @NotNull
    public final String component4-Ixla6tU() {
        return this.salesCode;
    }

    @NotNull
    public final Map<SalesCode, LocalDate> component5() {
        return this.fallbackDates;
    }

    @NotNull
    public final JBAFallbackLicenseInfo copy-iMWiK9A(@NotNull String name2, boolean active2, @NotNull String licenseId, @NotNull String string, @NotNull Map<SalesCode, LocalDate> fallbackDates) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)licenseId, (String)"licenseId");
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-jetbrains-toolbox-tools-model-licensing-SalesCode$-salesCode$0");
        Intrinsics.checkNotNullParameter(fallbackDates, (String)"fallbackDates");
        return new JBAFallbackLicenseInfo(name2, active2, licenseId, string, fallbackDates, null);
    }

    public static /* synthetic */ JBAFallbackLicenseInfo copy-iMWiK9A$default(JBAFallbackLicenseInfo jBAFallbackLicenseInfo, String string, boolean bl, String string2, String string3, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            string = jBAFallbackLicenseInfo.name;
        }
        if ((n & 2) != 0) {
            bl = jBAFallbackLicenseInfo.active;
        }
        if ((n & 4) != 0) {
            string2 = jBAFallbackLicenseInfo.licenseId;
        }
        if ((n & 8) != 0) {
            string3 = jBAFallbackLicenseInfo.salesCode;
        }
        if ((n & 0x10) != 0) {
            map2 = jBAFallbackLicenseInfo.fallbackDates;
        }
        return jBAFallbackLicenseInfo.copy-iMWiK9A(string, bl, string2, string3, map2);
    }

    @NotNull
    public String toString() {
        return "JBAFallbackLicenseInfo(name=" + this.name + ", active=" + this.active + ", licenseId=" + this.licenseId + ", salesCode=" + SalesCode.toString-impl(this.salesCode) + ", fallbackDates=" + this.fallbackDates + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.active);
        result2 = result2 * 31 + this.licenseId.hashCode();
        result2 = result2 * 31 + SalesCode.hashCode-impl(this.salesCode);
        result2 = result2 * 31 + ((Object)this.fallbackDates).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JBAFallbackLicenseInfo)) {
            return false;
        }
        JBAFallbackLicenseInfo jBAFallbackLicenseInfo = (JBAFallbackLicenseInfo)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)jBAFallbackLicenseInfo.name)) {
            return false;
        }
        if (this.active != jBAFallbackLicenseInfo.active) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.licenseId, (Object)jBAFallbackLicenseInfo.licenseId)) {
            return false;
        }
        if (!SalesCode.equals-impl0(this.salesCode, jBAFallbackLicenseInfo.salesCode)) {
            return false;
        }
        return Intrinsics.areEqual(this.fallbackDates, jBAFallbackLicenseInfo.fallbackDates);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$tools_api(JBAFallbackLicenseInfo self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output2.encodeStringElement(serialDesc, 0, self.name);
        output2.encodeBooleanElement(serialDesc, 1, self.getActive());
        output2.encodeStringElement(serialDesc, 2, self.getLicenseId());
        output2.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)SalesCode$.serializer.INSTANCE, (Object)SalesCode.box-impl(self.getSalesCode-Ixla6tU()));
        if (output2.shouldEncodeElementDefault(serialDesc, 4) ? true : !Intrinsics.areEqual(self.fallbackDates, (Object)MapsKt.emptyMap())) {
            output2.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)lazyArray[4].getValue(), self.fallbackDates);
        }
    }

    private /* synthetic */ JBAFallbackLicenseInfo(int seen0, String name2, boolean active2, String licenseId, String salesCode, Map fallbackDates, SerializationConstructorMarker serializationConstructorMarker) {
        if (15 != (0xF & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)15, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.name = name2;
        this.active = active2;
        this.licenseId = licenseId;
        this.salesCode = salesCode;
        this.fallbackDates = (seen0 & 0x10) == 0 ? MapsKt.emptyMap() : fallbackDates;
    }

    public /* synthetic */ JBAFallbackLicenseInfo(String name2, boolean active2, String licenseId, String salesCode, Map fallbackDates, DefaultConstructorMarker $constructor_marker) {
        this(name2, active2, licenseId, salesCode, fallbackDates);
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    public /* synthetic */ JBAFallbackLicenseInfo(int seen0, String name2, boolean active2, String licenseId, String salesCode, Map fallbackDates, SerializationConstructorMarker serializationConstructorMarker, DefaultConstructorMarker $constructor_marker) {
        this(seen0, name2, active2, licenseId, salesCode, fallbackDates, serializationConstructorMarker);
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)SalesCode$.serializer.INSTANCE, (KSerializer)LocalDateIso8601Serializer.INSTANCE))};
        $childSerializers = lazyArray;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<JBAFallbackLicenseInfo> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

