/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.launcher;

import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.tools.launcher.ProcessLauncher;
import com.jetbrains.toolbox.tools.launcher.ProcessParameters;
import com.jetbrains.toolbox.tools.launcher.ToolParameters;
import java.io.File;
import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

@VisibleForTesting
public final class LinuxProcessLauncher
extends ProcessLauncher {
    @NotNull
    private final ProcessRunner processes;
    @NotNull
    private final FileSystem fileSystem;

    public LinuxProcessLauncher(@NotNull ProcessRunner processes, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.processes = processes;
        this.fileSystem = fileSystem;
    }

    @Override
    @NotNull
    public ProcessRunner getProcesses() {
        return this.processes;
    }

    @Override
    @Nullable
    public ProcessHandle launch(@NotNull ToolParameters toolParameters, @NotNull ProcessParameters processParameters) {
        boolean canExecuteSetsid;
        Intrinsics.checkNotNullParameter((Object)toolParameters, (String)"toolParameters");
        Intrinsics.checkNotNullParameter((Object)processParameters, (String)"processParameters");
        ThreadGuardKt.assertNotMainThread("java.io.File.canonicalPath");
        if (toolParameters.getCommand() == null) {
            Logger.INSTANCE.warn("Could not launch tool, command is not specified");
            return null;
        }
        Path path2 = toolParameters.getCommand();
        if (path2 == null) {
            return null;
        }
        Path command2 = path2;
        File file = new File(command2.toFile().getCanonicalPath());
        File setsid = new File("/usr/bin/setsid");
        boolean bl = canExecuteSetsid = !FileSystemExtKt.isSystem(this.fileSystem) || FileSystemExtKt.isExecutable(this.fileSystem, Path.Companion.get$default((Path.Companion)Path.Companion, (File)setsid, (boolean)false, (int)1, null));
        if (!canExecuteSetsid) {
            Logger.INSTANCE.warn(setsid + " executable is not found");
        }
        return processParameters.getWait() || !toolParameters.getAllowsSetsid() || !canExecuteSetsid ? ProcessLauncher.executeProcess$default(this, file, ProcessParameters.copy$default(processParameters, CollectionsKt.plus((Collection)toolParameters.getArguments(), (Iterable)processParameters.getArguments()), false, false, null, null, null, null, 126, null), null, 4, null) : this.executeProcess(setsid, ProcessParameters.copy$default(processParameters, CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)file.toString()), (Iterable)toolParameters.getArguments()), (Iterable)processParameters.getArguments()), false, false, null, null, null, null, 126, null), file.getParentFile());
    }
}

