/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.tools.UninstallResult;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class UninstallResultKt {
    @NotNull
    public static final LocalizableString toLocalizableString(@NotNull UninstallResult $this$toLocalizableString, @NotNull String toolName) {
        LocalizableString localizableString;
        Intrinsics.checkNotNullParameter((Object)$this$toLocalizableString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        UninstallResult uninstallResult = $this$toLocalizableString;
        if (uninstallResult instanceof UninstallResult.Blocked) {
            localizableString = LocalizableStringExKt.trl("Tool files are in use");
        } else if (Intrinsics.areEqual((Object)uninstallResult, (Object)UninstallResult.NotSupported.INSTANCE)) {
            localizableString = LocalizableStringExKt.trl("Unsupported");
        } else if (uninstallResult instanceof UninstallResult.Running) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)toolName)};
            localizableString = LocalizableStringExKt.trl("{{toolName}} is running", pairArray);
        } else if (Intrinsics.areEqual((Object)uninstallResult, (Object)UninstallResult.Success.INSTANCE)) {
            localizableString = LocalizableStringExKt.trl("");
        } else if (uninstallResult instanceof UninstallResult.UninstallerProcessFailure) {
            localizableString = LocalizableStringExKt.trl("Uninstaller failed");
        } else if (Intrinsics.areEqual((Object)uninstallResult, (Object)UninstallResult.UninstallerUnavailable.INSTANCE)) {
            localizableString = LocalizableStringExKt.trl("Uninstaller unavailable");
        } else if (Intrinsics.areEqual((Object)uninstallResult, (Object)UninstallResult.UninstallerStarted.INSTANCE)) {
            localizableString = LocalizableStringExKt.trl("Uninstaller started");
        } else if (Intrinsics.areEqual((Object)uninstallResult, (Object)UninstallResult.DirectoryIsNotWritable.INSTANCE)) {
            localizableString = LocalizableStringExKt.trl("The specified directory is not writable");
        } else if (uninstallResult instanceof UninstallResult.UnknownFailure) {
            localizableString = LocalizableStringExKt.notr(((UninstallResult.UnknownFailure)$this$toLocalizableString).getReason());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return localizableString;
    }

    @NotNull
    public static final String localize(@NotNull UninstallResult $this$localize, @NotNull String toolName, @NotNull I18n i18n) {
        Intrinsics.checkNotNullParameter((Object)$this$localize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        return LocalizableStringExKt.localize(UninstallResultKt.toLocalizableString($this$localize, toolName), i18n);
    }
}

