/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.jetbrains.toolbox.tools.ProjectStatus;
import com.jetbrains.toolbox.tools.ToolStatus;
import com.jetbrains.toolbox.tools.model.ToolProcessState;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class ToolProcessManagerKt {
    @NotNull
    public static final ToolStatus toToolStatus(@NotNull ToolProcessState $this$toToolStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$toToolStatus, (String)"<this>");
        ToolProcessState toolProcessState = $this$toToolStatus;
        return toolProcessState instanceof ToolProcessState.ToolError ? ToolStatus.ERROR : (toolProcessState instanceof ToolProcessState.RunningProcess ? ToolStatus.RUNNING : (toolProcessState instanceof ToolProcessState.Exiting || toolProcessState instanceof ToolProcessState.Terminated ? ToolStatus.STOPPED : ToolStatus.UNKNOWN));
    }

    @NotNull
    public static final ProjectStatus toProjectStatus(@NotNull ToolProcessState $this$toProjectStatus) {
        ProjectStatus projectStatus;
        Intrinsics.checkNotNullParameter((Object)$this$toProjectStatus, (String)"<this>");
        ToolProcessState toolProcessState = $this$toProjectStatus;
        if (Intrinsics.areEqual((Object)toolProcessState, (Object)ToolProcessState.NoProcess.INSTANCE)) {
            projectStatus = ProjectStatus.CLOSED;
        } else if (toolProcessState instanceof ToolProcessState.Launching) {
            projectStatus = ProjectStatus.PREPARING;
        } else if (toolProcessState instanceof ToolProcessState.Discovering) {
            projectStatus = ProjectStatus.UNKNOWN;
        } else if (toolProcessState instanceof ToolProcessState.DiscoveringViaStatus) {
            projectStatus = ProjectStatus.UNKNOWN;
        } else if (toolProcessState instanceof ToolProcessState.ToolError) {
            projectStatus = ProjectStatus.ERROR;
        } else if (toolProcessState instanceof ToolProcessState.RunningProcess) {
            projectStatus = ProjectStatus.READY;
        } else if (toolProcessState instanceof ToolProcessState.Exiting) {
            projectStatus = ProjectStatus.PREPARING;
        } else if (toolProcessState instanceof ToolProcessState.Terminated) {
            projectStatus = ProjectStatus.CLOSED;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return projectStatus;
    }
}

