/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.OsIntegration;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolRefreshHandler;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SymlinkInstallationPathHandler
implements OsIntegration,
ToolRefreshHandler {
    @NotNull
    private final FileSystem fileSystem;

    public SymlinkInstallationPathHandler(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        Path installationPath = toolInstance.getChannel().getInstallationDirectory();
        Path canonicalPath = FileSystemExtKt.canonicalizeOrNull(this.fileSystem, installationPath);
        if (canonicalPath == null || Intrinsics.areEqual((Object)canonicalPath, (Object)installationPath)) {
            return toolInstance;
        }
        return ToolInstance.copy$default(toolInstance, Channel.copy$default(toolInstance.getChannel(), null, null, canonicalPath, false, null, false, null, false, null, null, null, false, 4091, null), null, 2, null);
    }
}

