/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.theme;

import com.jetbrains.toolbox.desktop.SystemTheme;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.settings.Theme;
import com.jetbrains.toolbox.settings.UISettings;
import com.jetbrains.toolbox.theme.ThemeManager;
import kotlin.KotlinNothingValueException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nThemeManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeManagerImpl.kt\ncom/jetbrains/toolbox/theme/ThemeManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class ThemeManagerImpl
implements ThemeManager {
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableStateFlow<Boolean> _isDarkTheme;
    @Nullable
    private Job systemThemeJob;

    public ThemeManagerImpl(@NotNull SettingsManager settingsManager, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.settingsManager = settingsManager;
        this.coroutineScope = coroutineScope;
        this._isDarkTheme = StateFlowKt.MutableStateFlow((Object)false);
        this.settingsManager.updateSettings((Function1<? super SelfSettings, SelfSettings>)((Function1)ThemeManagerImpl::_init_$lambda$0));
        this._isDarkTheme.setValue((Object)(switch (WhenMappings.$EnumSwitchMapping$0[((SelfSettings)this.settingsManager.getSettings().getValue()).getUi().getTheme().ordinal()]) {
            case 1 -> {
                Boolean v0 = SystemTheme.INSTANCE.getCurrentIsDark();
                if (v0 != null) {
                    yield v0;
                }
                yield true;
            }
            case 2 -> true;
            case 3 -> false;
            default -> throw new NoWhenBranchMatchedException();
        }));
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ThemeManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.settingsManager.getSettings().collect(new FlowCollector(){

                            public final Object emit(SelfSettings settings2, Continuation<? super Unit> $completion) {
                                Theme theme = settings2.getUi().getTheme();
                                if (WhenMappings.$EnumSwitchMapping$0[theme.ordinal()] == 1) {
                                    if (this$0.systemThemeJob == null && SystemTheme.INSTANCE.isSupported()) {
                                        this$0.startSystemThemeMonitoring();
                                    }
                                } else {
                                    this$0.stopSystemThemeMonitoring();
                                    this$0._isDarkTheme.setValue((Object)Boxing.boxBoolean((Theme.Dark == theme ? 1 : 0) != 0));
                                }
                                return Unit.INSTANCE;
                            }

                            public static final class WhenMappings {
                                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                                static {
                                    int[] nArray = new int[Theme.values().length];
                                    try {
                                        nArray[Theme.System.ordinal()] = 1;
                                    }
                                    catch (NoSuchFieldError noSuchFieldError) {
                                        // empty catch block
                                    }
                                    $EnumSwitchMapping$0 = nArray;
                                }
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @NotNull
    public StateFlow<Boolean> isDarkTheme() {
        return FlowKt.asStateFlow(this._isDarkTheme);
    }

    private final void startSystemThemeMonitoring() {
        Job job2 = this.systemThemeJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.systemThemeJob = FlowKt.launchIn((Flow)FlowKt.catch((Flow)FlowKt.onEach(SystemTheme.INSTANCE.isDark(), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ boolean Z$0;
            final /* synthetic */ ThemeManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                boolean bl = this.Z$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (((SelfSettings)ThemeManagerImpl.access$getSettingsManager$p(this.this$0).getSettings().getValue()).getUi().getTheme() == Theme.System) {
                            void isDark;
                            ThemeManagerImpl.access$get_isDarkTheme$p(this.this$0).setValue((Object)Boxing.boxBoolean((isDark != false ? 1 : 0) != 0));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.Z$0 = (Boolean)value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (Function3)((Function3)new Function3<FlowCollector<? super Boolean>, Throwable, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ThemeManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Throwable throwable = (Throwable)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void e;
                        ResultKt.throwOnFailure((Object)$result);
                        Logger.INSTANCE.warn((Throwable)e, "Error in system theme monitoring: " + e.getMessage());
                        ThemeManagerImpl.access$get_isDarkTheme$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)true));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(FlowCollector<? super Boolean> p1, Throwable p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.coroutineScope);
    }

    private final void stopSystemThemeMonitoring() {
        Job job2 = this.systemThemeJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.systemThemeJob = null;
    }

    private static final SelfSettings _init_$lambda$0(SelfSettings settings2) {
        Theme theme;
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Theme it = theme = settings2.getUi().getTheme();
        boolean bl = false;
        Theme theme2 = it != Theme.System || SystemTheme.INSTANCE.isSupported() ? theme : null;
        if (theme2 == null) {
            theme2 = Theme.Dark;
        }
        Theme allowedTheme = theme2;
        return SelfSettings.copy$default(settings2, null, null, false, false, null, 0, null, null, null, null, null, null, UISettings.copy$default(settings2.getUi(), null, allowedTheme, null, null, 0.0f, 29, null), null, null, null, null, 126975, null);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Theme.values().length];
            try {
                nArray[Theme.System.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Theme.Dark.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Theme.Light.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

