/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tbe.test.access;

import com.jetbrains.toolbox.accounts.JetBrainsAccountSecureToken;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.common.io.OkHttpBuilderExtensionsKt;
import com.jetbrains.toolbox.tbe.test.access.AuthContext;
import com.jetbrains.toolbox.tbe.test.access.AuthRequest;
import com.jetbrains.toolbox.tbe.test.access.TestAuthenticationService;
import java.io.Closeable;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.uuid.Uuid;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nTestAuthenticationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestAuthenticationService.kt\ncom/jetbrains/toolbox/tbe/test/access/TestAuthenticationService\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n29#2,3:302\n1#3:305\n*S KotlinDebug\n*F\n+ 1 TestAuthenticationService.kt\ncom/jetbrains/toolbox/tbe/test/access/TestAuthenticationService\n*L\n94#1:302,3\n*E\n"})
public final class TestAuthenticationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final cookieJar.1 cookieJar = new CookieJar(){
        private final List<Cookie> cookies;
        {
            this.cookies = new ArrayList<E>();
        }

        public final List<Cookie> getCookies() {
            return this.cookies;
        }

        public List<Cookie> loadForRequest(HttpUrl url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return this.cookies;
        }

        public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
            this.cookies.addAll((Collection<Cookie>)cookies);
        }
    };
    @NotNull
    private final OkHttpClient client = OkHttpBuilderExtensionsKt.readTimeout-HG0u8IE(OkHttpBuilderExtensionsKt.callTimeout-HG0u8IE(OkHttpBuilderExtensionsKt.connectTimeout-HG0u8IE(new OkHttpClient.Builder().followRedirects(false), DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)), DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)), DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)).cookieJar(this.cookieJar).build();
    @NotNull
    private static final Map<String, String> headers = new LinkedHashMap();

    private final Response loginRequest(AuthContext context2) {
        HttpUrl httpUrl = new HttpUrl.Builder().scheme("https").host("account.jetbrains.com").addPathSegment("oauth").addPathSegment("login").addQueryParameter("code_challenge", context2.getCodeChallenge()).addQueryParameter("code_challenge_method", "S256").addQueryParameter("client_id", context2.getClientId()).addQueryParameter("redirect_uri", "jetbrains://toolbox/jba/auth").addQueryParameter("scope", CollectionsKt.joinToString$default((Iterable)context2.getScope(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)).addQueryParameter("state", context2.getState()).build();
        Request request2 = new Request.Builder().url(httpUrl).build();
        return this.client.newCall(request2).execute();
    }

    private final Response authWithPassword(String authSessionId, AuthRequest authRequest) {
        JsonObjectBuilder builder$iv;
        HttpUrl url = new HttpUrl.Builder().scheme("https").host("account.jetbrains.com").addPathSegment("api").addPathSegment("auth").addPathSegment("sessions").addPathSegment(authSessionId).addPathSegment("password").build();
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$authWithPassword_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$authWithPassword_u24lambda_u240, (String)"email", (String)authRequest.getEmail());
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$authWithPassword_u24lambda_u240, (String)"password", (String)authRequest.getPassword());
        String jsonBody = builder$iv.build().toString();
        RequestBody body = RequestBody.Companion.create(jsonBody, MediaType.Companion.get("application/json; charset=utf-8"));
        Request request2 = new Request.Builder().url(url).method("POST", body).headers(Headers.Companion.of(headers)).build();
        Logger.INSTANCE.info("Calling " + request2.method() + " " + request2.url());
        return this.client.newCall(request2).execute();
    }

    private final Response getSession(String authSessionId) {
        HttpUrl url = new HttpUrl.Builder().scheme("https").host("account.jetbrains.com").addPathSegment("api").addPathSegment("auth").addPathSegment("sessions").addPathSegment(authSessionId).build();
        Request request2 = new Request.Builder().url(url).get().headers(Headers.Companion.of(headers)).build();
        return this.client.newCall(request2).execute();
    }

    /*
     * WARNING - void declaration
     */
    private final JetBrainsAccountSecureToken buildTokenEntity(Response response2) {
        Instant instant;
        Json json2 = JsonKt.getJsonx();
        ResponseBody responseBody = response2.body();
        String string = responseBody != null ? responseBody.string() : null;
        Intrinsics.checkNotNull((Object)string);
        JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)json2.parseToJsonElement(string));
        Logger.INSTANCE.info("Fetched token: " + jsonObject);
        OAuth2Token result2 = (OAuth2Token)JsonKt.getJsonx().decodeFromJsonElement((DeserializationStrategy)OAuth2Token.Companion.serializer(), (JsonElement)jsonObject);
        Clock.System clock = Clock.System.INSTANCE;
        Instant expirationNow = clock.now();
        OAuth2Token oAuth2Token = result2;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        Long l = null;
        Duration duration = null;
        Duration duration2 = result2.getExpiresIn-FghU774();
        if (duration2 != null) {
            void it;
            long l2 = duration2.unbox-impl();
            Duration duration3 = duration;
            Long l3 = l;
            String string9 = string8;
            String string10 = string7;
            String string11 = string6;
            String string12 = string5;
            String string13 = string4;
            String string14 = string3;
            String string15 = string2;
            OAuth2Token oAuth2Token2 = oAuth2Token;
            boolean bl = false;
            Instant instant2 = expirationNow.plus-LRDsOJo((long)it);
            oAuth2Token = oAuth2Token2;
            string2 = string15;
            string3 = string14;
            string4 = string13;
            string5 = string12;
            string6 = string11;
            string7 = string10;
            string8 = string9;
            l = l3;
            duration = duration3;
            instant = instant2;
        } else {
            instant = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        String string16 = null;
        OAuth2Token oAuth2Token3 = OAuth2Token.copy-I-hR9vI$default(oAuth2Token, string2, string3, string4, string5, string6, string7, string8, l, duration, instant, null, 1535, null);
        return new JetBrainsAccountSecureToken(oAuth2Token3, string16, n, defaultConstructorMarker);
    }

    private final Response followRedirect(String redirectUrl) {
        return this.client.newCall(new Request.Builder().headers(Headers.Companion.of(headers)).url(redirectUrl).build()).execute();
    }

    private final AuthContext createContext(AuthRequest authRequest) {
        MessageDigest messageDigest;
        String codeVerifier = "minimum64bytesminimum64bytesminimum64bytesminimum64bytesminimum6";
        byte[] byArray = codeVerifier.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes2 = byArray;
        MessageDigest $this$createContext_u24lambda_u240 = messageDigest = MessageDigest.getInstance("SHA-256");
        boolean bl = false;
        $this$createContext_u24lambda_u240.update(bytes2);
        MessageDigest messageDigest2 = messageDigest;
        Base64 base64 = Base64.Default.getUrlSafe().withPadding(Base64.PaddingOption.ABSENT);
        byte[] byArray2 = messageDigest2.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        String codeChallenge = Base64.encode$default((Base64)base64, (byte[])byArray2, (int)0, (int)0, (int)6, null);
        String state2 = Uuid.Companion.random().toString();
        return new AuthContext(codeVerifier, codeChallenge, state2, authRequest.getClientId(), authRequest.getScope());
    }

    private final void validateResponse(Response response2) {
        if (response2.isSuccessful() || response2.code() == 302 || response2.code() == 303) {
            return;
        }
        Request request2 = response2.request();
        ResponseBody responseBody = response2.body();
        String string = "Failed request:  " + request2.method() + " " + request2.url() + "\n " + request2.headers() + ";\nresponse was: " + response2.code() + "\n " + response2.headers() + ";\n" + (responseBody != null ? responseBody.string() : null);
        throw new IllegalStateException(string.toString());
    }

    private final String getLocationHeader(Response response2) {
        String string = Response.header$default(response2, "Location", null, 2, null);
        if (string == null) {
            boolean bl = false;
            String string2 = "Location header is missing";
            throw new IllegalArgumentException(string2.toString());
        }
        return string;
    }

    private final String getReturnTo(Response response2) {
        Json json2 = JsonKt.getJsonx();
        ResponseBody responseBody = response2.body();
        String string = responseBody != null ? responseBody.string() : null;
        Intrinsics.checkNotNull((Object)string);
        JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)json2.parseToJsonElement(string));
        Logger.INSTANCE.info("Fetching returnTo: " + jsonObject);
        Object object = (JsonElement)jsonObject.get((Object)"returnTo");
        if (object == null || (object = object.toString()) == null || (object = StringsKt.removeSurrounding((String)object, (CharSequence)"\"")) == null) {
            throw new IllegalStateException("returnTo is missing in response".toString());
        }
        return object;
    }

    private final Response fetchToken(AuthRequest authRequest, AuthContext context2, String code) {
        FormBody body = new FormBody.Builder(null, 1, null).addEncoded("grant_type", "authorization_code").addEncoded("client_id", authRequest.getClientId()).addEncoded("code", code).addEncoded("redirect_uri", "jetbrains://toolbox/jba/auth").addEncoded("code_verifier", context2.getCodeVerifier()).addEncoded("state", context2.getState()).build();
        Request request2 = new Request.Builder().url("https://oauth.account.jetbrains.com/oauth2/token").post(body).build();
        return this.client.newCall(request2).execute();
    }

    private final JetBrainsAccountSecureToken withRetry(int times, Function0<JetBrainsAccountSecureToken> block) {
        headers.clear();
        this.cookieJar.getCookies().clear();
        Throwable lastException = null;
        int n = 0;
        while (n < times) {
            int attempt = n++;
            boolean bl = false;
            try {
                return (JetBrainsAccountSecureToken)block.invoke();
            }
            catch (Throwable e) {
                lastException = e;
                Logger.INSTANCE.warn(e, "Failed to fetch token. Attempt " + attempt + "/" + times);
            }
        }
        Throwable throwable = lastException;
        if (throwable == null) {
            String string = "All attempts failed but not exception was caught";
            throw new IllegalStateException(string.toString());
        }
        throw throwable;
    }

    static /* synthetic */ JetBrainsAccountSecureToken withRetry$default(TestAuthenticationService testAuthenticationService, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return testAuthenticationService.withRetry(n, (Function0<JetBrainsAccountSecureToken>)function0);
    }

    @NotNull
    public final JetBrainsAccountSecureToken fetchToken(@NotNull AuthRequest authRequest) {
        Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
        return TestAuthenticationService.withRetry$default(this, 0, () -> TestAuthenticationService.fetchToken$lambda$0(this, authRequest), 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JetBrainsAccountSecureToken fetchToken$lambda$0(TestAuthenticationService this$0, AuthRequest $authRequest) {
        JetBrainsAccountSecureToken jetBrainsAccountSecureToken;
        Object tokenCode;
        Object it;
        String thirdAuthSessionId;
        Object object;
        Object object2;
        Object it2;
        Object it3;
        Object secondAuthSessionId;
        Object it4;
        Object it5;
        Object it6;
        Object it7;
        Object it8;
        Object it9;
        Object it10;
        AuthContext context2 = this$0.createContext($authRequest);
        Closeable closeable = this$0.loginRequest(context2);
        Object object3 = null;
        try {
            it10 = (Response)closeable;
            boolean bl = false;
            this$0.validateResponse((Response)it10);
            it10 = this$0.getLocationHeader((Response)it10);
        }
        catch (Throwable bl) {
            object3 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
        }
        Object oauth2CodeChallenge = it10;
        object3 = this$0.followRedirect((String)oauth2CodeChallenge);
        it10 = null;
        try {
            it9 = (Response)object3;
            boolean bl = false;
            this$0.validateResponse((Response)it9);
            it9 = this$0.getLocationHeader((Response)it9);
        }
        catch (Throwable bl) {
            it10 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)it10);
        }
        Object apiRestOAuth2InteractiveLogin = it9;
        it10 = this$0.followRedirect((String)apiRestOAuth2InteractiveLogin);
        it9 = null;
        try {
            it8 = (Response)it10;
            boolean bl = false;
            this$0.validateResponse((Response)it8);
            it8 = this$0.getLocationHeader((Response)it8);
        }
        catch (Throwable bl) {
            it9 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it10, (Throwable)it9);
        }
        Object accountJBOauth2Login = it8;
        it9 = this$0.followRedirect((String)accountJBOauth2Login);
        it8 = null;
        try {
            it7 = (Response)it9;
            boolean bl = false;
            this$0.validateResponse((Response)it7);
            it7 = this$0.getLocationHeader((Response)it7);
        }
        catch (Throwable bl) {
            it8 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it9, (Throwable)it8);
        }
        Object accountJBLoginAuthSession = it7;
        String string = URIExtensionsKt.parseQuery(new URI((String)accountJBLoginAuthSession)).get("authSessionId");
        if (string == null) {
            boolean $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$authSessionId$22 = false;
            String $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$authSessionId$22 = "Error authSessionId is missing";
            throw new IllegalArgumentException($i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$authSessionId$22.toString());
        }
        String authSessionId = string;
        it8 = this$0.followRedirect("https://account.jetbrains.com" + (String)accountJBLoginAuthSession);
        Object $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$authSessionId$22 = null;
        try {
            Object v1;
            block72: {
                it6 = (Response)it8;
                boolean bl = false;
                Iterable iterable = this$0.cookieJar.getCookies();
                for (Object t2 : iterable) {
                    Cookie cookie = (Cookie)t2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)cookie.name(), (Object)"_st-JBA")) continue;
                    v1 = t2;
                    break block72;
                }
                v1 = null;
            }
            Cookie cookie = v1;
            if (cookie != null) {
                Cookie cookie2 = cookie;
                boolean bl = false;
                headers.put("X-Xsrf-Token", cookie2.value());
            }
            this$0.validateResponse((Response)it6);
            it6 = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$authSessionId$22 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it8, (Throwable)$i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$authSessionId$22);
        }
        $i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$authSessionId$22 = this$0.authWithPassword(authSessionId, $authRequest);
        it6 = null;
        try {
            it5 = (Response)$i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$authSessionId$22;
            boolean bl = false;
            this$0.validateResponse((Response)it5);
            it5 = this$0.getReturnTo((Response)it5);
        }
        catch (Throwable bl) {
            it6 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$i$a$-requireNotNull-TestAuthenticationService$fetchToken$1$authSessionId$22, (Throwable)it6);
        }
        Object accountJBOauth2Auth = it5;
        it6 = this$0.followRedirect("https://account.jetbrains.com" + (String)accountJBOauth2Auth);
        it5 = null;
        try {
            it4 = (Response)it6;
            boolean bl = false;
            this$0.validateResponse((Response)it4);
            it4 = URIExtensionsKt.parseQuery(new URI(this$0.getLocationHeader((Response)it4))).get("authSessionId");
        }
        catch (Throwable bl) {
            it5 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it6, (Throwable)it5);
        }
        Object object4 = secondAuthSessionId = it4;
        Intrinsics.checkNotNull((Object)object4);
        it5 = this$0.getSession((String)object4);
        it4 = null;
        try {
            it3 = (Response)it5;
            boolean bl = false;
            this$0.validateResponse((Response)it3);
            it3 = this$0.getReturnTo((Response)it3);
        }
        catch (Throwable bl) {
            it4 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it5, (Throwable)it4);
        }
        Object landCode = it3;
        it4 = this$0.followRedirect((String)landCode);
        it3 = null;
        try {
            it2 = (Response)it4;
            boolean bl = false;
            this$0.validateResponse((Response)it2);
            it2 = this$0.getLocationHeader((Response)it2);
        }
        catch (Throwable bl) {
            it3 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it4, (Throwable)it3);
        }
        Object oauthApiRestAuthCodeChallenge = it2;
        it3 = this$0.followRedirect((String)oauthApiRestAuthCodeChallenge);
        it2 = null;
        try {
            Response it11 = (Response)it3;
            boolean bl = false;
            this$0.validateResponse(it11);
            object2 = this$0.getLocationHeader(it11);
        }
        catch (Throwable bl) {
            it2 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it3, (Throwable)it2);
        }
        String accountJAOauthRedirectCode = object2;
        it2 = this$0.followRedirect(accountJAOauthRedirectCode);
        object2 = null;
        try {
            Response it12 = (Response)it2;
            boolean bl = false;
            this$0.validateResponse(it12);
            object = URIExtensionsKt.parseQuery(new URI(this$0.getLocationHeader(it12))).get("authSessionId");
        }
        catch (Throwable bl) {
            object2 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it2, (Throwable)object2);
        }
        String string2 = thirdAuthSessionId = object;
        Intrinsics.checkNotNull((Object)string2);
        object2 = this$0.getSession(string2);
        object = null;
        try {
            it = (Response)object2;
            boolean bl = false;
            this$0.validateResponse((Response)it);
            it = URIExtensionsKt.parseQuery(new URI(this$0.getReturnTo((Response)it))).get("code");
        }
        catch (Throwable bl) {
            object = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
        }
        Object object5 = tokenCode = it;
        Intrinsics.checkNotNull((Object)object5);
        object2 = this$0.fetchToken($authRequest, context2, (String)object5);
        object = null;
        try {
            it = (Response)object2;
            boolean bl = false;
            this$0.validateResponse((Response)it);
            jetBrainsAccountSecureToken = this$0.buildTokenEntity((Response)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
        }
        return jetBrainsAccountSecureToken;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

