/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell.name;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.shell.name.ShellLauncherNameValidator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class ShellLauncherNameValidatorImpl
implements ShellLauncherNameValidator {
    @NotNull
    private final String extension;
    @NotNull
    private final Regex allowedFilenameCharsRegexp;

    public ShellLauncherNameValidatorImpl(@NotNull OS.Type os) {
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        this.extension = os == OS.Type.Windows ? "(\\.cmd)?" : "";
        this.allowedFilenameCharsRegexp = new Regex("[\\p{L}\\d\\-]{1,140}" + this.extension + "|");
    }

    public /* synthetic */ ShellLauncherNameValidatorImpl(OS.Type type2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            type2 = OS.INSTANCE.getType();
        }
        this(type2);
    }

    @Override
    public boolean isValidName(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.allowedFilenameCharsRegexp.matches((CharSequence)filename);
    }

    public ShellLauncherNameValidatorImpl() {
        this(null, 1, null);
    }
}

