/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell.creator;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.shell.creator.ScriptCreator;
import com.jetbrains.toolbox.shell.creator.ShellLauncherCreator;
import com.jetbrains.toolbox.shell.creator.SymlinkCreator;
import com.jetbrains.toolbox.shell.generator.ShellLauncherGenerator;
import com.jetbrains.toolbox.shell.generator.WindowsCommonLauncherGenerator;
import com.jetbrains.toolbox.shell.model.ToolInfo;
import com.jetbrains.toolbox.shell.resolver.ExecutableResolver;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class ShellLauncherCreatorImpl
implements ShellLauncherCreator {
    @NotNull
    private final String applicationFullNameVersion;
    @NotNull
    private final ShellLauncherGenerator intellijLauncherGenerator;
    @NotNull
    private final ExecutableResolver fleetExecutableResolver;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Lazy intellijLauncherCreator$delegate;
    @NotNull
    private final Lazy fleetLauncherCreator$delegate;

    public ShellLauncherCreatorImpl(@NotNull String applicationFullNameVersion, @NotNull ShellLauncherGenerator intellijLauncherGenerator, @NotNull ExecutableResolver fleetExecutableResolver, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)applicationFullNameVersion, (String)"applicationFullNameVersion");
        Intrinsics.checkNotNullParameter((Object)intellijLauncherGenerator, (String)"intellijLauncherGenerator");
        Intrinsics.checkNotNullParameter((Object)fleetExecutableResolver, (String)"fleetExecutableResolver");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.applicationFullNameVersion = applicationFullNameVersion;
        this.intellijLauncherGenerator = intellijLauncherGenerator;
        this.fleetExecutableResolver = fleetExecutableResolver;
        this.fileSystem = fileSystem;
        this.intellijLauncherCreator$delegate = LazyKt.lazy(() -> ShellLauncherCreatorImpl.intellijLauncherCreator_delegate$lambda$0(this));
        this.fleetLauncherCreator$delegate = LazyKt.lazy(() -> ShellLauncherCreatorImpl.fleetLauncherCreator_delegate$lambda$0(this));
    }

    private final ScriptCreator getIntellijLauncherCreator() {
        Lazy lazy = this.intellijLauncherCreator$delegate;
        return (ScriptCreator)lazy.getValue();
    }

    private final ShellLauncherCreator getFleetLauncherCreator() {
        Lazy lazy = this.fleetLauncherCreator$delegate;
        return (ShellLauncherCreator)lazy.getValue();
    }

    @Override
    public void createLauncher(@NotNull ToolInfo tool, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.getCreator(tool.getAppType()).createLauncher(tool, file);
        Logger.INSTANCE.debug("Shell script for " + tool + " is created: " + file);
    }

    private final ShellLauncherCreator getCreator(ToolInfo.AppType type2) {
        return switch (WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
            case 1 -> this.getIntellijLauncherCreator();
            case 2 -> this.getFleetLauncherCreator();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final ScriptCreator intellijLauncherCreator_delegate$lambda$0(ShellLauncherCreatorImpl this$0) {
        return new ScriptCreator(this$0.intellijLauncherGenerator, this$0.fileSystem);
    }

    private static final ShellLauncherCreator fleetLauncherCreator_delegate$lambda$0(ShellLauncherCreatorImpl this$0) {
        return switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
            case 1 -> new ScriptCreator(new WindowsCommonLauncherGenerator(this$0.applicationFullNameVersion, this$0.fleetExecutableResolver), this$0.fileSystem);
            case 2, 3 -> new SymlinkCreator(this$0.fleetExecutableResolver, this$0.fileSystem);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ToolInfo.AppType.values().length];
            try {
                nArray[ToolInfo.AppType.IntellijBased.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolInfo.AppType.Fleet.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

