/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell.creator;

import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.shell.creator.ShellLauncherCreator;
import com.jetbrains.toolbox.shell.generator.ShellLauncherGenerator;
import com.jetbrains.toolbox.shell.model.ToolInfo;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nScriptCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptCreator.kt\ncom/jetbrains/toolbox/shell/creator/ScriptCreator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,38:1\n1#2:39\n80#3:40\n165#3:41\n81#3:42\n82#3:47\n52#4,4:43\n60#4,10:48\n56#4,18:58\n*S KotlinDebug\n*F\n+ 1 ScriptCreator.kt\ncom/jetbrains/toolbox/shell/creator/ScriptCreator\n*L\n26#1:40\n26#1:41\n26#1:42\n26#1:47\n26#1:43,4\n26#1:48,10\n26#1:58,18\n*E\n"})
public final class ScriptCreator
implements ShellLauncherCreator {
    @NotNull
    private final ShellLauncherGenerator generator;
    @NotNull
    private final FileSystem fileSystem;

    public ScriptCreator(@NotNull ShellLauncherGenerator generator, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.generator = generator;
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createLauncher(@NotNull ToolInfo tool, @NotNull Path file) {
        BufferedSink bufferedSink;
        Throwable thrown$iv$iv;
        block18: {
            void $this$iv;
            boolean bl;
            Path $i$a$-check-ScriptCreator$createLauncher$223232322;
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FileMetadata fileMetadata2 = this.fileSystem.metadataOrNull(file);
            if (!(!(fileMetadata2 != null ? fileMetadata2.isDirectory() : false))) {
                boolean $i$a$-check-ScriptCreator$createLauncher$223232322 = false;
                String $i$a$-check-ScriptCreator$createLauncher$223232322 = "Unable to create script file at '" + file + "' because there is a directory at this path.";
                throw new IllegalStateException($i$a$-check-ScriptCreator$createLauncher$223232322.toString());
            }
            Path path2 = file.parent();
            if (path2 != null) {
                $i$a$-check-ScriptCreator$createLauncher$223232322 = path2;
                FileSystem fileSystem = this.fileSystem;
                Path p0 = $i$a$-check-ScriptCreator$createLauncher$223232322;
                bl = false;
                fileSystem.createDirectories(p0);
            }
            String text2 = this.generator.generateShellScript(tool);
            $i$a$-check-ScriptCreator$createLauncher$223232322 = this.fileSystem;
            Path file$iv = file;
            boolean mustCreate$iv = false;
            bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSink $this$createLauncher_u24lambda_u241 = it$iv;
                boolean bl3 = false;
                bufferedSink = $this$createLauncher_u24lambda_u241.writeString(text2, OS.INSTANCE.getSystemCharset());
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    bufferedSink = null;
                    break block18;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block19: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block19;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        BufferedSink result$iv$iv = bufferedSink;
        Throwable throwable = thrown$iv$iv;
        if (throwable != null) {
            throw throwable;
        }
        if (com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows()) {
            return;
        }
        FileSystem $this$createLauncher_u24lambda_u242 = this.fileSystem;
        boolean bl = false;
        FileSystemExtKt.setReadable($this$createLauncher_u24lambda_u242, file, true, false);
        FileSystemExtKt.setWritable($this$createLauncher_u24lambda_u242, file, true, true);
        FileSystemExtKt.setExecutable($this$createLauncher_u24lambda_u242, file, true, false);
    }
}

