/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell;

import com.jetbrains.toolbox.common.WellKnownPaths;
import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.integration.OSIntegrationManager;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.settings.ShellScriptsSettings;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import com.jetbrains.toolbox.shell.ShellLaunchersDirectoryManager;
import com.jetbrains.toolbox.shell.model.ShellLaunchersDirectoryValidationResults;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nShellLaunchersDirectoryManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellLaunchersDirectoryManagerImpl.kt\ncom/jetbrains/toolbox/shell/ShellLaunchersDirectoryManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1761#2,3:126\n1#3:129\n*S KotlinDebug\n*F\n+ 1 ShellLaunchersDirectoryManagerImpl.kt\ncom/jetbrains/toolbox/shell/ShellLaunchersDirectoryManagerImpl\n*L\n113#1:126,3\n*E\n"})
public final class ShellLaunchersDirectoryManagerImpl
implements ShellLaunchersDirectoryManager {
    @NotNull
    private final OSIntegrationManager osIntegrationManager;
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final ShellEnvironment shellEnvironment;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final WellKnownPaths wellKnownPaths;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Path usrLocalBin;
    @NotNull
    private final Set<Path> addedPaths;
    @NotNull
    private final StateFlow<String> launchersDirectoryDisplayPath;
    @NotNull
    private final StateFlow<Path> launchersDirectory;
    @NotNull
    private final Lazy defaultDirectory$delegate;

    public ShellLaunchersDirectoryManagerImpl(@NotNull OSIntegrationManager osIntegrationManager, @NotNull SettingsManager settingsManager, @NotNull ShellEnvironment shellEnvironment, @NotNull FileSystem fileSystem, @NotNull WellKnownPaths wellKnownPaths, @NotNull CoroutineScope coroutineScope) {
        String trimmedLocation;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)osIntegrationManager, (String)"osIntegrationManager");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)shellEnvironment, (String)"shellEnvironment");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)wellKnownPaths, (String)"wellKnownPaths");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.osIntegrationManager = osIntegrationManager;
        this.settingsManager = settingsManager;
        this.shellEnvironment = shellEnvironment;
        this.fileSystem = fileSystem;
        this.wellKnownPaths = wellKnownPaths;
        this.coroutineScope = coroutineScope;
        this.usrLocalBin = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/usr/local/bin", (boolean)false, (int)1, null);
        this.addedPaths = new LinkedHashSet();
        this.launchersDirectoryDisplayPath = FlowExtensionsKt.mapState(this.settingsManager.getSettings(), arg_0 -> ShellLaunchersDirectoryManagerImpl.launchersDirectoryDisplayPath$lambda$0(this, arg_0));
        this.launchersDirectory = FlowExtensionsKt.mapState(this.launchersDirectoryDisplayPath, arg_0 -> ShellLaunchersDirectoryManagerImpl.launchersDirectory$lambda$0(this, arg_0));
        this.defaultDirectory$delegate = LazyKt.lazy(() -> ShellLaunchersDirectoryManagerImpl.defaultDirectory_delegate$lambda$0(this));
        String location2 = this.getSettings().getLocation();
        if (this.getSettings().getEnabled() && ((charSequence = (CharSequence)location2) == null || charSequence.length() == 0)) {
            this.addDefaultDirectoryToPath();
            this.updateSettings((Function1<? super ShellScriptsSettings, ShellScriptsSettings>)((Function1)arg_0 -> ShellLaunchersDirectoryManagerImpl._init_$lambda$0(this, arg_0)));
        }
        String string = location2;
        String string2 = trimmedLocation = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        if (!Intrinsics.areEqual((Object)trimmedLocation, (Object)location2)) {
            this.updateSettings((Function1<? super ShellScriptsSettings, ShellScriptsSettings>)((Function1)arg_0 -> ShellLaunchersDirectoryManagerImpl._init_$lambda$1(trimmedLocation, arg_0)));
        }
    }

    private final ShellScriptsSettings getSettings() {
        return ((SelfSettings)this.settingsManager.getSettings().getValue()).getShellScripts();
    }

    private final void updateSettings(Function1<? super ShellScriptsSettings, ShellScriptsSettings> function) {
        this.settingsManager.updateSettings((Function1<? super SelfSettings, SelfSettings>)((Function1)arg_0 -> ShellLaunchersDirectoryManagerImpl.updateSettings$lambda$0(function, arg_0)));
    }

    private final List<Path> currentResolvedPaths() {
        return CollectionsKt.plus((Collection)this.shellEnvironment.getPath(), (Iterable)this.addedPaths);
    }

    @Override
    @NotNull
    public StateFlow<Path> getLaunchersDirectory() {
        return this.launchersDirectory;
    }

    @Override
    @NotNull
    public Path getDefaultDirectory() {
        Lazy lazy = this.defaultDirectory$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    public void addDefaultDirectoryToPath() {
        Path defaultPath = this.getDefaultDirectory();
        if (this.currentResolvedPaths().contains(defaultPath)) {
            return;
        }
        if (!this.fileSystem.exists(defaultPath)) {
            try {
                this.fileSystem.createDirectories(defaultPath);
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.warn("Could not create default scripts directory: " + defaultPath);
            }
        }
        if (this.osIntegrationManager.addLocationToPath(defaultPath)) {
            ((Collection)this.addedPaths).add(defaultPath);
        }
    }

    @Override
    @Nullable
    public Object validateDirectory(@NotNull String displayPath, @NotNull Continuation<? super ShellLaunchersDirectoryValidationResults> $completion) {
        return BuildersKt.withContext((CoroutineContext)this.coroutineScope.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ShellLaunchersDirectoryValidationResults>, Object>(this, displayPath, null){
            int label;
            final /* synthetic */ ShellLaunchersDirectoryManagerImpl this$0;
            final /* synthetic */ String $displayPath;
            {
                this.this$0 = $receiver;
                this.$displayPath = $displayPath;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return ShellLaunchersDirectoryManagerImpl.access$validateShellPath(this.this$0, ShellLaunchersDirectoryManagerImpl.access$resolvePath(this.this$0, this.$displayPath));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ShellLaunchersDirectoryValidationResults> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final ShellLaunchersDirectoryValidationResults validateShellPath(Path path2) {
        ShellLaunchersDirectoryValidationResults shellLaunchersDirectoryValidationResults;
        try {
            shellLaunchersDirectoryValidationResults = ((CharSequence)path2.toString()).length() == 0 ? (ShellLaunchersDirectoryValidationResults)ShellLaunchersDirectoryValidationResults.Valid.INSTANCE : (!this.fileSystem.exists(path2) ? (ShellLaunchersDirectoryValidationResults)ShellLaunchersDirectoryValidationResults.NotExists.INSTANCE : (!this.fileSystem.metadata(path2).isDirectory() ? (ShellLaunchersDirectoryValidationResults)ShellLaunchersDirectoryValidationResults.NotDirectory.INSTANCE : (!FileSystemExtKt.isWritable(this.fileSystem, path2) ? (ShellLaunchersDirectoryValidationResults)ShellLaunchersDirectoryValidationResults.NotWritable.INSTANCE : (!this.isInPath(path2) ? (ShellLaunchersDirectoryValidationResults)ShellLaunchersDirectoryValidationResults.NotInPath.INSTANCE : (ShellLaunchersDirectoryValidationResults)ShellLaunchersDirectoryValidationResults.Valid.INSTANCE))));
        }
        catch (Throwable throwable) {
            shellLaunchersDirectoryValidationResults = ShellLaunchersDirectoryValidationResults.NotDirectory.INSTANCE;
        }
        return shellLaunchersDirectoryValidationResults;
    }

    private final boolean isInPath(Path file) {
        boolean bl;
        block5: {
            if (OS.INSTANCE.isWindows()) {
                Iterable $this$any$iv = this.currentResolvedPaths();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Path it = (Path)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)it.toString(), (String)file.toString(), (boolean)true)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = this.currentResolvedPaths().contains(file);
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public String getLaunchersDirectoryDisplayPath() {
        return (String)this.launchersDirectoryDisplayPath.getValue();
    }

    private final Path resolvePath(String path2) {
        Path path3;
        if (StringsKt.startsWith$default((String)path2, (String)"~/", (boolean)false, (int)2, null)) {
            Path path4 = this.wellKnownPaths.getHome();
            String string = path2.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            path3 = path4.resolve(string);
        } else {
            path3 = Path.Companion.get(path2, true);
        }
        return path3;
    }

    private static final SelfSettings updateSettings$lambda$0(Function1 $function, SelfSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SelfSettings.copy$default(it, null, null, false, false, null, 0, null, null, null, (ShellScriptsSettings)$function.invoke((Object)it.getShellScripts()), null, null, null, null, null, null, null, 130559, null);
    }

    private static final String launchersDirectoryDisplayPath$lambda$0(ShellLaunchersDirectoryManagerImpl this$0, SelfSettings it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getShellScripts().getEnabled()) {
            string = it.getShellScripts().getLocation();
            if (string == null || (string = StringExtensionsKt.getNullIfBlank(string)) == null) {
                string = this$0.getDefaultDirectory().toString();
            }
        } else {
            string = null;
        }
        return string;
    }

    private static final Path launchersDirectory$lambda$0(ShellLaunchersDirectoryManagerImpl this$0, String it) {
        Path path2;
        String string = it;
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            path2 = this$0.resolvePath(p0);
        } else {
            path2 = null;
        }
        return path2;
    }

    private static final Path defaultDirectory_delegate$lambda$0(ShellLaunchersDirectoryManagerImpl this$0) {
        ThreadGuardKt.assertNotMainThread("FileSystem.exists() on macOS");
        return OS.INSTANCE.isMac() && this$0.fileSystem.exists(this$0.usrLocalBin) && FileSystemExtKt.isWritable(this$0.fileSystem, this$0.usrLocalBin) ? this$0.usrLocalBin : this$0.wellKnownPaths.getToolboxDataLocation().resolve("scripts");
    }

    private static final ShellScriptsSettings _init_$lambda$0(ShellLaunchersDirectoryManagerImpl this$0, ShellScriptsSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ShellScriptsSettings(true, this$0.getDefaultDirectory().toString());
    }

    private static final ShellScriptsSettings _init_$lambda$1(String $trimmedLocation, ShellScriptsSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ShellScriptsSettings.copy$default(it, false, $trimmedLocation, 1, null);
    }

    public static final /* synthetic */ ShellLaunchersDirectoryValidationResults access$validateShellPath(ShellLaunchersDirectoryManagerImpl $this, Path path2) {
        return $this.validateShellPath(path2);
    }

    public static final /* synthetic */ Path access$resolvePath(ShellLaunchersDirectoryManagerImpl $this, String path2) {
        return $this.resolvePath(path2);
    }
}

