/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.settings;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.interop.Win32Integration;
import com.jetbrains.toolbox.settings.ApplicationState;
import com.jetbrains.toolbox.settings.ApplicationStateManager;
import java.io.Closeable;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nApplicationStateManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationStateManagerImpl.kt\ncom/jetbrains/toolbox/settings/ApplicationStateManagerImpl\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 OkioStreams.kt\nkotlinx/serialization/json/okio/OkioStreamsKt\n+ 5 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n+ 6 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n66#2:63\n52#2,4:65\n60#2,10:71\n56#2,3:81\n71#2,3:84\n52#2,4:103\n60#2,10:109\n56#2,18:119\n67#3:64\n68#3:69\n80#3:100\n165#3:101\n81#3:102\n82#3:107\n78#4:70\n46#4:108\n7#5,7:87\n230#6,5:94\n1#7:99\n*S KotlinDebug\n*F\n+ 1 ApplicationStateManagerImpl.kt\ncom/jetbrains/toolbox/settings/ApplicationStateManagerImpl\n*L\n41#1:63\n41#1:65,4\n41#1:71,10\n41#1:81,3\n41#1:84,3\n59#1:103,4\n59#1:109,10\n59#1:119,18\n41#1:64\n41#1:69\n59#1:100\n59#1:101\n59#1:102\n59#1:107\n41#1:70\n59#1:108\n46#1:87,7\n51#1:94,5\n*E\n"})
public final class ApplicationStateManagerImpl
implements ApplicationStateManager {
    @NotNull
    private final Path stateFile;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Json json;
    @NotNull
    private final MutableStateFlow<ApplicationState> currentState;
    @NotNull
    private final MutableStateFlow<ApplicationState> state;

    public ApplicationStateManagerImpl(@NotNull Path stateFile, @NotNull FileSystem fileSystem, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)stateFile, (String)"stateFile");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.stateFile = stateFile;
        this.fileSystem = fileSystem;
        this.json = JsonKt.Json$default(null, ApplicationStateManagerImpl::json$lambda$0, (int)1, null);
        ApplicationState applicationState = this.loadState();
        if (applicationState == null) {
            applicationState = new ApplicationState(null, null, 3, null);
        }
        this.currentState = StateFlowKt.MutableStateFlow((Object)applicationState);
        this.state = this.currentState;
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ApplicationStateManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.currentState.collect(new FlowCollector(){

                            public final Object emit(ApplicationState it, Continuation<? super Unit> $completion) {
                                this$0.saveState();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public MutableStateFlow<ApplicationState> getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ApplicationState loadState() {
        Object $this$use$iv$iv;
        boolean bl;
        if (!this.fileSystem.exists(this.stateFile)) {
            return null;
        }
        try {
            ApplicationState applicationState;
            Throwable thrown$iv$iv;
            FileSystem fileSystem;
            block30: {
                void this_$iv;
                fileSystem = this.fileSystem;
                Path file$iv = this.stateFile;
                bl = false;
                $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    void $this$decodeFromBufferedSource$iv;
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$loadState_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    Json json2 = this.json;
                    BufferedSource source$iv = $this$loadState_u24lambda_u240;
                    boolean $i$f$decodeFromBufferedSource = false;
                    $this$decodeFromBufferedSource$iv.getSerializersModule();
                    applicationState = (ApplicationState)OkioStreamsKt.decodeFromBufferedSource((Json)$this$decodeFromBufferedSource$iv, (DeserializationStrategy)((DeserializationStrategy)BuiltinSerializersKt.getNullable(ApplicationState.Companion.serializer())), (BufferedSource)source$iv);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        applicationState = null;
                        break block30;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block31: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block31;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            ApplicationState result$iv$iv = applicationState;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            fileSystem = result$iv$iv;
            return fileSystem;
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to deserialize application state");
            ApplicationState t$iv = null;
            return t$iv;
        }
        finally {
            boolean $i$f$catching = false;
            try {
                bl = false;
                this.fileSystem.delete(this.stateFile);
                $this$use$iv$iv = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (CancellationException c$iv) {
                throw c$iv;
            }
            catch (Throwable t$iv) {
                $this$use$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
            }
        }
    }

    @Override
    public void updateState(@NotNull Function1<? super ApplicationState, ApplicationState> transform2) {
        Object nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        MutableStateFlow<ApplicationState> $this$update$iv = this.currentState;
        boolean $i$f$update = false;
        while (!$this$update$iv.compareAndSet(prevValue$iv = $this$update$iv.getValue(), nextValue$iv = transform2.invoke(prevValue$iv))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveState() {
        Unit unit;
        Throwable thrown$iv$iv;
        block16: {
            void $this$iv;
            if (OS.INSTANCE.isWindows() && this.fileSystem.exists(this.stateFile)) {
                Win32Integration.INSTANCE.setFileAttributesNormal(this.stateFile.toFile());
            }
            Path path2 = this.stateFile.parent();
            if (path2 != null) {
                Path path3 = path2;
                FileSystem fileSystem = this.fileSystem;
                Path p0 = path3;
                boolean bl = false;
                fileSystem.createDirectories(p0);
            }
            FileSystem fileSystem = this.fileSystem;
            Path file$iv = this.stateFile;
            boolean mustCreate$iv = false;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                void value$iv;
                void $this$encodeToBufferedSink$iv;
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSink $this$saveState_u24lambda_u240 = it$iv;
                boolean bl3 = false;
                Json json2 = this.json;
                Object object = this.currentState.getValue();
                BufferedSink sink$iv = $this$saveState_u24lambda_u240;
                boolean $i$f$encodeToBufferedSink = false;
                $this$encodeToBufferedSink$iv.getSerializersModule();
                OkioStreamsKt.encodeToBufferedSink((Json)$this$encodeToBufferedSink$iv, (SerializationStrategy)((SerializationStrategy)ApplicationState.Companion.serializer()), (Object)value$iv, (BufferedSink)sink$iv);
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    unit = null;
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block17: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block17;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable == null) return;
        throw throwable;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setEncodeDefaults(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }
}

