/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.settings;

import com.jetbrains.toolbox.common.PortRange;
import com.jetbrains.toolbox.common.PortRange$;
import com.jetbrains.toolbox.openssh.SshExecutable;
import com.jetbrains.toolbox.openssh.SshExecutable$;
import com.jetbrains.toolbox.settings.AdvancedSettings$;
import com.jetbrains.toolbox.settings.HttpLoggingVerbosity;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class AdvancedSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean showInstalledBuild;
    private final boolean allowPatches;
    private final boolean submitExceptionsAutomatically;
    @NotNull
    private final HttpLoggingVerbosity httpLoggingVerbosity;
    @NotNull
    private final String apiKeyHeader;
    @Nullable
    private final SshExecutable userSelectedSshExecutable;
    @Nullable
    private final String logLevel;
    @Nullable
    private final PortRange sshDynamicForwardingPortRange;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public AdvancedSettings(boolean showInstalledBuild, boolean allowPatches, boolean submitExceptionsAutomatically, @NotNull HttpLoggingVerbosity httpLoggingVerbosity, @NotNull String apiKeyHeader, @Nullable SshExecutable userSelectedSshExecutable, @Nullable String logLevel, @Nullable PortRange sshDynamicForwardingPortRange) {
        Intrinsics.checkNotNullParameter((Object)((Object)httpLoggingVerbosity), (String)"httpLoggingVerbosity");
        Intrinsics.checkNotNullParameter((Object)apiKeyHeader, (String)"apiKeyHeader");
        this.showInstalledBuild = showInstalledBuild;
        this.allowPatches = allowPatches;
        this.submitExceptionsAutomatically = submitExceptionsAutomatically;
        this.httpLoggingVerbosity = httpLoggingVerbosity;
        this.apiKeyHeader = apiKeyHeader;
        this.userSelectedSshExecutable = userSelectedSshExecutable;
        this.logLevel = logLevel;
        this.sshDynamicForwardingPortRange = sshDynamicForwardingPortRange;
    }

    public /* synthetic */ AdvancedSettings(boolean bl, boolean bl2, boolean bl3, HttpLoggingVerbosity httpLoggingVerbosity, String string, SshExecutable sshExecutable, String string2, PortRange portRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            bl3 = true;
        }
        if ((n & 8) != 0) {
            httpLoggingVerbosity = HttpLoggingVerbosity.None;
        }
        if ((n & 0x10) != 0) {
            string = "";
        }
        if ((n & 0x20) != 0) {
            sshExecutable = null;
        }
        if ((n & 0x40) != 0) {
            string2 = null;
        }
        if ((n & 0x80) != 0) {
            portRange = null;
        }
        this(bl, bl2, bl3, httpLoggingVerbosity, string, sshExecutable, string2, portRange);
    }

    public final boolean getShowInstalledBuild() {
        return this.showInstalledBuild;
    }

    public final boolean getAllowPatches() {
        return this.allowPatches;
    }

    public final boolean getSubmitExceptionsAutomatically() {
        return this.submitExceptionsAutomatically;
    }

    @NotNull
    public final HttpLoggingVerbosity getHttpLoggingVerbosity() {
        return this.httpLoggingVerbosity;
    }

    @NotNull
    public final String getApiKeyHeader() {
        return this.apiKeyHeader;
    }

    @Nullable
    public final SshExecutable getUserSelectedSshExecutable() {
        return this.userSelectedSshExecutable;
    }

    @Nullable
    public final String getLogLevel() {
        return this.logLevel;
    }

    @Nullable
    public final PortRange getSshDynamicForwardingPortRange() {
        return this.sshDynamicForwardingPortRange;
    }

    @NotNull
    public final AdvancedSettings copy(boolean showInstalledBuild, boolean allowPatches, boolean submitExceptionsAutomatically, @NotNull HttpLoggingVerbosity httpLoggingVerbosity, @NotNull String apiKeyHeader, @Nullable SshExecutable userSelectedSshExecutable, @Nullable String logLevel, @Nullable PortRange sshDynamicForwardingPortRange) {
        Intrinsics.checkNotNullParameter((Object)((Object)httpLoggingVerbosity), (String)"httpLoggingVerbosity");
        Intrinsics.checkNotNullParameter((Object)apiKeyHeader, (String)"apiKeyHeader");
        return new AdvancedSettings(showInstalledBuild, allowPatches, submitExceptionsAutomatically, httpLoggingVerbosity, apiKeyHeader, userSelectedSshExecutable, logLevel, sshDynamicForwardingPortRange);
    }

    public static /* synthetic */ AdvancedSettings copy$default(AdvancedSettings advancedSettings, boolean bl, boolean bl2, boolean bl3, HttpLoggingVerbosity httpLoggingVerbosity, String string, SshExecutable sshExecutable, String string2, PortRange portRange, int n, Object object) {
        if ((n & 1) != 0) {
            bl = advancedSettings.showInstalledBuild;
        }
        if ((n & 2) != 0) {
            bl2 = advancedSettings.allowPatches;
        }
        if ((n & 4) != 0) {
            bl3 = advancedSettings.submitExceptionsAutomatically;
        }
        if ((n & 8) != 0) {
            httpLoggingVerbosity = advancedSettings.httpLoggingVerbosity;
        }
        if ((n & 0x10) != 0) {
            string = advancedSettings.apiKeyHeader;
        }
        if ((n & 0x20) != 0) {
            sshExecutable = advancedSettings.userSelectedSshExecutable;
        }
        if ((n & 0x40) != 0) {
            string2 = advancedSettings.logLevel;
        }
        if ((n & 0x80) != 0) {
            portRange = advancedSettings.sshDynamicForwardingPortRange;
        }
        return advancedSettings.copy(bl, bl2, bl3, httpLoggingVerbosity, string, sshExecutable, string2, portRange);
    }

    @NotNull
    public String toString() {
        return "AdvancedSettings(showInstalledBuild=" + this.showInstalledBuild + ", allowPatches=" + this.allowPatches + ", submitExceptionsAutomatically=" + this.submitExceptionsAutomatically + ", httpLoggingVerbosity=" + this.httpLoggingVerbosity + ", apiKeyHeader=" + this.apiKeyHeader + ", userSelectedSshExecutable=" + this.userSelectedSshExecutable + ", logLevel=" + this.logLevel + ", sshDynamicForwardingPortRange=" + this.sshDynamicForwardingPortRange + ")";
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.showInstalledBuild);
        result2 = result2 * 31 + Boolean.hashCode(this.allowPatches);
        result2 = result2 * 31 + Boolean.hashCode(this.submitExceptionsAutomatically);
        result2 = result2 * 31 + this.httpLoggingVerbosity.hashCode();
        result2 = result2 * 31 + this.apiKeyHeader.hashCode();
        result2 = result2 * 31 + (this.userSelectedSshExecutable == null ? 0 : this.userSelectedSshExecutable.hashCode());
        result2 = result2 * 31 + (this.logLevel == null ? 0 : this.logLevel.hashCode());
        result2 = result2 * 31 + (this.sshDynamicForwardingPortRange == null ? 0 : this.sshDynamicForwardingPortRange.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AdvancedSettings)) {
            return false;
        }
        AdvancedSettings advancedSettings = (AdvancedSettings)other;
        if (this.showInstalledBuild != advancedSettings.showInstalledBuild) {
            return false;
        }
        if (this.allowPatches != advancedSettings.allowPatches) {
            return false;
        }
        if (this.submitExceptionsAutomatically != advancedSettings.submitExceptionsAutomatically) {
            return false;
        }
        if (this.httpLoggingVerbosity != advancedSettings.httpLoggingVerbosity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.apiKeyHeader, (Object)advancedSettings.apiKeyHeader)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.userSelectedSshExecutable, (Object)advancedSettings.userSelectedSshExecutable)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.logLevel, (Object)advancedSettings.logLevel)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sshDynamicForwardingPortRange, (Object)advancedSettings.sshDynamicForwardingPortRange);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$settings_api(AdvancedSettings self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        if (output2.shouldEncodeElementDefault(serialDesc, 0) ? true : self.showInstalledBuild) {
            output2.encodeBooleanElement(serialDesc, 0, self.showInstalledBuild);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 1) ? true : !self.allowPatches) {
            output2.encodeBooleanElement(serialDesc, 1, self.allowPatches);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 2) ? true : !self.submitExceptionsAutomatically) {
            output2.encodeBooleanElement(serialDesc, 2, self.submitExceptionsAutomatically);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 3) ? true : self.httpLoggingVerbosity != HttpLoggingVerbosity.None) {
            output2.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)lazyArray[3].getValue(), (Object)self.httpLoggingVerbosity);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 4) ? true : !Intrinsics.areEqual((Object)self.apiKeyHeader, (Object)"")) {
            output2.encodeStringElement(serialDesc, 4, self.apiKeyHeader);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 5) ? true : self.userSelectedSshExecutable != null) {
            output2.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)SshExecutable$.serializer.INSTANCE, (Object)self.userSelectedSshExecutable);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 6) ? true : self.logLevel != null) {
            output2.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.logLevel);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 7) ? true : self.sshDynamicForwardingPortRange != null) {
            output2.encodeNullableSerializableElement(serialDesc, 7, (SerializationStrategy)PortRange$.serializer.INSTANCE, (Object)self.sshDynamicForwardingPortRange);
        }
    }

    public /* synthetic */ AdvancedSettings(int seen0, boolean showInstalledBuild, boolean allowPatches, boolean submitExceptionsAutomatically, HttpLoggingVerbosity httpLoggingVerbosity, String apiKeyHeader, SshExecutable userSelectedSshExecutable, String logLevel, PortRange sshDynamicForwardingPortRange, SerializationConstructorMarker serializationConstructorMarker) {
        if ((0 & seen0) != 0) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.showInstalledBuild = (seen0 & 1) == 0 ? false : showInstalledBuild;
        this.allowPatches = (seen0 & 2) == 0 ? true : allowPatches;
        this.submitExceptionsAutomatically = (seen0 & 4) == 0 ? true : submitExceptionsAutomatically;
        this.httpLoggingVerbosity = (seen0 & 8) == 0 ? HttpLoggingVerbosity.None : httpLoggingVerbosity;
        this.apiKeyHeader = (seen0 & 0x10) == 0 ? "" : apiKeyHeader;
        this.userSelectedSshExecutable = (seen0 & 0x20) == 0 ? null : userSelectedSshExecutable;
        this.logLevel = (seen0 & 0x40) == 0 ? null : logLevel;
        this.sshDynamicForwardingPortRange = (seen0 & 0x80) == 0 ? null : sshDynamicForwardingPortRange;
    }

    public AdvancedSettings() {
        this(false, false, false, null, null, null, null, null, 255, null);
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"com.jetbrains.toolbox.settings.HttpLoggingVerbosity", (Enum[])HttpLoggingVerbosity.values())), null, null, null, null};
        $childSerializers = lazyArray;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<AdvancedSettings> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

