/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.rpc;

import com.jetbrains.toolbox.rpc.TransportStatistics;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteToolboxProcess {
    @NotNull
    private final String address;
    @NotNull
    private final InputStream input;
    @NotNull
    private final OutputStream output;
    @NotNull
    private final StateFlow<TransportStatistics> transportStats;
    @NotNull
    private final BufferedReader reader;
    @NotNull
    private final BufferedWriter writer;

    public RemoteToolboxProcess(@NotNull String address, @NotNull InputStream input, @NotNull OutputStream output2, @NotNull StateFlow<TransportStatistics> transportStats) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        Intrinsics.checkNotNullParameter(transportStats, (String)"transportStats");
        this.address = address;
        this.input = input;
        this.output = output2;
        this.transportStats = transportStats;
        Closeable closeable = new InputStreamReader(this.input, Charsets.UTF_8);
        int n = 8192;
        this.reader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        closeable = new OutputStreamWriter(this.output, Charsets.UTF_8);
        n = 8192;
        this.writer = closeable instanceof BufferedWriter ? (BufferedWriter)closeable : new BufferedWriter((Writer)closeable, n);
    }

    @NotNull
    public final String getAddress() {
        return this.address;
    }

    @NotNull
    public final InputStream getInput() {
        return this.input;
    }

    @NotNull
    public final OutputStream getOutput() {
        return this.output;
    }

    @NotNull
    public final StateFlow<TransportStatistics> getTransportStats() {
        return this.transportStats;
    }

    @NotNull
    public final BufferedReader getReader() {
        return this.reader;
    }

    @NotNull
    public final BufferedWriter getWriter() {
        return this.writer;
    }

    @NotNull
    public final String component1() {
        return this.address;
    }

    @NotNull
    public final InputStream component2() {
        return this.input;
    }

    @NotNull
    public final OutputStream component3() {
        return this.output;
    }

    @NotNull
    public final StateFlow<TransportStatistics> component4() {
        return this.transportStats;
    }

    @NotNull
    public final RemoteToolboxProcess copy(@NotNull String address, @NotNull InputStream input, @NotNull OutputStream output2, @NotNull StateFlow<TransportStatistics> transportStats) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        Intrinsics.checkNotNullParameter(transportStats, (String)"transportStats");
        return new RemoteToolboxProcess(address, input, output2, transportStats);
    }

    public static /* synthetic */ RemoteToolboxProcess copy$default(RemoteToolboxProcess remoteToolboxProcess, String string, InputStream inputStream, OutputStream outputStream, StateFlow stateFlow, int n, Object object) {
        if ((n & 1) != 0) {
            string = remoteToolboxProcess.address;
        }
        if ((n & 2) != 0) {
            inputStream = remoteToolboxProcess.input;
        }
        if ((n & 4) != 0) {
            outputStream = remoteToolboxProcess.output;
        }
        if ((n & 8) != 0) {
            stateFlow = remoteToolboxProcess.transportStats;
        }
        return remoteToolboxProcess.copy(string, inputStream, outputStream, stateFlow);
    }

    @NotNull
    public String toString() {
        return "RemoteToolboxProcess(address=" + this.address + ", input=" + this.input + ", output=" + this.output + ", transportStats=" + this.transportStats + ")";
    }

    public int hashCode() {
        int result2 = this.address.hashCode();
        result2 = result2 * 31 + this.input.hashCode();
        result2 = result2 * 31 + this.output.hashCode();
        result2 = result2 * 31 + this.transportStats.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RemoteToolboxProcess)) {
            return false;
        }
        RemoteToolboxProcess remoteToolboxProcess = (RemoteToolboxProcess)other;
        if (!Intrinsics.areEqual((Object)this.address, (Object)remoteToolboxProcess.address)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.input, (Object)remoteToolboxProcess.input)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.output, (Object)remoteToolboxProcess.output)) {
            return false;
        }
        return Intrinsics.areEqual(this.transportStats, remoteToolboxProcess.transportStats);
    }
}

