/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.resharper;

import com.jetbrains.toolbox.platform.CpuArch;
import com.jetbrains.toolbox.resharper.DotNetToolExecutableNameResolver;
import com.jetbrains.toolbox.resharper.model.InstalledDotNetTool;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nDotNetToolExecutableNameResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetToolExecutableNameResolverImpl.kt\ncom/jetbrains/toolbox/resharper/DotNetToolExecutableNameResolverImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n1#2:30\n*E\n"})
public final class DotNetToolExecutableNameResolverImpl
implements DotNetToolExecutableNameResolver {
    @NotNull
    private final CpuArch cpuArch;
    @NotNull
    private final List<String> dotPeekNames;
    @NotNull
    private final List<String> dotMemoryNames;
    @NotNull
    private final List<String> dotTraceNames;
    @NotNull
    private final List<String> dotCoverNames;

    public DotNetToolExecutableNameResolverImpl(@NotNull CpuArch cpuArch) {
        Intrinsics.checkNotNullParameter((Object)((Object)cpuArch), (String)"cpuArch");
        this.cpuArch = cpuArch;
        Object[] objectArray = new String[]{this.arm64Only("dotPeek64a.exe"), "dotPeek64.exe"};
        this.dotPeekNames = CollectionsKt.listOfNotNull((Object[])objectArray);
        objectArray = new String[]{this.arm64Only("dotMemory.UI.64a.exe"), "dotMemory.UI.64.exe", "dotMemory64.exe"};
        this.dotMemoryNames = CollectionsKt.listOfNotNull((Object[])objectArray);
        objectArray = new String[]{this.arm64Only("dotTrace64a.exe"), "dotTrace64.exe"};
        this.dotTraceNames = CollectionsKt.listOfNotNull((Object[])objectArray);
        objectArray = new String[]{this.arm64Only("dotCover.UI.64a.exe"), "dotCover.UI.64.exe", "dotCover.Shell.exe"};
        this.dotCoverNames = CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final String arm64Only(String name2) {
        String string;
        String it = string = name2;
        boolean bl = false;
        return this.cpuArch == CpuArch.ARM64 ? string : null;
    }

    @Override
    @NotNull
    public Iterable<String> getExecutableNames(@NotNull InstalledDotNetTool.Type type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> this.dotPeekNames;
            case 2 -> this.dotMemoryNames;
            case 3 -> this.dotTraceNames;
            case 4 -> this.dotCoverNames;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InstalledDotNetTool.Type.values().length];
            try {
                nArray[InstalledDotNetTool.Type.DotPeek.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstalledDotNetTool.Type.DotMemory.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstalledDotNetTool.Type.DotTrace.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstalledDotNetTool.Type.DotCover.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

