/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.registrationWindows;

import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.interop.Win32Integration;
import com.jetbrains.toolbox.interop.Win32Registry;
import com.jetbrains.toolbox.registrationWindows.UtilKt;
import com.jetbrains.toolbox.registrationWindows.WindowsInstalledAppScanner;
import com.jetbrains.toolbox.registrationWindows.WindowsRegistrationChannelExtension;
import com.jetbrains.toolbox.registrationWindows.model.InstalledWindowsApp;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolUninstallHandler;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class WindowsRegistrationUninstallHandler
implements ToolUninstallHandler {
    @NotNull
    private final Win32Registry win32Registry;
    @NotNull
    private final ProcessRunner processRunner;
    @NotNull
    private final WindowsInstalledAppScanner installedAppScanner;
    @NotNull
    private final FileSystem fileSystem;

    public WindowsRegistrationUninstallHandler(@NotNull Win32Registry win32Registry, @NotNull ProcessRunner processRunner, @NotNull WindowsInstalledAppScanner installedAppScanner, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)win32Registry, (String)"win32Registry");
        Intrinsics.checkNotNullParameter((Object)processRunner, (String)"processRunner");
        Intrinsics.checkNotNullParameter((Object)installedAppScanner, (String)"installedAppScanner");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.win32Registry = win32Registry;
        this.processRunner = processRunner;
        this.installedAppScanner = installedAppScanner;
        this.fileSystem = fileSystem;
    }

    @Override
    @Nullable
    public Object onUninstall(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super UninstallResult> $completion) {
        WindowsRegistrationChannelExtension windowsRegistrationChannelExtension = UtilKt.getWindowsRegistrationExtension(toolInstance.getChannel());
        if (windowsRegistrationChannelExtension == null) {
            return UninstallResult.NotSupported.INSTANCE;
        }
        WindowsRegistrationChannelExtension extension2 = windowsRegistrationChannelExtension;
        if (!extension2.getManagedByToolbox()) {
            Path installDir = toolInstance.getChannel().getInstallationDirectory();
            Object object = this.installedAppScanner.findApp(installDir);
            if (object == null || (object = ((InstalledWindowsApp)object).getUninstallString()) == null) {
                object = extension2.getUninstallString();
            }
            Object uninstallString = object;
            Logger.INSTANCE.debug("UninstallString=`" + (String)uninstallString + "`");
            if (uninstallString != null) {
                List<String> uninstallerCommandLine = StringsKt.startsWith$default((CharSequence)((CharSequence)uninstallString), (char)'\"', (boolean)false, (int)2, null) ? Win32Integration.INSTANCE.convertStringToArgList((String)uninstallString) : CollectionsKt.listOf((Object)uninstallString);
                Path uninstallerExecutable = Path.Companion.get$default((Path.Companion)Path.Companion, (String)((String)CollectionsKt.first(uninstallerCommandLine)), (boolean)false, (int)1, null);
                List uninstallerArguments = CollectionsKt.drop((Iterable)uninstallerCommandLine, (int)1);
                boolean fileExists = this.fileSystem.exists(uninstallerExecutable);
                Logger.INSTANCE.debug("executable=`" + uninstallerExecutable + "`, arguments=" + uninstallerArguments + ", fileExists=" + fileExists);
                if (fileExists) {
                    return this.runUninstaller(uninstallerExecutable, uninstallerArguments, installDir);
                }
            }
            return !this.fileSystem.exists(installDir) ? (UninstallResult)UninstallResult.NotSupported.INSTANCE : (UninstallResult)UninstallResult.UninstallerUnavailable.INSTANCE;
        }
        this.win32Registry.deleteKeyRecursively(Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + extension2.getUninstallId());
        return UninstallResult.Success.INSTANCE;
    }

    private final UninstallResult runUninstaller(Path uninstallerExecutable, List<String> uninstallerArguments, Path installationDirectory) {
        UninstallResult uninstallResult;
        try {
            ProcessRunner.executeProcessAndWait-9VgGkz4$default(this.processRunner, uninstallerExecutable.toFile(), uninstallerArguments, null, null, 0L, 28, null);
            uninstallResult = UninstallResult.UninstallerStarted.INSTANCE;
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to uninstall '" + installationDirectory + "'");
            Object object = t2.getMessage();
            if (object == null) {
                object = Reflection.getOrCreateKotlinClass(t2.getClass()).getSimpleName() + " with an unknown reason";
            }
            uninstallResult = new UninstallResult.UninstallerProcessFailure((String)object);
        }
        return uninstallResult;
    }
}

