/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.project.intellij;

import com.jetbrains.toolbox.OSKt;
import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.FileExtension;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.IntelliJBuildProperties;
import com.jetbrains.toolbox.feed.IntelliJToolProperties;
import com.jetbrains.toolbox.intellij.IntellijDirectoriesPathResolver;
import com.jetbrains.toolbox.platform.image.ImageType;
import com.jetbrains.toolbox.platform.image.internal.ImageId;
import com.jetbrains.toolbox.project.AvailableToolProjectSource;
import com.jetbrains.toolbox.project.DetectedProject;
import com.jetbrains.toolbox.project.FileSystemProject;
import com.jetbrains.toolbox.project.IconSet;
import com.jetbrains.toolbox.project.InstalledToolProjectSource;
import com.jetbrains.toolbox.project.intellij.IntelliJProjectScanner;
import com.jetbrains.toolbox.project.intellij.RecentProjectsFile;
import com.jetbrains.toolbox.project.intellij.RecentProjectsTool;
import com.jetbrains.toolbox.tools.image.ImageManager;
import com.jetbrains.toolbox.tools.image.UtilKt;
import com.jetbrains.toolbox.tools.model.AvailableBuild;
import com.jetbrains.toolbox.tools.model.AvailableTool;
import com.jetbrains.toolbox.tools.model.AvailableVersion;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ChannelStateKt;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ProjectId;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolWithVersions;
import com.jetbrains.toolbox.tools.model.VersionWithBuilds;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.ExceptionsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.datetime.Instant;
import okio.BufferedSource;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nIntelliJProjectScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJProjectScanner.kt\ncom/jetbrains/toolbox/project/intellij/IntelliJProjectScanner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Okio.kt\nokio/Okio__OkioKt\n+ 6 FileSystem.kt\nokio/FileSystem\n*L\n1#1,331:1\n1#2:332\n1#2:343\n136#3,9:333\n216#3:342\n217#3:344\n145#3:345\n1563#4:346\n1634#4,3:347\n1869#4:373\n1374#4:374\n1460#4,5:375\n1869#4,2:380\n1869#4,2:382\n1870#4:384\n1563#4:408\n1634#4,3:409\n808#4,11:412\n295#4,2:423\n66#5:350\n52#5,4:352\n60#5,10:357\n56#5,3:367\n71#5,3:370\n66#5:385\n52#5,4:387\n60#5,10:392\n56#5,3:402\n71#5,3:405\n67#6:351\n68#6:356\n67#6:386\n68#6:391\n*S KotlinDebug\n*F\n+ 1 IntelliJProjectScanner.kt\ncom/jetbrains/toolbox/project/intellij/IntelliJProjectScanner\n*L\n113#1:343\n113#1:333,9\n113#1:342\n113#1:344\n113#1:345\n172#1:346\n172#1:347,3\n247#1:373\n252#1:374\n252#1:375,5\n253#1:380,2\n268#1:382,2\n247#1:384\n294#1:408\n294#1:409,3\n294#1:412,11\n299#1:423,2\n229#1:350\n229#1:352,4\n229#1:357,10\n229#1:367,3\n229#1:370,3\n283#1:385\n283#1:387,4\n283#1:392,10\n283#1:402,3\n283#1:405,3\n229#1:351\n229#1:356\n283#1:386\n283#1:391\n*E\n"})
public final class IntelliJProjectScanner {
    @NotNull
    private final IntellijDirectoriesPathResolver intellijDirectoriesPathResolver;
    @NotNull
    private final ImageManager imageManager;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final OS.Type os;
    private final DocumentBuilderFactory docFactory;
    @NotNull
    private final Regex WSL_PATH_REGEX;
    private final long CANONICALIZATION_TIMEOUT;

    public IntelliJProjectScanner(@NotNull IntellijDirectoriesPathResolver intellijDirectoriesPathResolver, @NotNull ImageManager imageManager, @NotNull FileSystem fileSystem, @NotNull OS.Type os) {
        Intrinsics.checkNotNullParameter((Object)intellijDirectoriesPathResolver, (String)"intellijDirectoriesPathResolver");
        Intrinsics.checkNotNullParameter((Object)imageManager, (String)"imageManager");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        this.intellijDirectoriesPathResolver = intellijDirectoriesPathResolver;
        this.imageManager = imageManager;
        this.fileSystem = fileSystem;
        this.os = os;
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.WSL_PATH_REGEX = new Regex("^//(wsl\\$|wsl\\.[^/]*)/(.*)$");
        this.CANONICALIZATION_TIMEOUT = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
    }

    private static /* synthetic */ void getWSL_PATH_REGEX$annotations() {
    }

    private static /* synthetic */ void getCANONICALIZATION_TIMEOUT-UwyO8pc$annotations() {
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getRecentProjectsFiles$project_intellij(@NotNull Map<ChannelId, ? extends ChannelState> model, @NotNull Map<ApplicationType, ToolWithVersions> availableTools, @NotNull Continuation<? super Collection<RecentProjectsFile>> $completion) {
        if (!($completion instanceof getRecentProjectsFiles.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ IntelliJProjectScanner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getRecentProjectsFiles$project_intellij(null, null, (Continuation<? super Collection<RecentProjectsFile>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)model);
                $continuation.L$1 = availableTools;
                $continuation.label = 1;
                v0 = this.getRecentProjectsFilesForInstalledTools(model, availableTools, (Continuation<? super Set<RecentProjectsFile>>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                availableTools = (Map)$continuation.L$1;
                model = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                return SetsKt.plus((Set)((Set)v0), (Iterable)this.getRecentProjectFilesForAvailableTools(availableTools));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getRecentProjectsFilesForInstalledTools(Map<ChannelId, ? extends ChannelState> model, Map<ApplicationType, ToolWithVersions> availableTools, Continuation<? super Set<RecentProjectsFile>> $completion) {
        if (!($completion instanceof getRecentProjectsFilesForInstalledTools.1)) ** GOTO lbl-1000
        var22_4 = $completion;
        if ((var22_4.label & -2147483648) != 0) {
            var22_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ IntelliJProjectScanner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IntelliJProjectScanner.access$getRecentProjectsFilesForInstalledTools(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var23_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$getRecentProjectsFilesForInstalledTools_u24lambda_u240 = var4_7 = SetsKt.createSetBuilder();
                $i$a$-buildSet-IntelliJProjectScanner$getRecentProjectsFilesForInstalledTools$2 = 0;
                var7_10 = model.entrySet().iterator();
lbl15:
                // 5 sources

                while (var7_10.hasNext()) {
                    var8_11 = var7_10.next();
                    channelId = var8_11.getKey().unbox-impl();
                    channelState = var8_11.getValue();
                    var11_14 = channelState.getTool();
                    if ((var11_14 instanceof InstalledTool != false ? (InstalledTool)var11_14 : null) == null) continue;
                    tool = tool;
                    if (ChannelStateKt.toToolInstanceOrNull(channelState) == null) continue;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)model);
                    $continuation.L$1 = availableTools;
                    $continuation.L$2 = var4_7;
                    $continuation.L$3 = $this$getRecentProjectsFilesForInstalledTools_u24lambda_u240;
                    $continuation.L$4 = var7_10;
                    $continuation.L$5 = channelId;
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)channelState);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)toolInstance);
                    $continuation.L$8 = tool;
                    $continuation.I$0 = $i$a$-buildSet-IntelliJProjectScanner$getRecentProjectsFilesForInstalledTools$2;
                    $continuation.label = 1;
                    v0 = this.intellijDirectoriesPathResolver.resolveConfigurationDirectoryPath(toolInstance, (Continuation<? super Path>)$continuation);
                    if (v0 == var23_6) {
                        return var23_6;
                    }
                    ** GOTO lbl52
                }
                break;
            }
            case 1: {
                $i$a$-buildSet-IntelliJProjectScanner$getRecentProjectsFilesForInstalledTools$2 = $continuation.I$0;
                tool = (InstalledTool)$continuation.L$8;
                toolInstance = (ToolInstance)$continuation.L$7;
                channelState = (ChannelState)$continuation.L$6;
                channelId = (String)$continuation.L$5;
                var7_10 = (Iterator)$continuation.L$4;
                $this$getRecentProjectsFilesForInstalledTools_u24lambda_u240 = (Set)$continuation.L$3;
                var4_7 = (Set)$continuation.L$2;
                availableTools = (Map)$continuation.L$1;
                model = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl52:
                // 2 sources

                if ((Path)v0 == null || (v1 = (ToolWithVersions)availableTools.get(ApplicationType.box-impl(toolId = tool.getToolId-UtVBrGo()))) == null || (v1 = v1.getTool()) == null || (v1 = v1.getIntelliJProperties()) == null) ** GOTO lbl15
                intelliJProperties = v1;
                it = var17_20 = intelliJProperties.getRecentProjectsFilenames();
                $i$a$-takeIf-IntelliJProjectScanner$getRecentProjectsFilesForInstalledTools$2$filenames$1 = false;
                v2 = !((Collection)it).isEmpty() != false ? var17_20 : null;
                if (v2 == null) {
                    v2 = SetsKt.setOf((Object)"recentProjects.xml");
                }
                filenames = v2;
                for (String filename : filenames) {
                    $this$getRecentProjectsFilesForInstalledTools_u24lambda_u240.add(new RecentProjectsFile(configDirectory.resolve("options").resolve(filename).normalized(), new RecentProjectsTool.Installed(toolId, channelId, null)));
                }
                ** GOTO lbl15
            }
        }
        return SetsKt.build((Set)var4_7);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Set<RecentProjectsFile> getRecentProjectFilesForAvailableTools(Map<ApplicationType, ToolWithVersions> availableTools2) {
        Set set;
        Set $this$getRecentProjectFilesForAvailableTools_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (ToolWithVersions toolWithVersions : availableTools2.values()) {
            IntelliJToolProperties intelliJToolProperties;
            Set set2;
            AvailableTool tool = toolWithVersions.getTool();
            if (tool.getIntelliJProperties() == null) continue;
            Set it = set2 = intelliJToolProperties.getRecentProjectsFilenames();
            boolean bl2 = false;
            Set set3 = !((Collection)$this$getRecentProjectFilesForAvailableTools_u24lambda_u240).isEmpty() ? set2 : null;
            if (set3 == null) {
                set3 = SetsKt.setOf((Object)"recentProjects.xml");
            }
            Set recentProjectFilenames = set3;
            for (VersionWithBuilds versionWithBuilds : toolWithVersions.getVersions()) {
                Path configDirectory;
                IntelliJBuildProperties intelliJBuildProperties;
                Path path2;
                AvailableVersion version = versionWithBuilds.getVersion();
                AvailableBuild build2 = versionWithBuilds.getLatestBuild();
                if (build2.getIntelliJProperties() == null) continue;
                Path it2 = path2 = OSKt.getExpanded-WIZC_Bo(intelliJBuildProperties.getDefaultConfigDirectories().getConfig-6QkRYPI());
                boolean bl3 = false;
                if ((!StringsKt.isBlank((CharSequence)it2.toString()) ? path2 : null) == null) continue;
                configDirectory = configDirectory;
                for (String filename : recentProjectFilenames) {
                    $this$getRecentProjectFilesForAvailableTools_u24lambda_u240.add(new RecentProjectsFile(configDirectory.resolve("options").resolve(filename).normalized(), new RecentProjectsTool.Available(tool.getApplicationType-UtVBrGo(), version.getMajorVersion().getName(), null)));
                }
            }
        }
        return SetsKt.build((Set)set);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object detectProjectsFromFile$project_intellij(@NotNull Path recentProjects, @NotNull Collection<? extends RecentProjectsTool> sources, @NotNull Continuation<? super Collection<DetectedProject>> $completion) {
        if (!($completion instanceof detectProjectsFromFile.1)) ** GOTO lbl-1000
        var25_4 = $completion;
        if ((var25_4.label & -2147483648) != 0) {
            var25_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                /* synthetic */ Object result;
                final /* synthetic */ IntelliJProjectScanner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.detectProjectsFromFile$project_intellij(null, null, (Continuation<? super Collection<DetectedProject>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var26_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                projectList = this.getProjectList(recentProjects);
                if (projectList.isEmpty()) {
                    return SetsKt.emptySet();
                }
                Logger.INSTANCE.info("Detecting IntelliJ projects from '" + recentProjects + "'");
                $this$mapNotNull$iv = projectList;
                $i$f$mapNotNull = 0;
                var7_10 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = 0;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = 0;
                var12_15 = $this$forEach$iv$iv$iv.entrySet().iterator();
lbl24:
                // 3 sources

                while (var12_15.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = (Map.Entry)var12_15.next();
                    $i$a$-forEach-MapsKt___MapsKt$mapNotNullTo$1$iv$iv = 0;
                    var16_19 = element$iv$iv;
                    $i$a$-mapNotNull-IntelliJProjectScanner$detectProjectsFromFile$2 = 0;
                    projectPath = (String)var16_19.getKey();
                    metaInfo = (NodeList)var16_19.getValue();
                    $continuation.L$0 = recentProjects;
                    $continuation.L$1 = sources;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)projectList);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$mapNotNull$iv);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$mapNotNullTo$iv$iv);
                    $continuation.L$5 = destination$iv$iv;
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv$iv$iv);
                    $continuation.L$7 = var12_15;
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv$iv);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv);
                    $continuation.L$10 = projectPath;
                    $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)metaInfo);
                    $continuation.I$0 = $i$f$mapNotNull;
                    $continuation.I$1 = $i$f$mapNotNullTo;
                    $continuation.I$2 = $i$f$forEach;
                    $continuation.I$3 = $i$a$-forEach-MapsKt___MapsKt$mapNotNullTo$1$iv$iv;
                    $continuation.I$4 = $i$a$-mapNotNull-IntelliJProjectScanner$detectProjectsFromFile$2;
                    $continuation.label = 1;
                    v0 = this.detectProject(projectPath, recentProjects, metaInfo, sources, (Continuation<? super DetectedProject>)$continuation);
                    ** if (v0 != var26_6) goto lbl54
lbl53:
                    // 1 sources

                    return var26_6;
lbl54:
                    // 1 sources

                    ** GOTO lbl78
                }
                break;
            }
            case 1: {
                $i$a$-mapNotNull-IntelliJProjectScanner$detectProjectsFromFile$2 = $continuation.I$4;
                $i$a$-forEach-MapsKt___MapsKt$mapNotNullTo$1$iv$iv = $continuation.I$3;
                $i$f$forEach = $continuation.I$2;
                $i$f$mapNotNullTo = $continuation.I$1;
                $i$f$mapNotNull = $continuation.I$0;
                metaInfo = (NodeList)$continuation.L$11;
                projectPath = (String)$continuation.L$10;
                element$iv$iv = (Map.Entry)$continuation.L$9;
                element$iv$iv$iv = (Map.Entry)$continuation.L$8;
                var12_15 = (Iterator)$continuation.L$7;
                $this$forEach$iv$iv$iv = (Map)$continuation.L$6;
                destination$iv$iv = (Collection)$continuation.L$5;
                $this$mapNotNullTo$iv$iv = (Map)$continuation.L$4;
                $this$mapNotNull$iv = (Map)$continuation.L$3;
                projectList = (Map)$continuation.L$2;
                sources = (Collection)$continuation.L$1;
                recentProjects = (Path)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl78:
                    // 2 sources

                    var20_23 = (DetectedProject)v0;
                }
                catch (NoSuchFileException <unused var>) {
                    var20_23 = null;
                }
                catch (CancellationException ce) {
                    throw ce;
                }
                catch (Exception e) {
                    Logger.INSTANCE.warn((Throwable)e, "Failed to process project " + projectPath);
                    var20_23 = null;
                }
                if (var20_23 == null) ** GOTO lbl24
                $i$a$-let-MapsKt___MapsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
                ** GOTO lbl24
            }
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object detectProject(String project, Path path, NodeList metaInfo, Collection<? extends RecentProjectsTool> sources, Continuation<? super DetectedProject> $completion) {
        if (!($completion instanceof detectProject.1)) ** GOTO lbl-1000
        var25_6 = $completion;
        if ((var25_6.label & -2147483648) != 0) {
            var25_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                /* synthetic */ Object result;
                final /* synthetic */ IntelliJProjectScanner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IntelliJProjectScanner.access$detectProject(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var28_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    projectFile = new Ref.ObjectRef();
                    projectFile.element = this.getFullPath(project, path);
                    try {
                        $continuation.L$0 = project;
                        $continuation.L$1 = path;
                        $continuation.L$2 = metaInfo;
                        $continuation.L$3 = sources;
                        $continuation.L$4 = projectFile;
                        $continuation.label = 1;
                        v0 = TimeoutKt.withTimeout-KLykuaI((long)this.CANONICALIZATION_TIMEOUT, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<Path>)projectFile, this, null){
                            int label;
                            final /* synthetic */ Ref.ObjectRef<Path> $projectFile;
                            final /* synthetic */ IntelliJProjectScanner this$0;
                            {
                                this.$projectFile = $projectFile;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = InterruptibleKt.runInterruptible$default(null, () -> detectProject.2.invokeSuspend$lambda$0(this.$projectFile, this.this$0), (Continuation)((Continuation)this), (int)1, null);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Unit invokeSuspend$lambda$0(Ref.ObjectRef $projectFile, IntelliJProjectScanner this$0) {
                                $projectFile.element = IntelliJProjectScanner.access$getFileSystem$p(this$0).canonicalize((Path)$projectFile.element);
                                return Unit.INSTANCE;
                            }
                        }), (Continuation)$continuation);
                    }
                    catch (FileNotFoundException <unused var>) {
                        Logger.INSTANCE.debug("Failed to canonicalize '" + projectFile.element + "' because it doesn't exist, generating project stub");
                        ** GOTO lbl53
                    }
                    catch (IOException e) {
                        Logger.INSTANCE.warn("Failed to canonicalize '" + projectFile.element + "': " + e);
                        return null;
                    }
                    catch (TimeoutCancellationException <unused var>) {
                        Logger.INSTANCE.warn("Failed to canonicalize '" + projectFile.element + "' in " + Duration.toString-impl((long)this.CANONICALIZATION_TIMEOUT));
                        return null;
                    }
                }
                catch (CancellationException ce) {
                    throw ce;
                }
                catch (Exception e) {
                    Logger.INSTANCE.debug((Throwable)e, "Couldn't process " + project);
                    return null;
                }
                v1 = v0;
                if (v0 == var28_8) {
                    return var28_8;
                }
                ** GOTO lbl53
            }
            case 1: {
                projectFile = (Ref.ObjectRef)$continuation.L$4;
                sources = (Collection)$continuation.L$3;
                metaInfo = (NodeList)$continuation.L$2;
                path = (Path)$continuation.L$1;
                project = (String)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
lbl53:
                // 3 sources

                projectFile.element = ((Path)projectFile.element).normalized();
                dotIdea = this.getDotIdeaFile((Path)projectFile.element);
                v2 = this.fileSystem.metadataOrNull((Path)projectFile.element);
                if (!(v2 != null ? v2.isRegularFile() : false) && !this.fileSystem.exists(dotIdea) && ((var8_16 = (Collection)this.fileSystem.listOrNull((Path)projectFile.element)) == null || var8_16.isEmpty() != false)) {
                    Logger.INSTANCE.info(project + " is empty " + projectFile.element + " " + dotIdea.normalized());
                }
                if ((lastModified = this.getProjectLastModifiedTime(dotIdea, metaInfo, (Path)projectFile.element)) == null) {
                    it = var9_17 = null;
                    $i$a$-also-IntelliJProjectScanner$detectProject$5 = false;
                    Logger.INSTANCE.info("Cannot detect last modified time for " + project);
                    return var9_17;
                }
                name = this.getProjectName((Path)projectFile.element, dotIdea);
                $continuation.L$0 = project;
                $continuation.L$1 = path;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)metaInfo);
                $continuation.L$3 = sources;
                $continuation.L$4 = projectFile;
                $continuation.L$5 = dotIdea;
                $continuation.L$6 = lastModified;
                $continuation.L$7 = name;
                $continuation.label = 2;
                v3 = this.readIconWithPriority-lK-al4Y("icon", dotIdea, (Continuation<? super ImageId>)$continuation);
                if (v3 == var28_8) {
                    return var28_8;
                }
                ** GOTO lbl90
            }
            case 2: {
                name = (String)$continuation.L$7;
                lastModified = (Instant)$continuation.L$6;
                dotIdea = (Path)$continuation.L$5;
                projectFile = (Ref.ObjectRef)$continuation.L$4;
                sources = (Collection)$continuation.L$3;
                metaInfo = (NodeList)$continuation.L$2;
                path = (Path)$continuation.L$1;
                project = (String)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = (ImageId)$result;
                    v3 = v4 != null ? v4.unbox-impl() : null;
lbl90:
                    // 2 sources

                    lightIcon = v3;
                    $continuation.L$0 = project;
                    $continuation.L$1 = path;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)metaInfo);
                    $continuation.L$3 = sources;
                    $continuation.L$4 = projectFile;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)dotIdea);
                    $continuation.L$6 = lastModified;
                    $continuation.L$7 = name;
                    $continuation.L$8 = lightIcon;
                    $continuation.label = 3;
                    v5 = this.readIconWithPriority-lK-al4Y("icon_dark", dotIdea, (Continuation<? super ImageId>)$continuation);
                    ** if (v5 != var28_8) goto lbl104
                }
lbl103:
                // 1 sources

                return var28_8;
lbl104:
                // 1 sources

                ** GOTO lbl119
            }
            case 3: {
                lightIcon = (String)$continuation.L$8;
                name = (String)$continuation.L$7;
                lastModified = (Instant)$continuation.L$6;
                dotIdea = (Path)$continuation.L$5;
                projectFile = (Ref.ObjectRef)$continuation.L$4;
                sources = (Collection)$continuation.L$3;
                metaInfo = (NodeList)$continuation.L$2;
                path = (Path)$continuation.L$1;
                project = (String)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = (ImageId)$result;
                    v5 = v6 != null ? v6.unbox-impl() : null;
lbl119:
                    // 2 sources

                    darkIcon = v5;
                    var12_23 = ProjectId.constructor-impl(((Path)projectFile.element).toString());
                    var13_24 = (Path)projectFile.element;
                    var14_26 = new IconSet(lightIcon, darkIcon, null);
                    var15_27 = lastModified;
                    v7 = new FileSystemProject((String)var12_23, name, var14_26, var13_24, null, var15_27, false, 64, null);
                    var12_23 = sources;
                    var22_28 = v7;
                    $i$f$map = false;
                    var14_26 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    var17_30 = $this$mapTo$iv$iv.iterator();
                    while (true) {
                        if (!var17_30.hasNext()) {
                            var26_36 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                            var27_37 = var22_28;
                            return new DetectedProject(var27_37, var26_36);
                        }
                        item$iv$iv = var17_30.next();
                        var19_32 = (RecentProjectsTool)item$iv$iv;
                        var23_35 = destination$iv$iv;
                        $i$a$-map-IntelliJProjectScanner$detectProject$6 = false;
                        var21_34 = it;
                        if (var21_34 instanceof RecentProjectsTool.Installed) {
                            v8 = new InstalledToolProjectSource(lastModified, ((RecentProjectsTool.Installed)it).getToolId-UtVBrGo(), path, ((RecentProjectsTool.Installed)it).getChannelId-5CZByfs(), null);
                        } else {
                            if (var21_34 instanceof RecentProjectsTool.Available == false) throw new NoWhenBranchMatchedException();
                            v8 = new AvailableToolProjectSource(lastModified, ((RecentProjectsTool.Available)it).getToolId-UtVBrGo(), path, ((RecentProjectsTool.Available)it).getMajorVersion(), null);
                        }
                        var23_35.add(v8);
                    }
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final Path getFullPath(String project2, Path path2) {
        void it;
        String string = StringsKt.replace$default((String)project2, (String)"$USER_HOME$", (String)StandardPaths.INSTANCE.getHome().toString(), (boolean)false, (int)4, null);
        Path path3 = path2.parent();
        Intrinsics.checkNotNull((Object)path3);
        Path path4 = path3.parent();
        Intrinsics.checkNotNull((Object)path4);
        String string2 = StringsKt.replace$default((String)string, (String)"$APPLICATION_CONFIG_DIR$", (String)this.fileSystem.canonicalize(path4).toString(), (boolean)false, (int)4, null);
        Path.Companion companion = Path.Companion;
        boolean bl = false;
        return Path.Companion.get$default((Path.Companion)companion, (String)(this.os == OS.Type.Windows ? this.tryConvertWslPath$project_intellij((String)it) : string2), (boolean)false, (int)1, null);
    }

    @NotNull
    public final String tryConvertWslPath$project_intellij(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        MatchResult matchResult = this.WSL_PATH_REGEX.matchEntire((CharSequence)path2);
        if (matchResult != null) {
            String wslDomain = (String)CollectionsKt.getOrNull((List)matchResult.getGroupValues(), (int)1);
            String wslPath = (String)CollectionsKt.getOrNull((List)matchResult.getGroupValues(), (int)2);
            if (wslDomain != null && wslPath != null) {
                return "\\\\" + wslDomain + "\\" + wslPath;
            }
            Logger.INSTANCE.warn("Couldn't parse WSL path '" + path2 + "', domain='" + wslDomain + "', path='" + wslPath + "'");
        }
        return path2;
    }

    private final Instant getProjectLastModifiedTime(Path dotIdea, NodeList metaInfo, Path projectFile) {
        NodeList nodeList = metaInfo;
        if (nodeList != null) {
            NodeList info = nodeList;
            boolean bl = false;
            Instant instant = this.getProjectLastModifiedTimeFromMetaInfo(info);
            if (instant != null) {
                Instant it = instant;
                boolean bl2 = false;
                return it;
            }
        }
        Path workspace = dotIdea.resolve("workspace.xml");
        if (!this.fileSystem.exists(workspace)) {
            Instant instant;
            FileMetadata fileMetadata2 = this.fileSystem.metadataOrNull(projectFile);
            if (fileMetadata2 == null) {
                return null;
            }
            FileMetadata metadata2 = fileMetadata2;
            if (metadata2.isRegularFile()) {
                Long l = metadata2.getLastModifiedAtMillis();
                if (l == null) {
                    return null;
                }
                instant = Instant.Companion.fromEpochMilliseconds(l.longValue());
            } else {
                instant = null;
            }
            return instant;
        }
        Object object = this.fileSystem.metadataOrNull(workspace);
        if (object == null || (object = object.getLastModifiedAtMillis()) == null) {
            return null;
        }
        return Instant.Companion.fromEpochMilliseconds(((Long)object).longValue());
    }

    private final Path getDotIdeaFile(Path projectFile) {
        Path path2;
        FileMetadata fileMetadata2 = this.fileSystem.metadataOrNull(projectFile);
        boolean bl = fileMetadata2 != null ? fileMetadata2.isDirectory() : false;
        if (bl) {
            path2 = projectFile;
        } else {
            Path path3 = projectFile.parent();
            path2 = path3;
            Intrinsics.checkNotNull((Object)path3);
        }
        return path2.resolve(".idea");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String getProjectName(Path projectFile, Path dotIdea) {
        String string;
        Path nameFile = dotIdea.resolve(".name");
        if (this.fileSystem.exists(nameFile)) {
            String string2;
            Throwable thrown$iv$iv;
            block16: {
                void this_$iv;
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = nameFile;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$getProjectName_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    string2 = ((Object)StringsKt.trim((CharSequence)$this$getProjectName_u24lambda_u240.readUtf8())).toString();
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        string2 = null;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block17: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block17;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            String result$iv$iv = string2;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) return result$iv$iv;
            throw throwable;
        }
        FileMetadata fileMetadata2 = this.fileSystem.metadataOrNull(projectFile);
        boolean bl = fileMetadata2 != null ? fileMetadata2.isDirectory() : false;
        if (bl) {
            string = projectFile.name();
            return string;
        }
        string = StringsKt.substringBeforeLast$default((String)projectFile.name(), (String)".", null, (int)2, null);
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final Object readIconWithPriority-lK-al4Y(String name, Path dotIdea, Continuation<? super ImageId> $completion) {
        block8: {
            if (!($completion instanceof readIconWithPriority.1)) ** GOTO lbl-1000
            var8_4 = $completion;
            if ((var8_4.label & -2147483648) != 0) {
                var8_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ IntelliJProjectScanner this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        Object object = IntelliJProjectScanner.access$readIconWithPriority-lK-al4Y(this.this$0, null, null, (Continuation)this);
                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return object;
                        }
                        String string = (String)object;
                        return string != null ? ImageId.box-impl((String)string) : null;
                    }
                };
            }
            $result = $continuation.result;
            var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var4_7 = ((Iterable)ImageType.getEntries()).iterator();
lbl13:
                    // 2 sources

                    while (var4_7.hasNext()) {
                        format = (ImageType)var4_7.next();
                        $i$a$-firstNotNullOfOrNull-IntelliJProjectScanner$readIconWithPriority$2 = 0;
                        $continuation.L$0 = name;
                        $continuation.L$1 = dotIdea;
                        $continuation.L$2 = var4_7;
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)format);
                        $continuation.I$0 = $i$a$-firstNotNullOfOrNull-IntelliJProjectScanner$readIconWithPriority$2;
                        $continuation.label = 1;
                        v0 = ImageManager.convert-lK-al4Y$default(this.imageManager, dotIdea.resolve(FileExtension.appendTo-impl(UtilKt.getFileExtension(format), name)), false, (Continuation)$continuation, 2, null);
                        if (v0 == var9_6) {
                            return var9_6;
                        }
                        ** GOTO lbl36
                    }
                    break;
                }
                case 1: {
                    $i$a$-firstNotNullOfOrNull-IntelliJProjectScanner$readIconWithPriority$2 = $continuation.I$0;
                    format = (ImageType)$continuation.L$3;
                    var4_7 = (Iterator)$continuation.L$2;
                    dotIdea = (Path)$continuation.L$1;
                    name = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = (ImageId)$result;
                    v0 = v1 != null ? v1.unbox-impl() : null;
lbl36:
                    // 2 sources

                    if ((var5_8 = v0 != null ? ImageId.box-impl((String)v0) : null) == null) ** GOTO lbl13
                    v2 = var5_8;
                    break block8;
                }
            }
            v2 = null;
        }
        return v2 != null ? v2.unbox-impl() : null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, NodeList> getProjectList(Path file) {
        void $this$forEach$iv;
        Document document = this.loadXML(file);
        if (document == null) {
            return MapsKt.emptyMap();
        }
        Document document2 = document;
        Map projectsList2 = new LinkedHashMap();
        NodeList options = document2.getElementsByTagName("option");
        Intrinsics.checkNotNull((Object)options);
        Iterable iterable = this.filterItems(options);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object $this$flatMapTo$iv$iv;
            Element option = (Element)element$iv;
            boolean bl = false;
            String string = option.getAttribute("name");
            if (Intrinsics.areEqual((Object)string, (Object)"additionalInfo")) {
                void $this$forEach$iv2;
                Object element$iv$iv;
                Iterable $this$flatMap$iv;
                NodeList nodeList = option.getElementsByTagName("map");
                Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
                Iterable iterable2 = this.filterItems(nodeList);
                boolean $i$f$flatMap = false;
                void var14_16 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    Element map2 = (Element)element$iv$iv;
                    boolean bl2 = false;
                    NodeList nodeList2 = map2.getElementsByTagName("entry");
                    Intrinsics.checkNotNullExpressionValue((Object)nodeList2, (String)"getElementsByTagName(...)");
                    Iterable list$iv$iv = this.filterItems(nodeList2);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                $this$flatMapTo$iv$iv = $this$forEach$iv2.iterator();
                while ($this$flatMapTo$iv$iv.hasNext()) {
                    Object element$iv2 = $this$flatMapTo$iv$iv.next();
                    Element entry = (Element)element$iv2;
                    boolean bl3 = false;
                    Node node2 = entry.getElementsByTagName("value").item(0);
                    Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                    element$iv$iv = ((Element)node2).getElementsByTagName("RecentProjectMetaInfo").item(0);
                    Intrinsics.checkNotNull(element$iv$iv, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                    Object it = element$iv$iv = (Element)element$iv$iv;
                    boolean bl4 = false;
                    Object object = !Intrinsics.areEqual((Object)it.getAttribute("hidden"), (Object)"true") ? element$iv$iv : null;
                    NodeList metaInfo = object != null ? object.getElementsByTagName("option") : null;
                    if (metaInfo == null) continue;
                    String string2 = entry.getAttribute("key");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttribute(...)");
                    projectsList2.put(string2, metaInfo);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"recentPaths")) continue;
            try {
                void $this$forEach$iv3;
                Node node3 = option.getElementsByTagName("list").item(0);
                Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element list2 = (Element)node3;
                NodeList pathOptions = list2.getChildNodes();
                Intrinsics.checkNotNull((Object)pathOptions);
                $this$flatMapTo$iv$iv = this.filterItems(pathOptions);
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Element pathOption = (Element)element$iv3;
                    boolean bl5 = false;
                    projectsList2.putIfAbsent(pathOption.getAttribute("value"), null);
                }
            }
            catch (Exception e) {
                Logger.INSTANCE.info((Throwable)e);
            }
        }
        return projectsList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Document loadXML(Path file) {
        try {
            Document document;
            Throwable thrown$iv$iv;
            block17: {
                void this_$iv;
                if (!this.fileSystem.exists(file)) return null;
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = file;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$loadXML_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    Object object = this.docFactory;
                    document = object != null && (object = ((DocumentBuilderFactory)object).newDocumentBuilder()) != null ? ((DocumentBuilder)object).parse($this$loadXML_u24lambda_u240.inputStream()) : null;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        document = null;
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block18: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block18;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            Document result$iv$iv = document;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            Object object = result$iv$iv;
            return object;
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Failed to read " + file);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Element> filterItems(NodeList $this$filterItems) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$filterItems.getLength());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void index;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($this$filterItems.item((int)index));
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Element)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Instant getProjectLastModifiedTimeFromMetaInfo(NodeList metaInfo) {
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = this.filterItems(metaInfo);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Element item2 = (Element)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)item2.getAttribute("name"), (Object)"projectOpenTimestamp")) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Element element = v0;
        if (element != null) {
            Instant modifiedTime;
            Instant instant;
            Long msecs;
            Element metaInfoOption = element;
            boolean bl = false;
            String string = metaInfoOption.getAttribute("value");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
            Long l = msecs = StringsKt.toLongOrNull((String)string);
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl2 = false;
                return Instant.Companion.fromEpochMilliseconds(it);
            }
            Instant it = instant = (modifiedTime = null);
            boolean bl3 = false;
            Logger.INSTANCE.error("Failed to parse project open timestamp " + metaInfoOption.getAttribute("value"));
            return instant;
        }
        return null;
    }

    public static final /* synthetic */ Object access$getRecentProjectsFilesForInstalledTools(IntelliJProjectScanner $this, Map model2, Map availableTools2, Continuation $completion) {
        return $this.getRecentProjectsFilesForInstalledTools(model2, availableTools2, (Continuation<? super Set<RecentProjectsFile>>)$completion);
    }

    public static final /* synthetic */ Object access$detectProject(IntelliJProjectScanner $this, String project2, Path path2, NodeList metaInfo, Collection sources, Continuation $completion) {
        return $this.detectProject(project2, path2, metaInfo, sources, (Continuation<? super DetectedProject>)$completion);
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(IntelliJProjectScanner $this) {
        return $this.fileSystem;
    }

    public static final /* synthetic */ Object access$readIconWithPriority-lK-al4Y(IntelliJProjectScanner $this, String name2, Path dotIdea, Continuation $completion) {
        return $this.readIconWithPriority-lK-al4Y(name2, dotIdea, (Continuation<? super ImageId>)$completion);
    }
}

