/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.project.devcontainers;

import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DevcontainerProject {
    @NotNull
    public String getId();

    @NotNull
    public String getName();

    @NotNull
    public StateFlow<Details> getDetails();

    @NotNull
    public StateFlow<ContainerStatus> getContainerStatus();

    @NotNull
    public StateFlow<ToolboxAgentStatus> getToolboxAgentStatus();

    @Nullable
    public Object launch(@NotNull Continuation<? super Unit> var1);

    public static sealed interface ContainerStatus {

        public static final class Initial
        implements ContainerStatus {
            @NotNull
            public static final Initial INSTANCE = new Initial();

            private Initial() {
            }

            @NotNull
            public String toString() {
                return "Initial";
            }

            public int hashCode() {
                return -1014567828;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Initial)) {
                    return false;
                }
                Initial cfr_ignored_0 = (Initial)other;
                return true;
            }
        }

        public static final class Running
        implements ContainerStatus {
            @NotNull
            public static final Running INSTANCE = new Running();

            private Running() {
            }

            @NotNull
            public String toString() {
                return "Running";
            }

            public int hashCode() {
                return -1412125977;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Running)) {
                    return false;
                }
                Running cfr_ignored_0 = (Running)other;
                return true;
            }
        }

        public static final class Stopped
        implements ContainerStatus {
            @NotNull
            public static final Stopped INSTANCE = new Stopped();

            private Stopped() {
            }

            @NotNull
            public String toString() {
                return "Stopped";
            }

            public int hashCode() {
                return -552261899;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Stopped)) {
                    return false;
                }
                Stopped cfr_ignored_0 = (Stopped)other;
                return true;
            }
        }

        public static final class Unavailable
        implements ContainerStatus {
            @NotNull
            public static final Unavailable INSTANCE = new Unavailable();

            private Unavailable() {
            }

            @NotNull
            public String toString() {
                return "Unavailable";
            }

            public int hashCode() {
                return 589076856;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unavailable)) {
                    return false;
                }
                Unavailable cfr_ignored_0 = (Unavailable)other;
                return true;
            }
        }
    }

    public static sealed interface Details {

        public static final class Retrieved
        implements Details {
            @Nullable
            private final String projectPath;
            @Nullable
            private final String productCode;
            @Nullable
            private final String buildNumber;

            public Retrieved(@Nullable String projectPath, @Nullable String productCode, @Nullable String buildNumber) {
                this.projectPath = projectPath;
                this.productCode = productCode;
                this.buildNumber = buildNumber;
            }

            @Nullable
            public final String getProjectPath() {
                return this.projectPath;
            }

            @Nullable
            public final String getProductCode() {
                return this.productCode;
            }

            @Nullable
            public final String getBuildNumber() {
                return this.buildNumber;
            }

            @Nullable
            public final String component1() {
                return this.projectPath;
            }

            @Nullable
            public final String component2() {
                return this.productCode;
            }

            @Nullable
            public final String component3() {
                return this.buildNumber;
            }

            @NotNull
            public final Retrieved copy(@Nullable String projectPath, @Nullable String productCode, @Nullable String buildNumber) {
                return new Retrieved(projectPath, productCode, buildNumber);
            }

            public static /* synthetic */ Retrieved copy$default(Retrieved retrieved, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = retrieved.projectPath;
                }
                if ((n & 2) != 0) {
                    string2 = retrieved.productCode;
                }
                if ((n & 4) != 0) {
                    string3 = retrieved.buildNumber;
                }
                return retrieved.copy(string, string2, string3);
            }

            @NotNull
            public String toString() {
                return "Retrieved(projectPath=" + this.projectPath + ", productCode=" + this.productCode + ", buildNumber=" + this.buildNumber + ")";
            }

            public int hashCode() {
                int result2 = this.projectPath == null ? 0 : this.projectPath.hashCode();
                result2 = result2 * 31 + (this.productCode == null ? 0 : this.productCode.hashCode());
                result2 = result2 * 31 + (this.buildNumber == null ? 0 : this.buildNumber.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Retrieved)) {
                    return false;
                }
                Retrieved retrieved = (Retrieved)other;
                if (!Intrinsics.areEqual((Object)this.projectPath, (Object)retrieved.projectPath)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.productCode, (Object)retrieved.productCode)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.buildNumber, (Object)retrieved.buildNumber);
            }
        }

        public static final class Unavailable
        implements Details {
            @NotNull
            public static final Unavailable INSTANCE = new Unavailable();

            private Unavailable() {
            }

            @NotNull
            public String toString() {
                return "Unavailable";
            }

            public int hashCode() {
                return -1595405209;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unavailable)) {
                    return false;
                }
                Unavailable cfr_ignored_0 = (Unavailable)other;
                return true;
            }
        }

        public static final class Unknown
        implements Details {
            @NotNull
            public static final Unknown INSTANCE = new Unknown();

            private Unknown() {
            }

            @NotNull
            public String toString() {
                return "Unknown";
            }

            public int hashCode() {
                return -469007391;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unknown)) {
                    return false;
                }
                Unknown cfr_ignored_0 = (Unknown)other;
                return true;
            }
        }
    }

    public static sealed interface ToolboxAgentStatus {

        public static final class Deploying
        implements ToolboxAgentStatus {
            @NotNull
            public static final Deploying INSTANCE = new Deploying();

            private Deploying() {
            }

            @NotNull
            public String toString() {
                return "Deploying";
            }

            public int hashCode() {
                return 1890012590;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Deploying)) {
                    return false;
                }
                Deploying cfr_ignored_0 = (Deploying)other;
                return true;
            }
        }

        public static final class Initial
        implements ToolboxAgentStatus {
            @NotNull
            public static final Initial INSTANCE = new Initial();

            private Initial() {
            }

            @NotNull
            public String toString() {
                return "Initial";
            }

            public int hashCode() {
                return 1097622551;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Initial)) {
                    return false;
                }
                Initial cfr_ignored_0 = (Initial)other;
                return true;
            }
        }

        public static final class Running
        implements ToolboxAgentStatus {
            @NotNull
            public static final Running INSTANCE = new Running();

            private Running() {
            }

            @NotNull
            public String toString() {
                return "Running";
            }

            public int hashCode() {
                return 700064402;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Running)) {
                    return false;
                }
                Running cfr_ignored_0 = (Running)other;
                return true;
            }
        }

        public static final class Stopped
        implements ToolboxAgentStatus {
            @NotNull
            public static final Stopped INSTANCE = new Stopped();

            private Stopped() {
            }

            @NotNull
            public String toString() {
                return "Stopped";
            }

            public int hashCode() {
                return 1559928480;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Stopped)) {
                    return false;
                }
                Stopped cfr_ignored_0 = (Stopped)other;
                return true;
            }
        }
    }
}

