/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.ui.images.impl;

import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidableCompositionLocal;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.painter.BitmapPainter;
import androidx.compose.ui.graphics.painter.Painter;
import com.jetbrains.toolbox.platform.image.ImageType;
import com.jetbrains.toolbox.platform.image.internal.ImageData;
import com.jetbrains.toolbox.platform.ui.images.SourceImage;
import com.jetbrains.toolbox.platform.ui.images.impl.ImageIdResolver;
import com.jetbrains.toolbox.platform.ui.images.impl.ImageResolver;
import com.jetbrains.toolbox.platform.ui.images.impl.JSvgPainterKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class PaintersKt {
    @ApiStatus.Internal
    @NotNull
    private static final ProvidableCompositionLocal<ImageResolver> LocalImageResolver = CompositionLocalKt.staticCompositionLocalOf(PaintersKt::LocalImageResolver$lambda$0);
    @ApiStatus.Internal
    @NotNull
    private static final ProvidableCompositionLocal<ImageIdResolver> LocalImageIdResolver = CompositionLocalKt.staticCompositionLocalOf(PaintersKt::LocalImageIdResolver$lambda$0);

    @NotNull
    public static final ProvidableCompositionLocal<ImageResolver> getLocalImageResolver() {
        return LocalImageResolver;
    }

    @NotNull
    public static final ProvidableCompositionLocal<ImageIdResolver> getLocalImageIdResolver() {
        return LocalImageIdResolver;
    }

    @Nullable
    public static final SourceImage decode(@NotNull ImageData $this$decode) {
        Intrinsics.checkNotNullParameter((Object)$this$decode, (String)"<this>");
        Painter painter = PaintersKt.decodeToPainter($this$decode);
        if (painter == null) {
            return null;
        }
        Painter painter2 = painter;
        return new SourceImage.PainterSourceImage(painter2, $this$decode.getAllowTint());
    }

    private static final Painter decodeToPainter(ImageData imageData2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[imageData2.getType().ordinal()]) {
            case 1 -> JSvgPainterKt.jSvgPainter(imageData2.getBytes());
            case 2 -> {
                BitmapPainter var1_1;
                try {
                    var1_1 = new BitmapPainter(ImageBitmapKt.decodeToImageBitmap(imageData2.getBytes()), 0L, 0L, 6, null);
                }
                catch (Throwable t) {
                    Logger.INSTANCE.error(t);
                    var1_1 = null;
                }
                yield var1_1;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final ImageResolver LocalImageResolver$lambda$0() {
        throw new IllegalStateException("ImageResolver is not provided.".toString());
    }

    private static final ImageIdResolver LocalImageIdResolver$lambda$0() {
        throw new IllegalStateException("ImageIdResolver is not provided.".toString());
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageType.values().length];
            try {
                nArray[ImageType.SVG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageType.PNG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

