/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.llm.endpoints.functions;

import com.jetbrains.toolbox.platform.llm.endpoints.entities.LlmToolInteractiveRequestEntity;
import com.jetbrains.toolbox.platform.llm.endpoints.functions.FunctionResultContent;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface LlmFunctionUpdateEvent {

    public static final class Error
    implements LlmFunctionUpdateEvent {
        @NotNull
        private final String reason;

        public Error(@NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.reason = reason;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        @NotNull
        public String toString() {
            return "Error(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Error)) {
                return false;
            }
            Error error2 = (Error)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)error2.reason);
        }
    }

    public static final class InteractiveRequest
    implements LlmFunctionUpdateEvent {
        @NotNull
        private final LlmToolInteractiveRequestEntity request;

        public InteractiveRequest(@NotNull LlmToolInteractiveRequestEntity request2) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            this.request = request2;
        }

        @NotNull
        public final LlmToolInteractiveRequestEntity getRequest() {
            return this.request;
        }

        @NotNull
        public String toString() {
            return "InteractiveRequest(request=" + this.request + ")";
        }

        public int hashCode() {
            return this.request.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InteractiveRequest)) {
                return false;
            }
            InteractiveRequest interactiveRequest = (InteractiveRequest)other;
            return Intrinsics.areEqual((Object)this.request, (Object)interactiveRequest.request);
        }
    }

    public static final class Progress
    implements LlmFunctionUpdateEvent {
        private final float progress;
        @Nullable
        private final String stageText;

        public Progress(float progress2, @Nullable String stageText) {
            this.progress = progress2;
            this.stageText = stageText;
        }

        public final float getProgress() {
            return this.progress;
        }

        @NotNull
        public String toString() {
            return "Progress(progress=" + this.progress + ", stageText=" + this.stageText + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.progress);
            result2 = result2 * 31 + (this.stageText == null ? 0 : this.stageText.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Progress)) {
                return false;
            }
            Progress progress2 = (Progress)other;
            if (Float.compare(this.progress, progress2.progress) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stageText, (Object)progress2.stageText);
        }
    }

    public static final class Response
    implements LlmFunctionUpdateEvent {
        @NotNull
        private final List<FunctionResultContent> result;

        public Response(@NotNull List<? extends FunctionResultContent> result2) {
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            this.result = result2;
        }

        @NotNull
        public final List<FunctionResultContent> getResult() {
            return this.result;
        }

        @NotNull
        public String toString() {
            return "Response(result=" + this.result + ")";
        }

        public int hashCode() {
            return ((Object)this.result).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Response)) {
                return false;
            }
            Response response2 = (Response)other;
            return Intrinsics.areEqual(this.result, response2.result);
        }
    }
}

