/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.keychain;

import com.jetbrains.toolbox.platform.keychain.KeychainSecretException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface KeychainSecretState<T> {
    public T getValue();

    public static final class Failure<T>
    implements KeychainSecretState<T> {
        @NotNull
        private final String message;
        @Nullable
        private final Throwable cause;
        private final boolean deleted;

        public Failure(@NotNull String message2, @Nullable Throwable cause, boolean deleted) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.message = message2;
            this.cause = cause;
            this.deleted = deleted;
        }

        public final boolean getDeleted() {
            return this.deleted;
        }

        @Override
        @NotNull
        public Void getValue() {
            if (this.deleted) {
                throw new KeychainSecretException("Secret was deleted: " + this.message, this.cause);
            }
            throw new KeychainSecretException(this.message, this.cause);
        }
    }

    public static final class Value<T>
    implements KeychainSecretState<T> {
        @NotNull
        private final T value;

        public Value(@NotNull T value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            this.value = value2;
        }

        @Override
        @NotNull
        public T getValue() {
            return this.value;
        }
    }
}

