/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.keychain;

import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.ChangeScopeKt;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.toolbox.platform.keychain.KeychainSecretEntityType;
import com.jetbrains.toolbox.platform.keychain.KeychainSecretState;
import fleet.kernel.ReteExtKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KeychainSecret<V>
implements Entity {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final int eid;
    @NotNull
    private final KeychainSecretEntityType<? extends KeychainSecret<V>, V> et;
    @NotNull
    private final Attributes.Required serviceId$delegate;
    @NotNull
    private final Attributes.Required accountId$delegate;
    @NotNull
    private final Attributes.Optional state$delegate;

    public KeychainSecret(int eid2, @NotNull KeychainSecretEntityType<? extends KeychainSecret<V>, V> et) {
        Intrinsics.checkNotNullParameter(et, (String)"et");
        this.eid = eid2;
        this.et = et;
        this.serviceId$delegate = this.getServiceIdAttr();
        this.accountId$delegate = this.getAccountAttr();
        this.state$delegate = this.getStateAttr();
    }

    @Override
    public final int getEid() {
        return this.eid;
    }

    @NotNull
    protected final Attributes.Required<String> getServiceIdAttr() {
        Attributes.Required<String> required = this.et.getServiceIdAttr$keychain();
        Intrinsics.checkNotNull(required, (String)"null cannot be cast to non-null type com.jetbrains.rhizomedb.Attributes.Required<kotlin.String, com.jetbrains.toolbox.platform.keychain.KeychainSecret<V of com.jetbrains.toolbox.platform.keychain.KeychainSecret>>");
        return required;
    }

    @NotNull
    protected final Attributes.Required<String> getAccountAttr() {
        Attributes.Required<String> required = this.et.getAccountIdAttr$keychain();
        Intrinsics.checkNotNull(required, (String)"null cannot be cast to non-null type com.jetbrains.rhizomedb.Attributes.Required<kotlin.String, com.jetbrains.toolbox.platform.keychain.KeychainSecret<V of com.jetbrains.toolbox.platform.keychain.KeychainSecret>>");
        return required;
    }

    private final Attributes.Optional<KeychainSecretState<V>> getStateAttr() {
        Attributes.Optional<KeychainSecretState<V>> optional = this.et.getStateAttr$keychain();
        Intrinsics.checkNotNull(optional, (String)"null cannot be cast to non-null type com.jetbrains.rhizomedb.Attributes.Optional<com.jetbrains.toolbox.platform.keychain.KeychainSecretState<V of com.jetbrains.toolbox.platform.keychain.KeychainSecret>, com.jetbrains.toolbox.platform.keychain.KeychainSecret<V of com.jetbrains.toolbox.platform.keychain.KeychainSecret>>");
        return optional;
    }

    @NotNull
    public final String getServiceId() {
        return (String)this.serviceId$delegate.getValue((Entity)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final String getAccountId() {
        return (String)this.accountId$delegate.getValue((Entity)this, $$delegatedProperties[1]);
    }

    @Nullable
    public final V getSecret() {
        KeychainSecretState<V> keychainSecretState = this.getState$keychain();
        return (V)(keychainSecretState != null ? keychainSecretState.getValue() : null);
    }

    @Nullable
    public final Object awaitSecret(@NotNull Continuation<? super V> $completion) {
        return ReteExtKt.waitForNotNull(() -> KeychainSecret.awaitSecret$lambda$0(this), $completion);
    }

    public final void clearSecret(@NotNull ChangeScope changeScope, @NotNull String message2, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.setState(changeScope, new KeychainSecretState.Failure(message2, cause, true));
    }

    public static /* synthetic */ void clearSecret$default(KeychainSecret keychainSecret, ChangeScope changeScope, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: clearSecret");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        keychainSecret.clearSecret(changeScope, string, throwable);
    }

    public final void setSecret(@NotNull ChangeScope changeScope, @NotNull V value2) {
        Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.setState(changeScope, (KeychainSecretState)new KeychainSecretState.Value<V>(value2));
    }

    public final void setFailure$keychain(@NotNull ChangeScope changeScope, @NotNull String message2, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.setState(changeScope, new KeychainSecretState.Failure(message2, cause, false));
    }

    @Nullable
    public final KeychainSecretState<V> getState$keychain() {
        return (KeychainSecretState)this.state$delegate.getValue((Entity)this, $$delegatedProperties[2]);
    }

    private final void setState(ChangeScope changeScope, KeychainSecretState<V> state2) {
        ChangeScopeKt.set(changeScope, (Entity)this, this.getStateAttr(), state2);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(serviceId=" + this.getServiceId() + ", accountId=" + this.getAccountId() + ")";
    }

    private static final Object awaitSecret$lambda$0(KeychainSecret this$0) {
        return this$0.getSecret();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(KeychainSecret.class, "serviceId", "getServiceId()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(KeychainSecret.class, "accountId", "getAccountId()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(KeychainSecret.class, "state", "getState$keychain()Lcom/jetbrains/toolbox/platform/keychain/KeychainSecretState;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

