/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.interop.NativeInteropMacOs;
import com.jetbrains.toolbox.interop.Win32Kernel32;
import com.jetbrains.toolbox.platform.CpuArch;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class Platform {
    @NotNull
    public static final Platform INSTANCE = new Platform();
    @NotNull
    private static final Lazy cpuArch$delegate = LazyKt.lazy(Platform::cpuArch_delegate$lambda$0);
    @NotNull
    private static final WinDef.USHORT IMAGE_FILE_MACHINE_ARM64 = new WinDef.USHORT(43620L);

    private Platform() {
    }

    @NotNull
    public final CpuArch getCpuArch() {
        Lazy lazy = cpuArch$delegate;
        return (CpuArch)((Object)lazy.getValue());
    }

    private final boolean isArm() {
        return com.sun.jna.Platform.isARM() || this.isRunningUnderEmulator();
    }

    public final boolean isRunningUnderEmulator() {
        return switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
            case 1 -> NativeInteropMacOs.INSTANCE.processIsTranslated();
            case 2 -> this.isWoWArm();
            case 3 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isWoWArm() {
        boolean bl;
        try {
            WinDef.USHORTByReference processMachine = new WinDef.USHORTByReference();
            WinDef.USHORTByReference nativeMachine = new WinDef.USHORTByReference();
            Win32Kernel32 win32Kernel32 = (Win32Kernel32)Native.load((String)"Kernel32", Win32Kernel32.class, (Map)W32APIOptions.UNICODE_OPTIONS);
            if (win32Kernel32 == null) {
                return false;
            }
            Win32Kernel32 kernel32 = win32Kernel32;
            WinNT.HANDLE hANDLE = Kernel32.INSTANCE.GetCurrentProcess();
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"GetCurrentProcess(...)");
            bl = kernel32.IsWow64Process2(hANDLE, processMachine, nativeMachine) && Intrinsics.areEqual((Object)nativeMachine.getValue(), (Object)IMAGE_FILE_MACHINE_ARM64);
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to load Kernel32.IsWow64Process2 method");
            bl = false;
        }
        return bl;
    }

    private static final CpuArch cpuArch_delegate$lambda$0() {
        return INSTANCE.isArm() ? CpuArch.ARM64 : CpuArch.X86_64;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Mac.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

