/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.packageextractor;

import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.common.FileExtension;
import com.jetbrains.toolbox.common.io.Copy_and_moveKt;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.packageextractor.MacOsDmgExtractor;
import com.jetbrains.toolbox.packageextractor.NonStrippingExtractor;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nMacOsDmgExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacOsDmgExtractor.kt\ncom/jetbrains/toolbox/packageextractor/MacOsDmgExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n295#2,2:70\n*S KotlinDebug\n*F\n+ 1 MacOsDmgExtractor.kt\ncom/jetbrains/toolbox/packageextractor/MacOsDmgExtractor\n*L\n66#1:70,2\n*E\n"})
public final class MacOsDmgExtractor
implements NonStrippingExtractor {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final ProcessRunner processRunner;
    @NotNull
    private final ShellEnvironment shellEnvironment;
    @NotNull
    private final FileUtils fileUtils;

    public MacOsDmgExtractor(@NotNull FileSystem fileSystem, @NotNull ProcessRunner processRunner, @NotNull ShellEnvironment shellEnvironment, @NotNull FileUtils fileUtils) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)processRunner, (String)"processRunner");
        Intrinsics.checkNotNullParameter((Object)shellEnvironment, (String)"shellEnvironment");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        this.fileSystem = fileSystem;
        this.processRunner = processRunner;
        this.shellEnvironment = shellEnvironment;
        this.fileUtils = fileUtils;
    }

    @Override
    @NotNull
    public Set<FileExtension> getSupportedArchiveExtensions() {
        return SetsKt.setOf((Object)FileExtension.box-impl(FileExtension.constructor-impl("dmg")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object extract(@NotNull Path archive, @NotNull Path destinationDirectory, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof extract.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ MacOsDmgExtractor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.extract(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.shellEnvironment.findExecutable("hdiutil");
                if (v0 == null) {
                    v0 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/usr/bin/hdiutil", (boolean)false, (int)1, null);
                }
                hdiUtil = v0;
                mountedDir = this.fileUtils.getTempDirectory("toolbox-dmg-" + StringsKt.removeSuffix((String)archive.name(), (CharSequence)".dmg"));
                Logger.INSTANCE.info("Mounting image into " + mountedDir);
                if (this.fileSystem.exists(mountedDir) && ((Collection)this.fileSystem.list(mountedDir)).isEmpty() == false) {
                    var6_9 = new String[]{"detach", "-force", mountedDir.toString()};
                    ProcessRunner.executeProcessAndWait-9VgGkz4$default(this.processRunner, hdiUtil.toFile(), CollectionsKt.listOf((Object[])var6_9), null, null, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), 12, null);
                }
                this.fileSystem.createDirectory(mountedDir);
                var6_9 = new String[]{"attach", "-readonly", "-noautoopen", "-noautofsck", "-noverify", "-nobrowse", "-mountpoint", mountedDir.toString(), archive.toString()};
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)archive);
                $continuation.L$1 = destinationDirectory;
                $continuation.L$2 = hdiUtil;
                $continuation.L$3 = mountedDir;
                $continuation.label = 1;
                v1 = ProcessRunner.runProcessCancellable$default(this.processRunner, hdiUtil, CollectionsKt.listOf((Object[])var6_9), null, null, (Continuation)$continuation, 12, null);
                ** if (v1 != var10_6) goto lbl34
lbl33:
                // 1 sources

                return var10_6;
lbl34:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                mountedDir = (Path)$continuation.L$3;
                hdiUtil = (Path)$continuation.L$2;
                destinationDirectory = (Path)$continuation.L$1;
                archive = (Path)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl44:
                    // 2 sources

                    Copy_and_moveKt.copyRecursively$default(this.fileSystem, this.resolveDirToCopy(mountedDir), destinationDirectory, null, false, 0, 28, null);
                }
                catch (Throwable var6_11) {
                    try {
                        var7_12 = new String[]{"detach", "-force", mountedDir.toString()};
                        ProcessRunner.executeProcessAndWait-9VgGkz4$default(this.processRunner, hdiUtil.toFile(), CollectionsKt.listOf((Object[])var7_12), null, null, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), 12, null);
                        this.fileSystem.delete(mountedDir);
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.error((Throwable)e, "Cannot unmount dmg " + mountedDir);
                    }
                    throw var6_11;
                }
                try {
                    var6_9 = new String[]{"detach", "-force", mountedDir.toString()};
                    ProcessRunner.executeProcessAndWait-9VgGkz4$default(this.processRunner, hdiUtil.toFile(), CollectionsKt.listOf((Object[])var6_9), null, null, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), 12, null);
                    this.fileSystem.delete(mountedDir);
                }
                catch (Exception e) {
                    Logger.INSTANCE.error((Throwable)e, "Cannot unmount dmg " + mountedDir);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Path resolveDirToCopy(Path mountedDir) {
        Path path2;
        Object v2;
        block5: {
            List listing = this.fileSystem.listOrNull(mountedDir);
            Collection collection = listing;
            if (collection == null || collection.isEmpty()) {
                return mountedDir;
            }
            if (listing.size() == 1 && Intrinsics.areEqual((Object)((Path)CollectionsKt.single((List)listing)).name(), (Object)"Contents")) {
                FileMetadata fileMetadata2 = this.fileSystem.metadataOrNull((Path)CollectionsKt.single((List)listing));
                boolean bl = fileMetadata2 != null ? fileMetadata2.isDirectory() : false;
                if (bl) {
                    return (Path)CollectionsKt.single((List)listing);
                }
            }
            Iterable $this$firstOrNull$iv = listing;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!StringsKt.endsWith$default((String)it.name(), (String)".app", (boolean)false, (int)2, null)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        if ((path2 = (Path)v2) == null) {
            path2 = mountedDir;
        }
        return path2;
    }
}

