/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.openssh;

import com.jetbrains.toolbox.openssh.SshExecutableType;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SshExecutableValidator {
    @NotNull
    public Result validate(@NotNull String var1);

    public static sealed interface Result {

        public static final class Failure
        implements Result {
            @NotNull
            public static final Failure INSTANCE = new Failure();

            private Failure() {
            }

            @NotNull
            public String toString() {
                return "Failure";
            }

            public int hashCode() {
                return 1387280663;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failure)) {
                    return false;
                }
                Failure cfr_ignored_0 = (Failure)other;
                return true;
            }
        }

        public static final class Success
        implements Result {
            @NotNull
            private final SshExecutableType clientType;
            @NotNull
            private final String version;

            public Success(@NotNull SshExecutableType clientType, @NotNull String version) {
                Intrinsics.checkNotNullParameter((Object)((Object)clientType), (String)"clientType");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                this.clientType = clientType;
                this.version = version;
            }

            @NotNull
            public final SshExecutableType getClientType() {
                return this.clientType;
            }

            @NotNull
            public final String getVersion() {
                return this.version;
            }

            @NotNull
            public String toString() {
                return "Success(clientType=" + this.clientType + ", version=" + this.version + ")";
            }

            public int hashCode() {
                int result2 = this.clientType.hashCode();
                result2 = result2 * 31 + this.version.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success2 = (Success)other;
                if (this.clientType != success2.clientType) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.version, (Object)success2.version);
            }
        }
    }
}

