/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.openssh;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface SshAddResult {

    public static final class CancelledByUser
    implements SshAddResult {
        @NotNull
        public static final CancelledByUser INSTANCE = new CancelledByUser();

        private CancelledByUser() {
        }

        @NotNull
        public String toString() {
            return "CancelledByUser";
        }

        public int hashCode() {
            return 417154219;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CancelledByUser)) {
                return false;
            }
            CancelledByUser cfr_ignored_0 = (CancelledByUser)other;
            return true;
        }
    }

    public static final class Failure
    implements SshAddResult {
        private final int exitCode;
        @NotNull
        private final String errorMessage;

        public Failure(int exitCode, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            this.exitCode = exitCode;
            this.errorMessage = errorMessage;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @NotNull
        public String toString() {
            return "Failure(exitCode=" + this.exitCode + ", errorMessage=" + this.errorMessage + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.exitCode);
            result2 = result2 * 31 + this.errorMessage.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Failure)) {
                return false;
            }
            Failure failure = (Failure)other;
            if (this.exitCode != failure.exitCode) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.errorMessage, (Object)failure.errorMessage);
        }
    }

    public static final class Success
    implements SshAddResult {
        @NotNull
        public static final Success INSTANCE = new Success();

        private Success() {
        }

        @NotNull
        public String toString() {
            return "Success";
        }

        public int hashCode() {
            return -379994309;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success cfr_ignored_0 = (Success)other;
            return true;
        }
    }
}

